/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.ds.common;

import com.kaiwudb.ds.KWConnectionPoolDataSource;
import com.kaiwudb.ds.KWPoolingDataSource;
import com.kaiwudb.ds.KWSimpleDataSource;
import com.kaiwudb.ds.common.BaseDataSource;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class KWObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String className = ref.getClassName();
        if (className.equals("KWSimpleDataSource") || className.equals("SimpleDataSource") || className.equals("Jdbc3SimpleDataSource")) {
            return this.loadSimpleDataSource(ref);
        }
        if (className.equals("KWConnectionPoolDataSource") || className.equals("ConnectionPool") || className.equals("Jdbc3ConnectionPool")) {
            return this.loadConnectionPool(ref);
        }
        if (className.equals("KWPoolingDataSource") || className.equals("PoolingDataSource") || className.equals("Jdbc3PoolingDataSource")) {
            return this.loadPoolingDataSource(ref);
        }
        return null;
    }

    private Object loadPoolingDataSource(Reference ref) {
        String max;
        String name = this.getProperty(ref, "dataSourceName");
        KWPoolingDataSource pds = KWPoolingDataSource.getDataSource(name);
        if (pds != null) {
            return pds;
        }
        pds = new KWPoolingDataSource();
        pds.setDataSourceName(name);
        this.loadBaseDataSource(pds, ref);
        String min = this.getProperty(ref, "initialConnections");
        if (min != null) {
            pds.setInitialConnections(Integer.parseInt(min));
        }
        if ((max = this.getProperty(ref, "maxConnections")) != null) {
            pds.setMaxConnections(Integer.parseInt(max));
        }
        return pds;
    }

    private Object loadSimpleDataSource(Reference ref) {
        KWSimpleDataSource ds = new KWSimpleDataSource();
        return this.loadBaseDataSource(ds, ref);
    }

    private Object loadConnectionPool(Reference ref) {
        KWConnectionPoolDataSource cp = new KWConnectionPoolDataSource();
        return this.loadBaseDataSource(cp, ref);
    }

    protected Object loadBaseDataSource(BaseDataSource ds, Reference ref) {
        ds.setFromReference(ref);
        return ds;
    }

    protected String getProperty(Reference ref, String s) {
        RefAddr addr = ref.get(s);
        if (addr == null) {
            return null;
        }
        return (String)addr.getContent();
    }
}

