/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.geometric;

import com.kaiwudb.geometric.KWpoint;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import com.kaiwudb.util.KWBinaryObject;
import com.kaiwudb.util.KWobject;
import com.kaiwudb.util.KWtokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class KWbox
extends KWobject
implements KWBinaryObject,
Serializable,
Cloneable {
    public KWpoint[] point = new KWpoint[2];

    public KWbox(double x1, double y1, double x2, double y2) {
        this();
        this.point[0] = new KWpoint(x1, y1);
        this.point[1] = new KWpoint(x2, y2);
    }

    public KWbox(KWpoint p1, KWpoint p2) {
        this();
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public KWbox(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public KWbox() {
        this.setType("box");
    }

    @Override
    public void setValue(String value) throws SQLException {
        KWtokenizer t = new KWtokenizer(value, ',');
        if (t.getSize() != 2) {
            throw new KSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, value), KSQLState.DATA_TYPE_MISMATCH);
        }
        this.point[0] = new KWpoint(t.getToken(0));
        this.point[1] = new KWpoint(t.getToken(1));
    }

    @Override
    public void setByteValue(byte[] b, int offset) {
        this.point[0] = new KWpoint();
        this.point[0].setByteValue(b, offset);
        this.point[1] = new KWpoint();
        this.point[1].setByteValue(b, offset + this.point[0].lengthInBytes());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KWbox) {
            KWbox p = (KWbox)obj;
            if (p.point[0].equals(this.point[0]) && p.point[1].equals(this.point[1])) {
                return true;
            }
            if (p.point[0].equals(this.point[1]) && p.point[1].equals(this.point[0])) {
                return true;
            }
            if (p.point[0].x == this.point[0].x && p.point[0].y == this.point[1].y && p.point[1].x == this.point[1].x && p.point[1].y == this.point[0].y) {
                return true;
            }
            if (p.point[0].x == this.point[1].x && p.point[0].y == this.point[0].y && p.point[1].x == this.point[0].x && p.point[1].y == this.point[1].y) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.point[0].hashCode() ^ this.point[1].hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        KWbox newKWbox = (KWbox)super.clone();
        if (newKWbox.point != null) {
            newKWbox.point = (KWpoint[])newKWbox.point.clone();
            for (int i = 0; i < newKWbox.point.length; ++i) {
                if (newKWbox.point[i] == null) continue;
                newKWbox.point[i] = (KWpoint)newKWbox.point[i].clone();
            }
        }
        return newKWbox;
    }

    @Override
    public String getValue() {
        return this.point[0].toString() + "," + this.point[1].toString();
    }

    @Override
    public int lengthInBytes() {
        return this.point[0].lengthInBytes() + this.point[1].lengthInBytes();
    }

    @Override
    public void toBytes(byte[] bytes, int offset) {
        this.point[0].toBytes(bytes, offset);
        this.point[1].toBytes(bytes, offset + this.point[0].lengthInBytes());
    }
}

