/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.geometric;

import com.kaiwudb.geometric.KWpoint;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import com.kaiwudb.util.KWobject;
import com.kaiwudb.util.KWtokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class KWcircle
extends KWobject
implements Serializable,
Cloneable {
    public KWpoint center;
    public double radius;

    public KWcircle(double x, double y, double r) {
        this(new KWpoint(x, y), r);
    }

    public KWcircle(KWpoint c, double r) {
        this();
        this.center = c;
        this.radius = r;
    }

    public KWcircle(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public KWcircle() {
        this.setType("circle");
    }

    @Override
    public void setValue(String s) throws SQLException {
        KWtokenizer t = new KWtokenizer(KWtokenizer.removeAngle(s), ',');
        if (t.getSize() != 2) {
            throw new KSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), KSQLState.DATA_TYPE_MISMATCH);
        }
        try {
            this.center = new KWpoint(t.getToken(0));
            this.radius = Double.parseDouble(t.getToken(1));
        }
        catch (NumberFormatException e) {
            throw new KSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), KSQLState.DATA_TYPE_MISMATCH, (Throwable)e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KWcircle) {
            KWcircle p = (KWcircle)obj;
            return p.center.equals(this.center) && p.radius == this.radius;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long v = Double.doubleToLongBits(this.radius);
        return (int)((long)this.center.hashCode() ^ v ^ v >>> 32);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        KWcircle newKWcircle = (KWcircle)super.clone();
        if (newKWcircle.center != null) {
            newKWcircle.center = (KWpoint)newKWcircle.center.clone();
        }
        return newKWcircle;
    }

    @Override
    public String getValue() {
        return "<" + this.center + "," + this.radius + ">";
    }
}

