/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.geometric;

import com.kaiwudb.geometric.KWlseg;
import com.kaiwudb.geometric.KWpoint;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import com.kaiwudb.util.KWobject;
import com.kaiwudb.util.KWtokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class KWline
extends KWobject
implements Serializable,
Cloneable {
    public double a;
    public double b;
    public double c;

    public KWline(double a, double b, double c) {
        this();
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public KWline(double x1, double y1, double x2, double y2) {
        this();
        if (x1 == x2) {
            this.a = -1.0;
            this.b = 0.0;
        } else {
            this.a = (y2 - y1) / (x2 - x1);
            this.b = -1.0;
        }
        this.c = y1 - this.a * x1;
    }

    public KWline(KWpoint p1, KWpoint p2) {
        this(p1.x, p1.y, p2.x, p2.y);
    }

    public KWline(KWlseg lseg) {
        this(lseg.point[0], lseg.point[1]);
    }

    public KWline(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public KWline() {
        this.setType("line");
    }

    @Override
    public void setValue(String s) throws SQLException {
        if (s.trim().startsWith("{")) {
            KWtokenizer t = new KWtokenizer(KWtokenizer.removeCurlyBrace(s), ',');
            if (t.getSize() != 3) {
                throw new KSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), KSQLState.DATA_TYPE_MISMATCH);
            }
            this.a = Double.parseDouble(t.getToken(0));
            this.b = Double.parseDouble(t.getToken(1));
            this.c = Double.parseDouble(t.getToken(2));
        } else if (s.trim().startsWith("[")) {
            KWtokenizer t = new KWtokenizer(KWtokenizer.removeBox(s), ',');
            if (t.getSize() != 2) {
                throw new KSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), KSQLState.DATA_TYPE_MISMATCH);
            }
            KWpoint point1 = new KWpoint(t.getToken(0));
            KWpoint point2 = new KWpoint(t.getToken(1));
            this.a = point2.x - point1.x;
            this.b = point2.y - point1.y;
            this.c = point1.y;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        KWline kWline = (KWline)obj;
        return Double.compare(kWline.a, this.a) == 0 && Double.compare(kWline.b, this.b) == 0 && Double.compare(kWline.c, this.c) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.a);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.b);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.c);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String getValue() {
        return "{" + this.a + "," + this.b + "," + this.c + "}";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

