/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.geometric;

import com.kaiwudb.geometric.KWpoint;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import com.kaiwudb.util.KWobject;
import com.kaiwudb.util.KWtokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class KWpath
extends KWobject
implements Serializable,
Cloneable {
    public boolean open;
    public KWpoint[] points;

    public KWpath(KWpoint[] points, boolean open) {
        this();
        this.points = points;
        this.open = open;
    }

    public KWpath() {
        this.setType("path");
    }

    public KWpath(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    @Override
    public void setValue(String s) throws SQLException {
        if (s.startsWith("[") && s.endsWith("]")) {
            this.open = true;
            s = KWtokenizer.removeBox(s);
        } else if (s.startsWith("(") && s.endsWith(")")) {
            this.open = false;
            s = KWtokenizer.removePara(s);
        } else {
            throw new KSQLException(GT.tr("Cannot tell if path is open or closed: {0}.", s), KSQLState.DATA_TYPE_MISMATCH);
        }
        KWtokenizer t = new KWtokenizer(s, ',');
        int npoints = t.getSize();
        this.points = new KWpoint[npoints];
        for (int p = 0; p < npoints; ++p) {
            this.points[p] = new KWpoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KWpath) {
            KWpath p = (KWpath)obj;
            if (p.points.length != this.points.length) {
                return false;
            }
            if (p.open != this.open) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(p.points[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            hash ^= this.points[i].hashCode();
        }
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        KWpath newKWpath = (KWpath)super.clone();
        if (newKWpath.points != null) {
            newKWpath.points = (KWpoint[])newKWpath.points.clone();
            for (int i = 0; i < newKWpath.points.length; ++i) {
                newKWpath.points[i] = (KWpoint)newKWpath.points[i].clone();
            }
        }
        return newKWpath;
    }

    @Override
    public String getValue() {
        StringBuilder b = new StringBuilder(this.open ? "[" : "(");
        for (int p = 0; p < this.points.length; ++p) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.points[p].toString());
        }
        b.append(this.open ? "]" : ")");
        return b.toString();
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public void closePath() {
        this.open = false;
    }

    public void openPath() {
        this.open = true;
    }
}

