/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.geometric;

import com.kaiwudb.geometric.KWpoint;
import com.kaiwudb.util.KWobject;
import com.kaiwudb.util.KWtokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class KWpolygon
extends KWobject
implements Serializable,
Cloneable {
    public KWpoint[] points;

    public KWpolygon(KWpoint[] points) {
        this();
        this.points = points;
    }

    public KWpolygon(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public KWpolygon() {
        this.setType("polygon");
    }

    @Override
    public void setValue(String s) throws SQLException {
        KWtokenizer t = new KWtokenizer(KWtokenizer.removePara(s), ',');
        int npoints = t.getSize();
        this.points = new KWpoint[npoints];
        for (int p = 0; p < npoints; ++p) {
            this.points[p] = new KWpoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KWpolygon) {
            KWpolygon p = (KWpolygon)obj;
            if (p.points.length != this.points.length) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(p.points[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            hash ^= this.points[i].hashCode();
        }
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        KWpolygon newKWpolygon = (KWpolygon)super.clone();
        if (newKWpolygon.points != null) {
            newKWpolygon.points = (KWpoint[])newKWpolygon.points.clone();
            for (int i = 0; i < newKWpolygon.points.length; ++i) {
                if (newKWpolygon.points[i] == null) continue;
                newKWpolygon.points[i] = (KWpoint)newKWpolygon.points[i].clone();
            }
        }
        return newKWpolygon;
    }

    @Override
    public String getValue() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        for (int p = 0; p < this.points.length; ++p) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.points[p].toString());
        }
        b.append(")");
        return b.toString();
    }
}

