/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.gss;

import com.kaiwudb.core.KWStream;
import com.kaiwudb.gss.GSSCallbackHandler;
import com.kaiwudb.gss.GssAction;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import java.io.IOException;
import java.security.AccessController;
import java.sql.SQLException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSCredential;

public class MakeGSS {
    private static final Logger LOGGER = Logger.getLogger(MakeGSS.class.getName());

    public static void authenticate(KWStream kwStream, String host, String user, String password, String jaasApplicationName, String kerberosServerName, boolean useSpnego, boolean jaasLogin, boolean logServerErrorDetail) throws IOException, SQLException {
        Exception result;
        LOGGER.log(Level.FINEST, " <=BE AuthenticationReqGSS");
        if (jaasApplicationName == null) {
            jaasApplicationName = "kaiwudb-jdbc";
        }
        if (kerberosServerName == null) {
            kerberosServerName = "kaiwudb";
        }
        try {
            Set<GSSCredential> gssCreds;
            boolean performAuthentication = jaasLogin;
            GSSCredential gssCredential = null;
            Subject sub = Subject.getSubject(AccessController.getContext());
            if (sub != null && (gssCreds = sub.getPrivateCredentials(GSSCredential.class)) != null && !gssCreds.isEmpty()) {
                gssCredential = gssCreds.iterator().next();
                performAuthentication = false;
            }
            if (performAuthentication) {
                LoginContext lc = new LoginContext(jaasApplicationName, new GSSCallbackHandler(user, password));
                lc.login();
                sub = lc.getSubject();
            }
            GssAction action = new GssAction(kwStream, gssCredential, host, user, kerberosServerName, useSpnego, logServerErrorDetail);
            result = Subject.doAs(sub, action);
        }
        catch (Exception e) {
            throw new KSQLException(GT.tr("GSS Authentication failed", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        if (result instanceof IOException) {
            throw (IOException)result;
        }
        if (result instanceof SQLException) {
            throw (SQLException)result;
        }
        if (result != null) {
            throw new KSQLException(GT.tr("GSS Authentication failed", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)result);
        }
    }
}

