/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.jdbc;

import com.kaiwudb.core.Utils;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import java.sql.SQLException;
import java.sql.Savepoint;

public class KSQLSavepoint
implements Savepoint {
    private boolean isValid = true;
    private final boolean isNamed;
    private int id;
    private String name;

    public KSQLSavepoint(int id) {
        this.isNamed = false;
        this.id = id;
    }

    public KSQLSavepoint(String name) {
        this.isNamed = true;
        this.name = name;
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (!this.isValid) {
            throw new KSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), KSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this.isNamed) {
            throw new KSQLException(GT.tr("Cannot retrieve the id of a named savepoint.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
        }
        return this.id;
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (!this.isValid) {
            throw new KSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), KSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (!this.isNamed) {
            throw new KSQLException(GT.tr("Cannot retrieve the name of an unnamed savepoint.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
        }
        return this.name;
    }

    public void invalidate() {
        this.isValid = false;
    }

    public String getKWName() throws SQLException {
        if (!this.isValid) {
            throw new KSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), KSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this.isNamed) {
            return Utils.escapeIdentifier(null, this.name).toString();
        }
        return "JDBC_SAVEPOINT_" + this.id;
    }
}

