/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.jdbc;

import com.kaiwudb.core.BaseConnection;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class KwParameterMetaData
implements ParameterMetaData {
    private final BaseConnection connection;
    private final int[] oids;

    public KwParameterMetaData(BaseConnection connection, int[] oids) {
        this.connection = connection;
        this.oids = oids;
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkParamIndex(param);
        return this.connection.getTypeInfo().getJavaClass(this.oids[param - 1]);
    }

    @Override
    public int getParameterCount() {
        return this.oids.length;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkParamIndex(param);
        return 1;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkParamIndex(param);
        return this.connection.getTypeInfo().getSQLType(this.oids[param - 1]);
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkParamIndex(param);
        return this.connection.getTypeInfo().getKWType(this.oids[param - 1]);
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkParamIndex(param);
        return 0;
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkParamIndex(param);
        return 0;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkParamIndex(param);
        return 2;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkParamIndex(param);
        return this.connection.getTypeInfo().isSigned(this.oids[param - 1]);
    }

    private void checkParamIndex(int param) throws KSQLException {
        if (param < 1 || param > this.oids.length) {
            throw new KSQLException(GT.tr("The parameter index is out of range: {0}, number of parameters: {1}.", param, this.oids.length), KSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }
}

