/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.jdbc;

import com.kaiwudb.core.BaseConnection;
import com.kaiwudb.core.BaseStatement;
import com.kaiwudb.core.ServerVersion;
import com.kaiwudb.core.TypeInfo;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import com.kaiwudb.util.KWobject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TypeInfoCache
implements TypeInfo {
    private Map<String, Integer> kwNameToSQLType;
    private Map<String, String> kwNameToJavaClass;
    private Map<Integer, String> oidToKwName;
    private Map<String, Integer> kwNameToOid;
    private Map<String, Class<? extends KWobject>> kwNameToKwObject;
    private Map<Integer, Integer> kwArrayToKwType;
    private Map<Integer, Character> arrayOidToDelimiter;
    private BaseConnection conn;
    private final int unknownLength;
    private PreparedStatement getOidStatementSimple;
    private PreparedStatement getOidStatementComplexNonArray;
    private PreparedStatement getOidStatementComplexArray;
    private PreparedStatement getNameStatement;
    private PreparedStatement getArrayElementOidStatement;
    private PreparedStatement getArrayDelimiterStatement;
    private PreparedStatement getTypeInfoStatement;
    private static final Object[][] types = new Object[][]{{"int2", 21, 5, "java.lang.Integer", 1005}, {"int4", 23, 4, "java.lang.Integer", 1007}, {"oid", 26, -5, "java.lang.Long", 1028}, {"int8", 20, -5, "java.lang.Long", 1016}, {"money", 790, 8, "java.lang.Double", 791}, {"numeric", 1700, 2, "java.math.BigDecimal", 1231}, {"float4", 700, 7, "java.lang.Float", 1021}, {"float8", 701, 8, "java.lang.Double", 1022}, {"char", 18, 1, "java.lang.String", 1002}, {"bpchar", 1042, 1, "java.lang.String", 1014}, {"varchar", 1043, 12, "java.lang.String", 1015}, {"nchar", 91002, -15, "java.lang.String", 91003}, {"nvarchar", 91004, -9, "java.lang.String", 91005}, {"geometry", 91008, 12, "java.lang.String", 91009}, {"text", 25, 12, "java.lang.String", 1009}, {"name", 19, 12, "java.lang.String", 1003}, {"bytea", 17, -2, "[B", 1001}, {"varbytea", 91006, -3, "[B", 91007}, {"bool", 16, -7, "java.lang.Boolean", 1000}, {"bit", 1560, -7, "java.lang.Boolean", 1561}, {"date", 1082, 91, "java.sql.Date", 1182}, {"time", 1083, 92, "java.sql.Time", 1183}, {"timetz", 1266, 92, "java.sql.Time", 1270}, {"timestamp", 1114, 93, "java.sql.Timestamp", 1115}, {"timestamptz", 1184, 93, "java.sql.Timestamp", 1185}, {"refcursor", 1790, 2012, "java.sql.ResultSet", 2201}, {"json", 114, 1111, "com.kaiwudb.util.KWobject", 199}, {"point", 600, 1111, "com.kaiwudb.geometric.KWpoint", 1017}};
    private static final HashMap<String, String> typeAliases = new HashMap();

    public TypeInfoCache(BaseConnection conn, int unknownLength) {
        this.conn = conn;
        this.unknownLength = unknownLength;
        this.oidToKwName = new HashMap<Integer, String>((int)Math.round((double)types.length * 1.5));
        this.kwNameToOid = new HashMap<String, Integer>((int)Math.round((double)types.length * 1.5));
        this.kwNameToJavaClass = new HashMap<String, String>((int)Math.round((double)types.length * 1.5));
        this.kwNameToKwObject = new HashMap<String, Class<? extends KWobject>>((int)Math.round((double)types.length * 1.5));
        this.kwArrayToKwType = new HashMap<Integer, Integer>((int)Math.round((double)types.length * 1.5));
        this.arrayOidToDelimiter = new HashMap<Integer, Character>((int)Math.round((double)types.length * 2.5));
        this.kwNameToSQLType = Collections.synchronizedMap(new HashMap((int)Math.round((double)types.length * 1.5)));
        for (Object[] type : types) {
            String kwTypeName = (String)type[0];
            Integer oid = (Integer)type[1];
            Integer sqlType = (Integer)type[2];
            String javaClass = (String)type[3];
            Integer arrayOid = (Integer)type[4];
            this.addCoreType(kwTypeName, oid, sqlType, javaClass, arrayOid);
        }
        this.kwNameToJavaClass.put("hstore", Map.class.getName());
    }

    @Override
    public synchronized void addCoreType(String kwTypeName, Integer oid, Integer sqlType, String javaClass, Integer arrayOid) {
        this.kwNameToJavaClass.put(kwTypeName, javaClass);
        this.kwNameToOid.put(kwTypeName, oid);
        this.oidToKwName.put(oid, kwTypeName);
        this.kwArrayToKwType.put(arrayOid, oid);
        this.kwNameToSQLType.put(kwTypeName, sqlType);
        Character delim = Character.valueOf(',');
        this.arrayOidToDelimiter.put(oid, delim);
        this.arrayOidToDelimiter.put(arrayOid, delim);
        String kwArrayTypeName = kwTypeName + "[]";
        this.kwNameToJavaClass.put(kwArrayTypeName, "java.sql.Array");
        this.kwNameToSQLType.put(kwArrayTypeName, 2003);
        this.kwNameToOid.put(kwArrayTypeName, arrayOid);
        kwArrayTypeName = "_" + kwTypeName;
        if (!this.kwNameToJavaClass.containsKey(kwArrayTypeName)) {
            this.kwNameToJavaClass.put(kwArrayTypeName, "java.sql.Array");
            this.kwNameToSQLType.put(kwArrayTypeName, 2003);
            this.kwNameToOid.put(kwArrayTypeName, arrayOid);
            this.oidToKwName.put(arrayOid, kwArrayTypeName);
        }
    }

    @Override
    public synchronized void addDataType(String type, Class<? extends KWobject> klass) throws SQLException {
        this.kwNameToKwObject.put(type, klass);
        this.kwNameToJavaClass.put(type, klass.getName());
    }

    @Override
    public Iterator<String> getKWTypeNamesWithSQLTypes() {
        return this.kwNameToSQLType.keySet().iterator();
    }

    @Override
    public int getSQLType(int oid) throws SQLException {
        return this.getSQLType(this.getKWType(oid));
    }

    @Override
    public synchronized int getSQLType(String kwTypeName) throws SQLException {
        if (kwTypeName.endsWith("[]")) {
            return 2003;
        }
        Integer i = this.kwNameToSQLType.get(kwTypeName);
        if (i != null) {
            return i;
        }
        if (this.getTypeInfoStatement == null) {
            String sql = "SELECT typinput='array_in'::regproc, typtype   FROM pg_catalog.pg_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname                    from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  WHERE typname = ?  ORDER BY sp.r, pg_type.oid DESC LIMIT 1;";
            this.getTypeInfoStatement = this.conn.prepareStatement(sql);
        }
        this.getTypeInfoStatement.setString(1, kwTypeName);
        if (!((BaseStatement)((Object)this.getTypeInfoStatement)).executeWithFlags(16)) {
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        ResultSet rs = this.getTypeInfoStatement.getResultSet();
        Integer type = null;
        if (rs.next()) {
            boolean isArray = rs.getBoolean(1);
            String typtype = rs.getString(2);
            if (isArray) {
                type = 2003;
            } else if ("c".equals(typtype)) {
                type = 2002;
            } else if ("d".equals(typtype)) {
                type = 2001;
            } else if ("e".equals(typtype)) {
                type = 12;
            }
        }
        if (type == null) {
            type = 1111;
        }
        rs.close();
        this.kwNameToSQLType.put(kwTypeName, type);
        return type;
    }

    private PreparedStatement getOidStatement(String kwTypeName) throws SQLException {
        String name;
        String schema;
        String fullName;
        PreparedStatement oidStatementComplex;
        String sql;
        boolean isArray = kwTypeName.endsWith("[]");
        boolean hasQuote = kwTypeName.contains("\"");
        int dotIndex = kwTypeName.indexOf(46);
        if (dotIndex == -1 && !hasQuote && !isArray) {
            if (this.getOidStatementSimple == null) {
                String sql2 = "SELECT pg_type.oid, typname   FROM pg_catalog.pg_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname                    from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  WHERE typname = ?  ORDER BY sp.r, pg_type.oid DESC LIMIT 1;";
                this.getOidStatementSimple = this.conn.prepareStatement(sql2);
            }
            String lcName = kwTypeName.toLowerCase();
            this.getOidStatementSimple.setString(1, lcName);
            return this.getOidStatementSimple;
        }
        if (isArray) {
            if (this.getOidStatementComplexArray == null) {
                sql = this.conn.haveMinimumServerVersion(ServerVersion.v8_3) ? "SELECT t.typarray, arr.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid  JOIN pg_catalog.pg_type arr ON arr.oid = t.typarray WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1" : "SELECT t.oid, t.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.typelem = (SELECT oid FROM pg_catalog.pg_type WHERE typname = ?) AND substring(t.typname, 1, 1) = '_' AND t.typlen = -1 AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.typelem DESC LIMIT 1";
                this.getOidStatementComplexArray = this.conn.prepareStatement(sql);
            }
            oidStatementComplex = this.getOidStatementComplexArray;
        } else {
            if (this.getOidStatementComplexNonArray == null) {
                sql = "SELECT t.oid, t.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1";
                this.getOidStatementComplexNonArray = this.conn.prepareStatement(sql);
            }
            oidStatementComplex = this.getOidStatementComplexNonArray;
        }
        String string = fullName = isArray ? kwTypeName.substring(0, kwTypeName.length() - 2) : kwTypeName;
        if (dotIndex == -1) {
            schema = null;
            name = fullName;
        } else if (fullName.startsWith("\"")) {
            if (fullName.endsWith("\"")) {
                String[] parts = fullName.split("\"\\.\"");
                schema = parts.length == 2 ? parts[0] + "\"" : null;
                name = parts.length == 2 ? "\"" + parts[1] : parts[0];
            } else {
                int lastDotIndex = fullName.lastIndexOf(46);
                name = fullName.substring(lastDotIndex + 1);
                schema = fullName.substring(0, lastDotIndex);
            }
        } else {
            schema = fullName.substring(0, dotIndex);
            name = fullName.substring(dotIndex + 1);
        }
        if (schema != null && schema.startsWith("\"") && schema.endsWith("\"")) {
            schema = schema.substring(1, schema.length() - 1);
        } else if (schema != null) {
            schema = schema.toLowerCase();
        }
        name = name.startsWith("\"") && name.endsWith("\"") ? name.substring(1, name.length() - 1) : name.toLowerCase();
        oidStatementComplex.setString(1, name);
        oidStatementComplex.setString(2, schema);
        oidStatementComplex.setBoolean(3, schema == null);
        return oidStatementComplex;
    }

    @Override
    public synchronized int getKWType(String kwTypeName) throws SQLException {
        Integer oid = this.kwNameToOid.get(kwTypeName);
        if (oid != null) {
            return oid;
        }
        PreparedStatement oidStatement = this.getOidStatement(kwTypeName);
        if (!((BaseStatement)((Object)oidStatement)).executeWithFlags(16)) {
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        oid = 0;
        ResultSet rs = oidStatement.getResultSet();
        if (rs.next()) {
            oid = (int)rs.getLong(1);
            String internalName = rs.getString(2);
            this.oidToKwName.put(oid, internalName);
            this.kwNameToOid.put(internalName, oid);
        }
        this.kwNameToOid.put(kwTypeName, oid);
        rs.close();
        return oid;
    }

    @Override
    public synchronized String getKWType(int oid) throws SQLException {
        if (oid == 0) {
            return null;
        }
        String kwTypeName = this.oidToKwName.get(oid);
        if (kwTypeName != null) {
            return kwTypeName;
        }
        if (this.getNameStatement == null) {
            String sql = "SELECT n.nspname = ANY(current_schemas(true)), n.nspname, t.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this.getNameStatement = this.conn.prepareStatement(sql);
        }
        this.getNameStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this.getNameStatement)).executeWithFlags(16)) {
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        ResultSet rs = this.getNameStatement.getResultSet();
        if (rs.next()) {
            boolean onPath = rs.getBoolean(1);
            String schema = rs.getString(2);
            String name = rs.getString(3);
            if (onPath) {
                kwTypeName = name;
                this.kwNameToOid.put(schema + "." + name, oid);
            } else {
                kwTypeName = "\"" + schema + "\".\"" + name + "\"";
                if (schema.equals(schema.toLowerCase()) && schema.indexOf(46) == -1 && name.equals(name.toLowerCase()) && name.indexOf(46) == -1) {
                    this.kwNameToOid.put(schema + "." + name, oid);
                }
            }
            this.kwNameToOid.put(kwTypeName, oid);
            this.oidToKwName.put(oid, kwTypeName);
        }
        rs.close();
        return kwTypeName;
    }

    @Override
    public int getKWArrayType(String elementTypeName) throws SQLException {
        elementTypeName = this.getTypeForAlias(elementTypeName);
        return this.getKWType(elementTypeName + "[]");
    }

    protected synchronized int convertArrayToBaseOid(int oid) {
        Integer i = this.kwArrayToKwType.get(oid);
        if (i == null) {
            return oid;
        }
        return i;
    }

    @Override
    public synchronized char getArrayDelimiter(int oid) throws SQLException {
        if (oid == 0) {
            return ',';
        }
        Character delim = this.arrayOidToDelimiter.get(oid);
        if (delim != null) {
            return delim.charValue();
        }
        if (this.getArrayDelimiterStatement == null) {
            String sql = "SELECT e.typdelim FROM pg_catalog.pg_type t, pg_catalog.pg_type e WHERE t.oid = ? and t.typelem = e.oid";
            this.getArrayDelimiterStatement = this.conn.prepareStatement(sql);
        }
        this.getArrayDelimiterStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this.getArrayDelimiterStatement)).executeWithFlags(16)) {
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        ResultSet rs = this.getArrayDelimiterStatement.getResultSet();
        if (!rs.next()) {
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        String s = rs.getString(1);
        delim = Character.valueOf(s.charAt(0));
        this.arrayOidToDelimiter.put(oid, delim);
        rs.close();
        return delim.charValue();
    }

    @Override
    public synchronized int getKWArrayElement(int oid) throws SQLException {
        if (oid == 0) {
            return 0;
        }
        Integer kwType = this.kwArrayToKwType.get(oid);
        if (kwType != null) {
            return kwType;
        }
        if (this.getArrayElementOidStatement == null) {
            String sql = "SELECT e.oid, n.nspname = ANY(current_schemas(true)), n.nspname, e.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_type e ON t.typelem = e.oid JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this.getArrayElementOidStatement = this.conn.prepareStatement(sql);
        }
        this.getArrayElementOidStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this.getArrayElementOidStatement)).executeWithFlags(16)) {
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        ResultSet rs = this.getArrayElementOidStatement.getResultSet();
        if (!rs.next()) {
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        kwType = (int)rs.getLong(1);
        boolean onPath = rs.getBoolean(2);
        String schema = rs.getString(3);
        String name = rs.getString(4);
        this.kwArrayToKwType.put(oid, kwType);
        this.kwNameToOid.put(schema + "." + name, kwType);
        String fullName = "\"" + schema + "\".\"" + name + "\"";
        this.kwNameToOid.put(fullName, kwType);
        if (onPath && name.equals(name.toLowerCase())) {
            this.oidToKwName.put(kwType, name);
            this.kwNameToOid.put(name, kwType);
        } else {
            this.oidToKwName.put(kwType, fullName);
        }
        rs.close();
        return kwType;
    }

    @Override
    public synchronized Class<? extends KWobject> getKWobject(String type) {
        return this.kwNameToKwObject.get(type);
    }

    @Override
    public synchronized String getJavaClass(int oid) throws SQLException {
        String kwTypeName = this.getKWType(oid);
        String result = this.kwNameToJavaClass.get(kwTypeName);
        if (result != null) {
            return result;
        }
        if (this.getSQLType(kwTypeName) == 2003) {
            result = "java.sql.Array";
            this.kwNameToJavaClass.put(kwTypeName, result);
        }
        return result;
    }

    @Override
    public String getTypeForAlias(String alias) {
        String type = typeAliases.get(alias);
        if (type != null) {
            return type;
        }
        if (alias.indexOf(34) == -1 && (type = typeAliases.get(alias.toLowerCase())) != null) {
            return type;
        }
        return alias;
    }

    @Override
    public int getPrecision(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 21: {
                return 5;
            }
            case 23: 
            case 26: {
                return 10;
            }
            case 20: {
                return 19;
            }
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return (typmod - 4 & 0xFFFF0000) >> 16;
            }
            case 16: 
            case 18: {
                return 1;
            }
            case 1042: 
            case 1043: {
                if (typmod == -1) {
                    return this.unknownLength;
                }
                return typmod - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: {
                return this.getDisplaySize(oid, typmod);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this.unknownLength;
                }
                return typmod;
            }
        }
        return this.unknownLength;
    }

    @Override
    public int getScale(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return typmod - 4 & 0xFFFF;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod;
            }
            case 1186: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod & 0xFFFF;
            }
        }
        return 0;
    }

    @Override
    public boolean isCaseSensitive(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 700: 
            case 701: 
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 1560: 
            case 1562: 
            case 1700: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSigned(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 20: 
            case 21: 
            case 23: 
            case 700: 
            case 701: 
            case 1700: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getDisplaySize(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 21: {
                return 6;
            }
            case 23: {
                return 11;
            }
            case 26: {
                return 10;
            }
            case 20: {
                return 20;
            }
            case 700: {
                return 15;
            }
            case 701: {
                return 25;
            }
            case 18: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 1082: {
                return 13;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                int secondSize;
                switch (typmod) {
                    case -1: {
                        secondSize = 7;
                        break;
                    }
                    case 0: {
                        secondSize = 0;
                        break;
                    }
                    case 1: {
                        secondSize = 3;
                        break;
                    }
                    default: {
                        secondSize = typmod + 1;
                    }
                }
                switch (oid) {
                    case 1083: {
                        return 8 + secondSize;
                    }
                    case 1266: {
                        return 8 + secondSize + 6;
                    }
                    case 1114: {
                        return 22 + secondSize;
                    }
                    case 1184: {
                        return 22 + secondSize + 6;
                    }
                }
            }
            case 1186: {
                return 49;
            }
            case 1042: 
            case 1043: {
                if (typmod == -1) {
                    return this.unknownLength;
                }
                return typmod - 4;
            }
            case 1700: {
                if (typmod == -1) {
                    return 131089;
                }
                int precision = typmod - 4 >> 16 & 0xFFFF;
                int scale = typmod - 4 & 0xFFFF;
                return 1 + precision + (scale != 0 ? 1 : 0);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this.unknownLength;
                }
                return typmod;
            }
            case 17: 
            case 25: {
                return this.unknownLength;
            }
        }
        return this.unknownLength;
    }

    @Override
    public int getMaximumPrecision(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 1700: {
                return 1000;
            }
            case 1083: 
            case 1266: {
                return 6;
            }
            case 1114: 
            case 1184: 
            case 1186: {
                return 6;
            }
            case 1042: 
            case 1043: {
                return 0xA00000;
            }
            case 1560: 
            case 1562: {
                return 0x5000000;
            }
        }
        return 0;
    }

    @Override
    public boolean requiresQuoting(int oid) throws SQLException {
        int sqlType = this.getSQLType(oid);
        return this.requiresQuotingSqlType(sqlType);
    }

    @Override
    public boolean requiresQuotingSqlType(int sqlType) throws SQLException {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    static {
        typeAliases.put("smallint", "int2");
        typeAliases.put("integer", "int4");
        typeAliases.put("int", "int4");
        typeAliases.put("bigint", "int8");
        typeAliases.put("float", "float8");
        typeAliases.put("boolean", "bool");
        typeAliases.put("decimal", "numeric");
    }
}

