/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.jre7.sasl;

import com.kaiwudb.core.KWStream;
import com.kaiwudb.shaded.com.ongres.scram.client.ScramClient;
import com.kaiwudb.shaded.com.ongres.scram.client.ScramSession;
import com.kaiwudb.shaded.com.ongres.scram.common.exception.ScramException;
import com.kaiwudb.shaded.com.ongres.scram.common.exception.ScramInvalidServerSignatureException;
import com.kaiwudb.shaded.com.ongres.scram.common.exception.ScramParseException;
import com.kaiwudb.shaded.com.ongres.scram.common.exception.ScramServerErrorException;
import com.kaiwudb.shaded.com.ongres.scram.common.stringprep.StringPreparations;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScramAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(ScramAuthenticator.class.getName());
    private final String user;
    private final String password;
    private final KWStream kwStream;
    private ScramClient scramClient;
    private ScramSession scramSession;
    private ScramSession.ServerFirstProcessor serverFirstProcessor;
    private ScramSession.ClientFinalProcessor clientFinalProcessor;

    private void sendAuthenticationMessage(int bodyLength, BodySender bodySender) throws IOException {
        this.kwStream.sendChar(112);
        this.kwStream.sendInteger4(4 + bodyLength);
        bodySender.sendBody(this.kwStream);
        this.kwStream.flush();
    }

    public ScramAuthenticator(String user, String password, KWStream kwStream) {
        this.user = user;
        this.password = password;
        this.kwStream = kwStream;
    }

    public void processServerMechanismsAndInit() throws IOException, KSQLException {
        ArrayList<String> mechanisms = new ArrayList<String>();
        do {
            mechanisms.add(this.kwStream.receiveString());
        } while (this.kwStream.peekChar() != 0);
        int c = this.kwStream.receiveChar();
        assert (c == 0);
        if (mechanisms.size() < 1) {
            throw new KSQLException(GT.tr("No SCRAM mechanism(s) advertised by the server", new Object[0]), KSQLState.CONNECTION_REJECTED);
        }
        try {
            this.scramClient = ScramClient.channelBinding(ScramClient.ChannelBinding.NO).stringPreparation(StringPreparations.NO_PREPARATION).selectMechanismBasedOnServerAdvertised(mechanisms.toArray(new String[0])).setup();
        }
        catch (IllegalArgumentException e) {
            throw new KSQLException(GT.tr("Invalid or unsupported by client SCRAM mechanisms", e), KSQLState.CONNECTION_REJECTED);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, " Using SCRAM mechanism {0}", this.scramClient.getScramMechanism().getName());
        }
        this.scramSession = this.scramClient.scramSession("*");
    }

    public void sendScramClientFirstMessage() throws IOException {
        String clientFirstMessage = this.scramSession.clientFirstMessage();
        LOGGER.log(Level.FINEST, " FE=> SASLInitialResponse( {0} )", clientFirstMessage);
        String scramMechanismName = this.scramClient.getScramMechanism().getName();
        final byte[] scramMechanismNameBytes = scramMechanismName.getBytes(StandardCharsets.UTF_8);
        final byte[] clientFirstMessageBytes = clientFirstMessage.getBytes(StandardCharsets.UTF_8);
        this.sendAuthenticationMessage(scramMechanismNameBytes.length + 1 + 4 + clientFirstMessageBytes.length, new BodySender(){

            @Override
            public void sendBody(KWStream kwStream) throws IOException {
                kwStream.send(scramMechanismNameBytes);
                kwStream.sendChar(0);
                kwStream.sendInteger4(clientFirstMessageBytes.length);
                kwStream.send(clientFirstMessageBytes);
            }
        });
    }

    public void processServerFirstMessage(int length) throws IOException, KSQLException {
        String serverFirstMessage = this.kwStream.receiveString(length);
        LOGGER.log(Level.FINEST, " <=BE AuthenticationSASLContinue( {0} )", serverFirstMessage);
        try {
            this.serverFirstProcessor = this.scramSession.receiveServerFirstMessage(serverFirstMessage);
        }
        catch (ScramException e) {
            throw new KSQLException(GT.tr("Invalid server-first-message: {0}", serverFirstMessage), KSQLState.CONNECTION_REJECTED, (Throwable)e);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, " <=BE AuthenticationSASLContinue(salt={0}, iterations={1})", new Object[]{this.serverFirstProcessor.getSalt(), this.serverFirstProcessor.getIteration()});
        }
        this.clientFinalProcessor = this.serverFirstProcessor.clientFinalProcessor(this.password);
        String clientFinalMessage = this.clientFinalProcessor.clientFinalMessage();
        LOGGER.log(Level.FINEST, " FE=> SASLResponse( {0} )", clientFinalMessage);
        final byte[] clientFinalMessageBytes = clientFinalMessage.getBytes(StandardCharsets.UTF_8);
        this.sendAuthenticationMessage(clientFinalMessageBytes.length, new BodySender(){

            @Override
            public void sendBody(KWStream kwStream) throws IOException {
                kwStream.send(clientFinalMessageBytes);
            }
        });
    }

    public void verifyServerSignature(int length) throws IOException, KSQLException {
        String serverFinalMessage = this.kwStream.receiveString(length);
        LOGGER.log(Level.FINEST, " <=BE AuthenticationSASLFinal( {0} )", serverFinalMessage);
        try {
            this.clientFinalProcessor.receiveServerFinalMessage(serverFinalMessage);
        }
        catch (ScramParseException e) {
            throw new KSQLException(GT.tr("Invalid server-final-message: {0}", serverFinalMessage), KSQLState.CONNECTION_REJECTED, (Throwable)e);
        }
        catch (ScramServerErrorException e) {
            throw new KSQLException(GT.tr("SCRAM authentication failed, server returned error: {0}", e.getError().getErrorMessage()), KSQLState.CONNECTION_REJECTED, (Throwable)e);
        }
        catch (ScramInvalidServerSignatureException e) {
            throw new KSQLException(GT.tr("Invalid server SCRAM signature", new Object[0]), KSQLState.CONNECTION_REJECTED, (Throwable)e);
        }
    }

    private static interface BodySender {
        public void sendBody(KWStream var1) throws IOException;
    }
}

