/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.osgi;

import com.kaiwudb.Driver;
import com.kaiwudb.osgi.KWDataSourceFactory;
import com.kaiwudb.util.DriverInfo;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;

public class KWBundleActivator
implements BundleActivator {
    private ServiceRegistration<?> registration;

    public void start(BundleContext context) throws Exception {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("osgi.jdbc.driver.class", Driver.class.getName());
        ((Dictionary)properties).put("osgi.jdbc.driver.name", "KaiwuDB JDBC Driver");
        ((Dictionary)properties).put("osgi.jdbc.driver.version", DriverInfo.DRIVER_VERSION);
        try {
            this.registration = context.registerService(DataSourceFactory.class.getName(), (Object)new KWDataSourceFactory(), properties);
        }
        catch (NoClassDefFoundError e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("org/osgi/service/jdbc/DataSourceFactory")) {
                if (!Boolean.getBoolean("pgjdbc.osgi.debug")) {
                    return;
                }
                new IllegalArgumentException("Unable to load DataSourceFactory. Will ignore DataSourceFactory registration. If you need one, ensure org.osgi.enterprise is on the classpath", e).printStackTrace();
                return;
            }
            throw e;
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        if (Driver.isRegistered()) {
            Driver.deregister();
        }
    }
}

