/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.osgi;

import com.kaiwudb.Driver;
import com.kaiwudb.ds.common.BaseDataSource;
import com.kaiwudb.jdbc2.optional.ConnectionPool;
import com.kaiwudb.jdbc2.optional.PoolingDataSource;
import com.kaiwudb.jdbc2.optional.SimpleDataSource;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import com.kaiwudb.xa.KWXADataSource;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.osgi.service.jdbc.DataSourceFactory;

public class KWDataSourceFactory
implements DataSourceFactory {
    private void configureBaseDataSource(BaseDataSource ds, Properties props) throws SQLException {
        if (props.containsKey("url")) {
            ds.setUrl(props.getProperty("url"));
        }
        if (props.containsKey("serverName")) {
            ds.setServerName(props.getProperty("serverName"));
        }
        if (props.containsKey("portNumber")) {
            ds.setPortNumber(Integer.parseInt(props.getProperty("portNumber")));
        }
        if (props.containsKey("databaseName")) {
            ds.setDatabaseName(props.getProperty("databaseName"));
        }
        if (props.containsKey("user")) {
            ds.setUser(props.getProperty("user"));
        }
        if (props.containsKey("password")) {
            ds.setPassword(props.getProperty("password"));
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            ds.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public java.sql.Driver createDriver(Properties props) throws SQLException {
        if (props != null && !props.isEmpty()) {
            throw new KSQLException(GT.tr("Unsupported properties: {0}", props.stringPropertyNames()), KSQLState.INVALID_PARAMETER_VALUE);
        }
        return new Driver();
    }

    private DataSource createPoolingDataSource(Properties props) throws SQLException {
        PoolingDataSource dataSource = new PoolingDataSource();
        if (props.containsKey("initialPoolSize")) {
            dataSource.setInitialConnections(Integer.parseInt(props.getProperty("initialPoolSize")));
        }
        if (props.containsKey("maxPoolSize")) {
            dataSource.setMaxConnections(Integer.parseInt(props.getProperty("maxPoolSize")));
        }
        if (props.containsKey("dataSourceName")) {
            dataSource.setDataSourceName(props.getProperty("dataSourceName"));
        }
        this.configureBaseDataSource(dataSource, props);
        return dataSource;
    }

    private DataSource createSimpleDataSource(Properties props) throws SQLException {
        SimpleDataSource dataSource = new SimpleDataSource();
        this.configureBaseDataSource(dataSource, props);
        return dataSource;
    }

    public DataSource createDataSource(Properties props) throws SQLException {
        if ((props = new SingleUseProperties(props)).containsKey("initialPoolSize") || props.containsKey("minPoolSize") || props.containsKey("maxPoolSize") || props.containsKey("maxIdleTime") || props.containsKey("maxStatements")) {
            return this.createPoolingDataSource(props);
        }
        return this.createSimpleDataSource(props);
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        props = new SingleUseProperties(props);
        ConnectionPool dataSource = new ConnectionPool();
        this.configureBaseDataSource(dataSource, props);
        return dataSource;
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        props = new SingleUseProperties(props);
        KWXADataSource dataSource = new KWXADataSource();
        this.configureBaseDataSource(dataSource, props);
        return dataSource;
    }

    private static class SingleUseProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        SingleUseProperties(Properties initialProperties) {
            if (initialProperties != null) {
                this.putAll((Map<?, ?>)initialProperties);
            }
        }

        @Override
        public String getProperty(String key) {
            String value = super.getProperty(key);
            this.remove(key);
            return value;
        }
    }
}

