/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.replication;

import com.kaiwudb.core.BaseConnection;
import com.kaiwudb.replication.KWReplicationConnection;
import com.kaiwudb.replication.fluent.ChainedCreateReplicationSlotBuilder;
import com.kaiwudb.replication.fluent.ChainedStreamBuilder;
import com.kaiwudb.replication.fluent.ReplicationCreateSlotBuilder;
import com.kaiwudb.replication.fluent.ReplicationStreamBuilder;
import java.sql.SQLException;
import java.sql.Statement;

public class KWReplicationConnectionImpl
implements KWReplicationConnection {
    private BaseConnection connection;

    public KWReplicationConnectionImpl(BaseConnection connection) {
        this.connection = connection;
    }

    @Override
    public ChainedStreamBuilder replicationStream() {
        return new ReplicationStreamBuilder(this.connection);
    }

    @Override
    public ChainedCreateReplicationSlotBuilder createReplicationSlot() {
        return new ReplicationCreateSlotBuilder(this.connection);
    }

    @Override
    public void dropReplicationSlot(String slotName) throws SQLException {
        if (slotName == null || slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slot name can't be null or empty");
        }
        try (Statement statement = this.connection.createStatement();){
            statement.execute("DROP_REPLICATION_SLOT " + slotName);
        }
    }
}

