/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.replication.fluent;

import com.kaiwudb.core.BaseConnection;
import com.kaiwudb.core.ReplicationProtocol;
import com.kaiwudb.replication.KWReplicationStream;
import com.kaiwudb.replication.fluent.ChainedStreamBuilder;
import com.kaiwudb.replication.fluent.logical.ChainedLogicalStreamBuilder;
import com.kaiwudb.replication.fluent.logical.LogicalReplicationOptions;
import com.kaiwudb.replication.fluent.logical.LogicalStreamBuilder;
import com.kaiwudb.replication.fluent.logical.StartLogicalReplicationCallback;
import com.kaiwudb.replication.fluent.physical.ChainedPhysicalStreamBuilder;
import com.kaiwudb.replication.fluent.physical.PhysicalReplicationOptions;
import com.kaiwudb.replication.fluent.physical.PhysicalStreamBuilder;
import com.kaiwudb.replication.fluent.physical.StartPhysicalReplicationCallback;
import java.sql.SQLException;

public class ReplicationStreamBuilder
implements ChainedStreamBuilder {
    private final BaseConnection baseConnection;

    public ReplicationStreamBuilder(BaseConnection connection) {
        this.baseConnection = connection;
    }

    @Override
    public ChainedLogicalStreamBuilder logical() {
        return new LogicalStreamBuilder(new StartLogicalReplicationCallback(){

            @Override
            public KWReplicationStream start(LogicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startLogical(options);
            }
        });
    }

    @Override
    public ChainedPhysicalStreamBuilder physical() {
        return new PhysicalStreamBuilder(new StartPhysicalReplicationCallback(){

            @Override
            public KWReplicationStream start(PhysicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startPhysical(options);
            }
        });
    }
}

