/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.replication.fluent.logical;

import com.kaiwudb.core.BaseConnection;
import com.kaiwudb.replication.LogSequenceNumber;
import com.kaiwudb.replication.ReplicationSlotInfo;
import com.kaiwudb.replication.ReplicationType;
import com.kaiwudb.replication.fluent.AbstractCreateSlotBuilder;
import com.kaiwudb.replication.fluent.logical.ChainedLogicalCreateSlotBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class LogicalCreateSlotBuilder
extends AbstractCreateSlotBuilder<ChainedLogicalCreateSlotBuilder>
implements ChainedLogicalCreateSlotBuilder {
    private String outputPlugin;

    public LogicalCreateSlotBuilder(BaseConnection connection) {
        super(connection);
    }

    @Override
    protected ChainedLogicalCreateSlotBuilder self() {
        return this;
    }

    @Override
    public ChainedLogicalCreateSlotBuilder withOutputPlugin(String outputPlugin) {
        this.outputPlugin = outputPlugin;
        return this.self();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationSlotInfo make() throws SQLException {
        if (this.outputPlugin == null || this.outputPlugin.isEmpty()) {
            throw new IllegalArgumentException("OutputPlugin required parameter for logical replication slot");
        }
        if (this.slotName == null || this.slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slotName can't be null");
        }
        Statement statement = this.connection.createStatement();
        ResultSet result = null;
        ReplicationSlotInfo slotInfo = null;
        try {
            statement.execute(String.format("CREATE_REPLICATION_SLOT %s %s LOGICAL %s", this.slotName, this.temporaryOption ? "TEMPORARY" : "", this.outputPlugin));
            result = statement.getResultSet();
            if (result != null && result.next()) {
                slotInfo = new ReplicationSlotInfo(result.getString("slot_name"), ReplicationType.LOGICAL, LogSequenceNumber.valueOf(result.getString("consistent_point")), result.getString("snapshot_name"), result.getString("output_plugin"));
            }
        }
        finally {
            if (result != null) {
                result.close();
            }
            statement.close();
        }
        return slotInfo;
    }
}

