/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.ssl;

import com.kaiwudb.KWProperty;
import com.kaiwudb.core.KWStream;
import com.kaiwudb.core.SocketFactoryFactory;
import com.kaiwudb.jdbc.SslMode;
import com.kaiwudb.ssl.KWjdbcHostnameVerifier;
import com.kaiwudb.ssl.LibPQFactory;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import com.kaiwudb.util.ObjectFactory;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class MakeSSL
extends ObjectFactory {
    private static final Logger LOGGER = Logger.getLogger(MakeSSL.class.getName());

    public static void convert(KWStream stream, Properties info) throws KSQLException, IOException {
        SslMode sslMode;
        SSLSocket newConnection;
        LOGGER.log(Level.FINE, "converting regular socket connection to ssl");
        SSLSocketFactory factory = SocketFactoryFactory.getSslSocketFactory(info);
        try {
            newConnection = (SSLSocket)factory.createSocket(stream.getSocket(), stream.getHostSpec().getHost(), stream.getHostSpec().getPort(), true);
            newConnection.setUseClientMode(true);
            String tlcpProtocolVersion = KWProperty.SSL_MAX_PROTOCOL_VERSION.get(info);
            if (tlcpProtocolVersion != null && !tlcpProtocolVersion.isEmpty()) {
                newConnection.setEnabledProtocols(new String[]{tlcpProtocolVersion});
                if (SslMode.of(info).verifyCertificate()) {
                    newConnection.setEnabledCipherSuites(new String[]{"TLCP_ECDHE_SM4_GCM_SM3"});
                } else if (KWProperty.SSL_CERT.get(info) != null && KWProperty.SSL_KEY.get(info) != null) {
                    newConnection.setEnabledCipherSuites(new String[]{"TLCP_ECDHE_SM4_GCM_SM3"});
                }
            }
            newConnection.startHandshake();
        }
        catch (IOException ex) {
            throw new KSQLException(GT.tr("SSL error: {0}", ex.getMessage()), KSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
        if (factory instanceof LibPQFactory) {
            ((LibPQFactory)factory).throwKeyManagerException();
        }
        if ((sslMode = SslMode.of(info)).verifyPeerName()) {
            MakeSSL.verifyPeerName(stream, info, newConnection);
        }
        stream.changeSocket(newConnection);
    }

    private static void verifyPeerName(KWStream stream, Properties info, SSLSocket newConnection) throws KSQLException {
        HostnameVerifier hvn;
        String sslhostnameverifier = KWProperty.SSL_HOSTNAME_VERIFIER.get(info);
        if (sslhostnameverifier == null) {
            hvn = KWjdbcHostnameVerifier.INSTANCE;
            sslhostnameverifier = "KwjdbcHostnameVerifier";
        } else {
            try {
                hvn = (HostnameVerifier)MakeSSL.instantiate(sslhostnameverifier, info, false, null);
            }
            catch (Exception e) {
                throw new KSQLException(GT.tr("The HostnameVerifier class provided {0} could not be instantiated.", sslhostnameverifier), KSQLState.CONNECTION_FAILURE, (Throwable)e);
            }
        }
        if (hvn.verify(stream.getHostSpec().getHost(), newConnection.getSession())) {
            return;
        }
        throw new KSQLException(GT.tr("The hostname {0} could not be verified by hostnameverifier {1}.", stream.getHostSpec().getHost(), sslhostnameverifier), KSQLState.CONNECTION_FAILURE);
    }
}

