/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.ssl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;

public class TlcpCertUtils {
    public static String getKeyAlgo() {
        return "EC";
    }

    public static String getCertStr(String certPath) throws IOException {
        return TlcpCertUtils.filterPem(Files.readAllLines(Paths.get(certPath, new String[0])), true);
    }

    public static String getKeyStr(String keyPath) throws IOException {
        return TlcpCertUtils.filterPem(Files.readAllLines(Paths.get(keyPath, new String[0])), false);
    }

    private static String filterPem(List<String> lines, boolean keepSeparator) {
        StringBuilder result = new StringBuilder();
        boolean begin = false;
        for (String line : lines) {
            if (line.startsWith("-----END")) {
                if (!keepSeparator) break;
                result.append(line);
                break;
            }
            if (line.startsWith("-----BEGIN")) {
                begin = true;
                if (!keepSeparator) continue;
                result.append(line).append("\n");
                continue;
            }
            if (!begin) continue;
            result.append(line).append("\n");
        }
        return result.toString();
    }
}

