/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.ssl;

import com.kaiwudb.KWProperty;
import com.kaiwudb.ssl.TlcpCertUtils;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.pkix.PKIXInsts;
import com.tencent.kona.ssl.SSLInsts;
import java.io.ByteArrayInputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;

public class TlcpKeyManager
implements KeyManager {
    private final KeyStore ks;
    private final KeyManager[] tlcpKeyManager;

    public TlcpKeyManager(Properties info) throws KSQLException {
        try {
            char[] passphrase = "passphrase".toCharArray();
            this.ks = PKIXInsts.getKeyStore("PKCS12");
            this.ks.load(null, null);
            if (KWProperty.SSL_CERT.get(info) != null && KWProperty.SSL_KEY.get(info) != null && KWProperty.SSL_SIGN_CERT.get(info) != null && KWProperty.SSL_SIGN_KEY.get(info) != null) {
                this.loadKeyEntry(info, passphrase);
                KeyManagerFactory kmf = SSLInsts.getKeyManagerFactory("NewSunX509");
                kmf.init(this.ks, passphrase);
                this.tlcpKeyManager = kmf.getKeyManagers();
            } else {
                this.tlcpKeyManager = null;
            }
        }
        catch (Exception ex) {
            throw new KSQLException(GT.tr("Could not generate key Managers: {0}.", ex.getMessage()), KSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
    }

    private void loadKeyEntry(Properties info, char[] passphrase) throws Exception {
        Certificate signKeyCert;
        Certificate encKeyCert;
        KeyFactory kf = CryptoInsts.getKeyFactory(TlcpCertUtils.getKeyAlgo());
        PKCS8EncodedKeySpec encPriKeySpec = new PKCS8EncodedKeySpec(Base64.getMimeDecoder().decode(TlcpCertUtils.getKeyStr(KWProperty.SSL_KEY.get(info))));
        PrivateKey encPriKey = kf.generatePrivate(encPriKeySpec);
        PKCS8EncodedKeySpec signPriKeySpec = new PKCS8EncodedKeySpec(Base64.getMimeDecoder().decode(TlcpCertUtils.getKeyStr(KWProperty.SSL_SIGN_KEY.get(info))));
        PrivateKey signPriKey = kf.generatePrivate(signPriKeySpec);
        ByteArrayInputStream encIs = new ByteArrayInputStream(TlcpCertUtils.getCertStr(KWProperty.SSL_CERT.get(info)).getBytes());
        ByteArrayInputStream signIs = new ByteArrayInputStream(TlcpCertUtils.getCertStr(KWProperty.SSL_SIGN_CERT.get(info)).getBytes());
        try {
            CertificateFactory cf = PKIXInsts.getCertificateFactory("X.509");
            encKeyCert = cf.generateCertificate(encIs);
            signKeyCert = cf.generateCertificate(signIs);
        }
        catch (CertificateException ex) {
            throw new KSQLException(GT.tr("Could not find a java cryptographic algorithm: X.509 CertificateFactory not available.", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
        finally {
            encIs.close();
            signIs.close();
        }
        this.ks.setKeyEntry("cert-" + KWProperty.SSL_CERT.getName(), encPriKey, passphrase, new Certificate[]{encKeyCert});
        this.ks.setKeyEntry("cert-" + KWProperty.SSL_SIGN_CERT.getName(), signPriKey, passphrase, new Certificate[]{signKeyCert});
    }

    public KeyManager[] getTlcpKeyManager() {
        return this.tlcpKeyManager;
    }
}

