/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.com.sun.crypto.provider;

import java.security.MessageDigest;
import java.util.Arrays;

public class PKCS12PBECipherCoreUtil {
    static final int MAC_KEY = 3;

    static byte[] derive(char[] chars, byte[] salt, int ic, int n, int type, String hashAlgo, int blockLength) {
        int length = chars.length * 2;
        if (length == 2 && chars[0] == '\u0000') {
            chars = new char[]{};
            length = 0;
        } else {
            length += 2;
        }
        byte[] passwd = new byte[length];
        int i = 0;
        int j = 0;
        while (i < chars.length) {
            passwd[j] = (byte)(chars[i] >>> 8 & 0xFF);
            passwd[j + 1] = (byte)(chars[i] & 0xFF);
            ++i;
            j += 2;
        }
        byte[] key = new byte[n];
        try {
            MessageDigest sha = MessageDigest.getInstance(hashAlgo);
            int v = blockLength;
            int u = sha.getDigestLength();
            int c = PKCS12PBECipherCoreUtil.roundup(n, u) / u;
            byte[] D = new byte[v];
            int s = PKCS12PBECipherCoreUtil.roundup(salt.length, v);
            int p = PKCS12PBECipherCoreUtil.roundup(passwd.length, v);
            byte[] I = new byte[s + p];
            Arrays.fill(D, (byte)type);
            PKCS12PBECipherCoreUtil.concat(salt, I, 0, s);
            PKCS12PBECipherCoreUtil.concat(passwd, I, s, p);
            Arrays.fill(passwd, (byte)0);
            byte[] B = new byte[v];
            int i2 = 0;
            while (true) {
                sha.update(D);
                sha.update(I);
                byte[] Ai = sha.digest();
                for (int r = 1; r < ic; ++r) {
                    Ai = sha.digest(Ai);
                }
                System.arraycopy(Ai, 0, key, u * i2, Math.min(n, u));
                if (i2 + 1 == c) break;
                PKCS12PBECipherCoreUtil.concat(Ai, B, 0, v);
                PKCS12PBECipherCoreUtil.addOne(v, B);
                for (int j2 = 0; j2 < I.length; j2 += v) {
                    PKCS12PBECipherCoreUtil.addTwo(v, B, I, j2);
                }
                ++i2;
                n -= u;
            }
            Arrays.fill(I, (byte)0);
        }
        catch (Exception e) {
            throw new RuntimeException("internal error: " + e);
        }
        return key;
    }

    private static void addOne(int len, byte[] b) {
        for (int i = len - 1; i >= 0; --i) {
            if ((b[i] & 0xFF) != 255) {
                int n = i;
                b[n] = (byte)(b[n] + 1);
                break;
            }
            b[i] = 0;
        }
    }

    private static void addTwo(int len, byte[] src, byte[] dst, int offset) {
        int carry = 0;
        for (int i = len - 1; i >= 0; --i) {
            int sum = (src[i] & 0xFF) + (dst[i + offset] & 0xFF) + carry;
            carry = sum >> 8;
            dst[i + offset] = (byte)sum;
        }
    }

    private static int roundup(int x, int y) {
        return (x + (y - 1)) / y * y;
    }

    private static void concat(byte[] src, byte[] dst, int start, int len) {
        if (src.length == 0) {
            return;
        }
        int loop = len / src.length;
        int i = 0;
        int off = 0;
        while (i < loop) {
            System.arraycopy(src, 0, dst, off + start, src.length);
            ++i;
            off += src.length;
        }
        System.arraycopy(src, 0, dst, off + start, len - off);
    }
}

