/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.provider.PBEKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;

abstract class PBEKeyFactory
extends SecretKeyFactorySpi {
    private final String type;
    private static final HashSet<String> validTypes = new HashSet(18);

    private PBEKeyFactory(String keytype) {
        this.type = keytype;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        return new PBEKey((PBEKeySpec)keySpec, this.type, true);
    }

    @Override
    protected KeySpec engineGetKeySpec(SecretKey key, Class<?> keySpecCl) throws InvalidKeySpecException {
        if (key instanceof SecretKey && validTypes.contains(key.getAlgorithm().toUpperCase(Locale.ENGLISH)) && key.getFormat().equalsIgnoreCase("RAW")) {
            if (keySpecCl != null && keySpecCl.isAssignableFrom(PBEKeySpec.class)) {
                byte[] passwdBytes = key.getEncoded();
                char[] passwdChars = new char[passwdBytes.length];
                for (int i = 0; i < passwdChars.length; ++i) {
                    passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
                }
                PBEKeySpec ret = new PBEKeySpec(passwdChars);
                Arrays.fill(passwdChars, ' ');
                Arrays.fill(passwdBytes, (byte)0);
                return ret;
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        throw new InvalidKeySpecException("Invalid key format/algorithm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (key == null || !validTypes.contains(key.getAlgorithm().toUpperCase(Locale.ENGLISH)) || !key.getFormat().equalsIgnoreCase("RAW")) throw new InvalidKeyException("Invalid key format/algorithm");
        if (key instanceof PBEKey) {
            return key;
        }
        PBEKeySpec pbeKeySpec = (PBEKeySpec)this.engineGetKeySpec(key, PBEKeySpec.class);
        try {
            SecretKey secretKey = this.engineGenerateSecret(pbeKeySpec);
            pbeKeySpec.clearPassword();
            return secretKey;
        }
        catch (Throwable throwable) {
            try {
                pbeKeySpec.clearPassword();
                throw throwable;
            }
            catch (InvalidKeySpecException ikse) {
                throw new InvalidKeyException("Cannot translate key: " + ikse.getMessage());
            }
        }
    }

    static {
        validTypes.add("PBEWithHmacSM3AndSM4".toUpperCase(Locale.ENGLISH));
    }

    public static final class PBEWithHmacSM3AndSM4
    extends PBEKeyFactory {
        public PBEWithHmacSM3AndSM4() {
            super("PBEWithHmacSM3AndSM4");
        }
    }
}

