/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.KnownOIDs;
import com.tencent.kona.sun.security.util.ObjectIdentifier;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Optional;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

abstract class PBES2Parameters
extends AlgorithmParametersSpi {
    private static final ObjectIdentifier sm4128CBC_OID = ObjectIdentifier.of(KnownOIDs.SM4$CBC$NoPadding);
    private static final ObjectIdentifier pkcs5PBKDF2_OID = ObjectIdentifier.of(KnownOIDs.PBKDF2WithHmacSHA1);
    private static final ObjectIdentifier pkcs5PBES2_OID = ObjectIdentifier.of(KnownOIDs.PBES2);
    private static final ObjectIdentifier aes128CBC_OID = ObjectIdentifier.of(KnownOIDs.AES_128$CBC$NoPadding);
    private static final ObjectIdentifier aes192CBC_OID = ObjectIdentifier.of(KnownOIDs.AES_192$CBC$NoPadding);
    private static final ObjectIdentifier aes256CBC_OID = ObjectIdentifier.of(KnownOIDs.AES_256$CBC$NoPadding);
    private String pbes2AlgorithmName;
    private byte[] salt;
    private int iCount;
    private AlgorithmParameterSpec cipherParam;
    private ObjectIdentifier kdfAlgo_OID;
    private ObjectIdentifier cipherAlgo_OID;
    private int keysize;

    PBES2Parameters() {
        this.pbes2AlgorithmName = null;
        this.salt = null;
        this.iCount = 0;
        this.cipherParam = null;
        this.kdfAlgo_OID = ObjectIdentifier.of(KnownOIDs.HmacSHA1);
        this.cipherAlgo_OID = null;
        this.keysize = -1;
    }

    PBES2Parameters(String pbes2AlgorithmName) throws NoSuchAlgorithmException {
        block13: {
            String cipherAlgo;
            block12: {
                int and;
                this.pbes2AlgorithmName = null;
                this.salt = null;
                this.iCount = 0;
                this.cipherParam = null;
                this.kdfAlgo_OID = ObjectIdentifier.of(KnownOIDs.HmacSHA1);
                this.cipherAlgo_OID = null;
                this.keysize = -1;
                String kdfAlgo = null;
                cipherAlgo = null;
                this.pbes2AlgorithmName = pbes2AlgorithmName;
                if (pbes2AlgorithmName.startsWith("PBEWith") && (and = pbes2AlgorithmName.indexOf("And", 8)) > 0) {
                    kdfAlgo = pbes2AlgorithmName.substring(7, and);
                    cipherAlgo = pbes2AlgorithmName.substring(and + 3);
                    int underscore = cipherAlgo.indexOf(95);
                    if (underscore > 0) {
                        int slash = cipherAlgo.indexOf(47, underscore + 1);
                        this.keysize = slash > 0 ? Integer.parseInt(cipherAlgo.substring(underscore + 1, slash)) : Integer.parseInt(cipherAlgo.substring(underscore + 1));
                        cipherAlgo = cipherAlgo.substring(0, underscore);
                    }
                } else {
                    throw new NoSuchAlgorithmException("No crypto implementation for " + pbes2AlgorithmName);
                }
                switch (kdfAlgo) {
                    case "HmacSM3": {
                        this.kdfAlgo_OID = ObjectIdentifier.of(KnownOIDs.findMatch(kdfAlgo));
                        break;
                    }
                    default: {
                        throw new NoSuchAlgorithmException("No crypto implementation for " + kdfAlgo);
                    }
                }
                if (!cipherAlgo.equals("SM4")) break block12;
                this.keysize = 128;
                switch (this.keysize) {
                    case 128: {
                        this.cipherAlgo_OID = sm4128CBC_OID;
                        break block13;
                    }
                    default: {
                        throw new NoSuchAlgorithmException("No Cipher implementation for " + this.keysize + "-bit " + cipherAlgo);
                    }
                }
            }
            throw new NoSuchAlgorithmException("No Cipher implementation for " + cipherAlgo);
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.salt = (byte[])((PBEParameterSpec)paramSpec).getSalt().clone();
        this.iCount = ((PBEParameterSpec)paramSpec).getIterationCount();
        this.cipherParam = ((PBEParameterSpec)paramSpec).getParameterSpec();
    }

    @Override
    protected void engineInit(byte[] encoded) throws IOException {
        String kdfAlgo = null;
        String cipherAlgo = null;
        DerValue pBES2_params = new DerValue(encoded);
        if (pBES2_params.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        DerValue kdf = pBES2_params.data.getDerValue();
        if (kdf.getTag() == 6) {
            pBES2_params = pBES2_params.data.getDerValue();
            kdf = pBES2_params.data.getDerValue();
        }
        kdfAlgo = this.parseKDF(kdf);
        if (pBES2_params.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        cipherAlgo = this.parseES(pBES2_params.data.getDerValue());
        this.pbes2AlgorithmName = "PBEWith" + kdfAlgo + "And" + cipherAlgo;
    }

    private String parseKDF(DerValue keyDerivationFunc) throws IOException {
        String kdfAlgo;
        Optional<DerValue> prfDer;
        if (!pkcs5PBKDF2_OID.equals(keyDerivationFunc.data.getOID())) {
            throw new IOException("PBE parameter parsing error: expecting the object identifier for PBKDF2");
        }
        if (keyDerivationFunc.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        DerValue pBKDF2_params = keyDerivationFunc.data.getDerValue();
        if (pBKDF2_params.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        DerValue specified = pBKDF2_params.data.getDerValue();
        if (specified.tag != 4) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 OCTET STRING tag");
        }
        this.salt = specified.getOctetString();
        this.iCount = pBKDF2_params.data.getInteger();
        Optional<DerValue> ksDer = pBKDF2_params.data.getOptional((byte)2);
        if (ksDer.isPresent()) {
            this.keysize = ksDer.get().getInteger() * 8;
        }
        if ((prfDer = pBKDF2_params.data.getOptional((byte)48)).isPresent()) {
            DerValue prf = prfDer.get();
            this.kdfAlgo_OID = prf.data.getOID();
            KnownOIDs o = KnownOIDs.findMatch(this.kdfAlgo_OID.toString());
            if (!(o != null && (o.stdName().equals("HmacSM3") || o.stdName().equals("HmacSHA1") || o.stdName().equals("HmacSHA224") || o.stdName().equals("HmacSHA256") || o.stdName().equals("HmacSHA384") || o.stdName().equals("HmacSHA512") || o.stdName().equals("HmacSHA512/224") || o.stdName().equals("HmacSHA512/256")))) {
                throw new IOException("PBE parameter parsing error: expecting the object identifier for a HmacSHA key derivation function");
            }
            kdfAlgo = o.stdName();
            prf.data.getOptional((byte)5);
            prf.data.atEnd();
        } else {
            kdfAlgo = "HmacSHA1";
        }
        return kdfAlgo;
    }

    private String parseES(DerValue encryptionScheme) throws IOException {
        String cipherAlgo = null;
        this.cipherAlgo_OID = encryptionScheme.data.getOID();
        if (sm4128CBC_OID.equals(this.cipherAlgo_OID)) {
            cipherAlgo = "SM4_128";
            this.cipherParam = new IvParameterSpec(encryptionScheme.data.getOctetString());
            this.keysize = 128;
        } else if (aes128CBC_OID.equals(this.cipherAlgo_OID)) {
            cipherAlgo = "AES_128";
            this.cipherParam = new IvParameterSpec(encryptionScheme.data.getOctetString());
            this.keysize = 128;
        } else if (aes256CBC_OID.equals(this.cipherAlgo_OID)) {
            cipherAlgo = "AES_256";
            this.cipherParam = new IvParameterSpec(encryptionScheme.data.getOctetString());
            this.keysize = 256;
        } else {
            throw new IOException("PBE parameter parsing error: expecting the object identifier for AES cipher");
        }
        return cipherAlgo;
    }

    @Override
    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        this.engineInit(encoded);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (paramSpec.isAssignableFrom(PBEParameterSpec.class)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(new PBEParameterSpec(this.salt, this.iCount, this.cipherParam)));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream pBES2_params = new DerOutputStream();
        DerOutputStream keyDerivationFunc = new DerOutputStream();
        keyDerivationFunc.putOID(pkcs5PBKDF2_OID);
        DerOutputStream pBKDF2_params = new DerOutputStream();
        pBKDF2_params.putOctetString(this.salt);
        pBKDF2_params.putInteger(this.iCount);
        if (this.keysize > 0) {
            pBKDF2_params.putInteger(this.keysize / 8);
        }
        DerOutputStream prf = new DerOutputStream();
        prf.putOID(this.kdfAlgo_OID);
        prf.putNull();
        pBKDF2_params.write((byte)48, prf);
        keyDerivationFunc.write((byte)48, pBKDF2_params);
        pBES2_params.write((byte)48, keyDerivationFunc);
        DerOutputStream encryptionScheme = new DerOutputStream();
        encryptionScheme.putOID(this.cipherAlgo_OID);
        if (this.cipherParam == null || !(this.cipherParam instanceof IvParameterSpec)) {
            throw new IOException("Wrong parameter type: IV expected");
        }
        encryptionScheme.putOctetString(((IvParameterSpec)this.cipherParam).getIV());
        pBES2_params.write((byte)48, encryptionScheme);
        out.write((byte)48, pBES2_params);
        return out.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        return this.pbes2AlgorithmName;
    }

    public static final class HmacSHA512_256AndAES_256
    extends PBES2Parameters {
        public HmacSHA512_256AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA512/256AndAES_256");
        }
    }

    public static final class HmacSHA512_224AndAES_256
    extends PBES2Parameters {
        public HmacSHA512_224AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA512/224AndAES_256");
        }
    }

    public static final class HmacSHA512AndAES_256
    extends PBES2Parameters {
        public HmacSHA512AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA512AndAES_256");
        }
    }

    public static final class HmacSHA384AndAES_256
    extends PBES2Parameters {
        public HmacSHA384AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA384AndAES_256");
        }
    }

    public static final class HmacSHA256AndAES_256
    extends PBES2Parameters {
        public HmacSHA256AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA256AndAES_256");
        }
    }

    public static final class HmacSHA224AndAES_256
    extends PBES2Parameters {
        public HmacSHA224AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA224AndAES_256");
        }
    }

    public static final class HmacSHA1AndAES_256
    extends PBES2Parameters {
        public HmacSHA1AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA1AndAES_256");
        }
    }

    public static final class HmacSHA512_256AndAES_128
    extends PBES2Parameters {
        public HmacSHA512_256AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA512/256AndAES_128");
        }
    }

    public static final class HmacSHA512_224AndAES_128
    extends PBES2Parameters {
        public HmacSHA512_224AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA512/224AndAES_128");
        }
    }

    public static final class HmacSHA512AndAES_128
    extends PBES2Parameters {
        public HmacSHA512AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA512AndAES_128");
        }
    }

    public static final class HmacSHA384AndAES_128
    extends PBES2Parameters {
        public HmacSHA384AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA384AndAES_128");
        }
    }

    public static final class HmacSHA256AndAES_128
    extends PBES2Parameters {
        public HmacSHA256AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA256AndAES_128");
        }
    }

    public static final class HmacSHA224AndAES_128
    extends PBES2Parameters {
        public HmacSHA224AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA224AndAES_128");
        }
    }

    public static final class HmacSHA1AndAES_128
    extends PBES2Parameters {
        public HmacSHA1AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA1AndAES_128");
        }
    }

    public static final class HmacSM3AndSM4
    extends PBES2Parameters {
        public HmacSM3AndSM4() throws NoSuchAlgorithmException {
            super("PBEWithHmacSM3AndSM4");
        }
    }

    public static final class General
    extends PBES2Parameters {
    }
}

