/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.provider.SM2PrivateKey;
import com.tencent.kona.crypto.provider.SM2PublicKey;
import com.tencent.kona.crypto.provider.SM3Engine;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import com.tencent.kona.sun.security.ec.ECOperations;
import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.interfaces.ECKey;
import java.security.spec.ECPoint;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public final class SM2Engine {
    private SM2PublicKey publicKey;
    private SM2PrivateKey privateKey;
    private SecureRandom random;
    private boolean encrypted;
    private SM3Engine sm3;

    public void init(boolean encrypted, ECKey key, SecureRandom random) {
        this.publicKey = null;
        this.privateKey = null;
        this.sm3 = null;
        if (encrypted) {
            this.publicKey = (SM2PublicKey)key;
        } else {
            this.privateKey = (SM2PrivateKey)key;
        }
        this.random = random;
        this.encrypted = encrypted;
        this.sm3 = new SM3Engine();
    }

    public boolean encrypted() {
        return this.encrypted;
    }

    public byte[] processBlock(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (!SM2Engine.checkInputBound(input, inputOffset, inputLen)) {
            throw new BadPaddingException("Invalid input");
        }
        if (this.encrypted) {
            return this.encrypt(input, inputOffset, inputLen);
        }
        return this.decrypt(input, inputOffset, inputLen);
    }

    private byte[] encrypt(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        ECPoint pC1;
        byte[] kArr;
        ECPoint kPB;
        byte[] t;
        byte[] c2 = new byte[inputLen];
        System.arraycopy(input, inputOffset, c2, 0, c2.length);
        do {
            kArr = this.nextK();
            pC1 = ECOperations.SM2OPS.multiply(SM2ParameterSpec.GENERATOR, kArr).asAffine().toECPoint();
        } while (SM2Engine.isAllZero(t = this.kdf(kPB = ECOperations.SM2OPS.multiply(this.publicKey.getW(), kArr).asAffine().toECPoint(), c2.length)));
        this.xor(c2, t);
        byte[] c3 = new byte[32];
        this.sm3.update(CryptoUtils.bigIntToBytes32(kPB.getAffineX()));
        this.sm3.update(input, inputOffset, inputLen);
        this.sm3.update(CryptoUtils.bigIntToBytes32(kPB.getAffineY()));
        this.sm3.doFinal(c3);
        return this.c(pC1, c3, c2);
    }

    private byte[] c(ECPoint pC1, byte[] c3, byte[] c2) {
        DerValue[] values = new DerValue[]{new DerValue(2, pC1.getAffineX().toByteArray()), new DerValue(2, pC1.getAffineY().toByteArray()), new DerValue(4, c3), new DerValue(4, c2)};
        DerOutputStream derOut = new DerOutputStream();
        derOut.putSequence(values);
        return derOut.toByteArray();
    }

    private static boolean isAllZero(byte[] byteArr) {
        boolean result = byteArr.length > 0;
        for (byte b : byteArr) {
            result &= b == 0;
        }
        return result;
    }

    private byte[] decrypt(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        DerValue[] values;
        DerInputStream derIn;
        byte[] c = new byte[inputLen];
        System.arraycopy(input, inputOffset, c, 0, inputLen);
        try {
            derIn = new DerInputStream(c);
            values = derIn.getSequence(2);
        }
        catch (IOException e) {
            throw new BadPaddingException("Decode SM2 ciphertext failed");
        }
        if (values.length != 4 || derIn.available() != 0) {
            throw new BadPaddingException("Invalid encoding for SM2 ciphertext");
        }
        byte[] pC1X = values[0].getDataBytes();
        byte[] pC1Y = values[1].getDataBytes();
        byte[] c3 = values[2].getDataBytes();
        byte[] c2 = values[3].getDataBytes();
        ECPoint pC1 = new ECPoint(new BigInteger(1, pC1X), new BigInteger(1, pC1Y));
        byte[] hArr = CryptoUtils.toByteArrayLE(SM2ParameterSpec.COFACTOR);
        ECPoint s = ECOperations.SM2OPS.multiply(pC1, hArr).asAffine().toECPoint();
        if (!ECOperations.SM2OPS.checkOrder(s)) {
            throw new BadPaddingException("The peer public point is invalid");
        }
        byte[] dBArr = CryptoUtils.toByteArrayLE(this.privateKey.getS());
        ECPoint dBPC1 = ECOperations.SM2OPS.multiply(pC1, dBArr).asAffine().toECPoint();
        byte[] t = this.kdf(dBPC1, c2.length);
        if (SM2Engine.isAllZero(t)) {
            throw new BadPaddingException("Derived key is zero");
        }
        this.xor(c2, t);
        byte[] u = new byte[32];
        this.sm3.update(CryptoUtils.bigIntToBytes32(dBPC1.getAffineX()));
        this.sm3.update(c2);
        this.sm3.update(CryptoUtils.bigIntToBytes32(dBPC1.getAffineY()));
        this.sm3.doFinal(u);
        boolean checkDigest = MessageDigest.isEqual(u, c3);
        Arrays.fill(pC1X, (byte)0);
        Arrays.fill(pC1Y, (byte)0);
        Arrays.fill(c3, (byte)0);
        if (!checkDigest) {
            Arrays.fill(c2, (byte)0);
            throw new BadPaddingException("Invalid ciphertext");
        }
        return c2;
    }

    private void xor(byte[] c2, byte[] t) {
        for (int i = 0; i < c2.length; ++i) {
            int n = i;
            c2[n] = (byte)(c2[n] ^ t[i]);
        }
    }

    private byte[] nextK() {
        return ECOperations.SM2OPS.generatePrivateScalar(this.random);
    }

    private byte[] kdf(ECPoint point, int keyLen) {
        byte[] xArr = CryptoUtils.bigIntToBytes32(point.getAffineX());
        byte[] yArr = CryptoUtils.bigIntToBytes32(point.getAffineY());
        byte[] input = new byte[xArr.length + yArr.length];
        System.arraycopy(xArr, 0, input, 0, xArr.length);
        System.arraycopy(yArr, 0, input, xArr.length, yArr.length);
        return this.kdf(input, keyLen);
    }

    private byte[] kdf(byte[] input, int keyLen) {
        byte[] derivedKey = new byte[keyLen];
        byte[] digest = new byte[32];
        int remainder = keyLen % 32;
        int count = (keyLen + 32 - 1) / 32;
        for (int i = 1; i <= count; ++i) {
            this.sm3.update(input);
            this.sm3.update(CryptoUtils.intToBytes4(i));
            this.sm3.doFinal(digest);
            int length = i == count && remainder != 0 ? remainder : 32;
            System.arraycopy(digest, 0, derivedKey, (i - 1) * 32, length);
        }
        return derivedKey;
    }

    private static boolean checkInputBound(byte[] input, int offset, int len) {
        return input != null && offset >= 0 && len >= 0 && input.length >= offset + len;
    }
}

