/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.provider.SM2PrivateKey;
import com.tencent.kona.crypto.provider.SM2PublicKey;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import com.tencent.kona.sun.security.ec.ECKeyPairGenerator;
import com.tencent.kona.sun.security.jca.JCAUtil;
import com.tencent.kona.sun.security.util.KnownOIDs;
import com.tencent.kona.sun.security.util.NamedCurve;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public final class SM2KeyPairGenerator
extends KeyPairGeneratorSpi {
    private SecureRandom random;
    private ECKeyPairGenerator keyPairGen;

    @Override
    public void initialize(int keySize, SecureRandom random) {
        if (keySize != 256) {
            throw new IllegalArgumentException("keySize must be 256-bit: " + keySize);
        }
        this.random = random;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) {
        if (params == null || !(params instanceof SM2ParameterSpec) && !KnownOIDs.curveSM2.value().equals(((NamedCurve)params).getObjectId())) {
            throw new IllegalArgumentException("params must be SM2ParameterSpec or NamedCurve (curveSM2)");
        }
        this.random = random;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        if (this.keyPairGen == null) {
            this.keyPairGen = new ECKeyPairGenerator();
            try {
                this.keyPairGen.initialize(SM2ParameterSpec.instance(), this.random);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new IllegalArgumentException(e);
            }
        }
        KeyPair keyPair = this.keyPairGen.generateKeyPair();
        ECPublicKey pubKey = (ECPublicKey)keyPair.getPublic();
        ECPrivateKey priKey = (ECPrivateKey)keyPair.getPrivate();
        return new KeyPair(new SM2PublicKey(pubKey.getW()), new SM2PrivateKey(priKey.getS()));
    }
}

