/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.util;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Objects;

public final class SM2Ciphertext {
    private static final byte UNCOMPRESSED = 4;
    private final byte[] coordX;
    private final byte[] coordY;
    private final byte[] digest;
    private final byte[] ciphertext;

    public SM2Ciphertext(Builder builder) throws IOException {
        if (builder.format == Format.DER_C1C3C2 || builder.format == Format.DER_C1C2C3) {
            DerInputStream derIn = new DerInputStream(builder.encodedCiphertext);
            DerValue[] values = derIn.getSequence(2);
            if (values.length != 4 || derIn.available() != 0) {
                throw new IOException("Invalid encoding for SM2 ciphertext");
            }
            byte[] x = values[0].getDataBytes();
            builder.coordX(x);
            byte[] y = values[1].getDataBytes();
            builder.coordY(y);
            if (builder.format == Format.DER_C1C3C2) {
                builder.digest(values[2].getDataBytes());
                builder.ciphertext(values[3].getDataBytes());
            }
            if (builder.format == Format.DER_C1C2C3) {
                builder.ciphertext(values[2].getDataBytes());
                builder.digest(values[3].getDataBytes());
            }
        } else if (builder.format == Format.RAW_C1C3C2 || builder.format == Format.RAW_C1C2C3) {
            byte[] encodedCiphertext = builder.encodedCiphertext;
            if (encodedCiphertext[0] != 4) {
                throw new IOException("For RAW_C1C3C2 and RAW_C1C2C3 formats, the ciphertext must start with 04");
            }
            builder.coordX(CryptoUtils.copy(encodedCiphertext, 1, 32));
            builder.coordY(CryptoUtils.copy(encodedCiphertext, 33, 32));
            if (builder.format == Format.RAW_C1C3C2) {
                builder.digest(CryptoUtils.copy(encodedCiphertext, 65, 32));
                builder.ciphertext(CryptoUtils.copy(encodedCiphertext, 97, encodedCiphertext.length - 97));
            }
            if (builder.format == Format.RAW_C1C2C3) {
                builder.ciphertext(CryptoUtils.copy(encodedCiphertext, 65, encodedCiphertext.length - 97));
                builder.digest(CryptoUtils.copy(encodedCiphertext, encodedCiphertext.length - 32, 32));
            }
        }
        this.coordX = builder.coordX;
        this.coordY = builder.coordY;
        this.digest = builder.digest;
        this.ciphertext = builder.ciphertext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public byte[] rawC1C3C2() {
        byte[] rawC1C3C2 = new byte[97 + this.ciphertext.length];
        rawC1C3C2[0] = 4;
        System.arraycopy(this.coordX, this.coordX.length == 33 ? 1 : 0, rawC1C3C2, 1, 32);
        System.arraycopy(this.coordY, this.coordY.length == 33 ? 1 : 0, rawC1C3C2, 33, 32);
        System.arraycopy(this.digest, 0, rawC1C3C2, 65, this.digest.length);
        System.arraycopy(this.ciphertext, 0, rawC1C3C2, 65 + this.digest.length, this.ciphertext.length);
        return rawC1C3C2;
    }

    public byte[] rawC1C2C3() {
        byte[] rawC1C2C3 = new byte[97 + this.ciphertext.length];
        rawC1C2C3[0] = 4;
        System.arraycopy(this.coordX, this.coordX.length == 33 ? 1 : 0, rawC1C2C3, 1, 32);
        System.arraycopy(this.coordY, this.coordY.length == 33 ? 1 : 0, rawC1C2C3, 33, 32);
        System.arraycopy(this.ciphertext, 0, rawC1C2C3, 65, this.ciphertext.length);
        System.arraycopy(this.digest, 0, rawC1C2C3, 65 + this.ciphertext.length, this.digest.length);
        return rawC1C2C3;
    }

    public byte[] derC1C3C2() throws IOException {
        DerValue[] values = new DerValue[]{new DerValue(2, new BigInteger(1, this.coordX).toByteArray()), new DerValue(2, new BigInteger(1, this.coordY).toByteArray()), new DerValue(4, this.digest), new DerValue(4, this.ciphertext)};
        DerOutputStream derOut = new DerOutputStream();
        derOut.putSequence(values);
        return derOut.toByteArray();
    }

    public byte[] derC1C2C3() throws IOException {
        DerValue[] values = new DerValue[]{new DerValue(2, new BigInteger(1, this.coordX).toByteArray()), new DerValue(2, new BigInteger(1, this.coordY).toByteArray()), new DerValue(4, this.ciphertext), new DerValue(4, this.digest)};
        DerOutputStream derOut = new DerOutputStream();
        derOut.putSequence(values);
        return derOut.toByteArray();
    }

    public static class Builder {
        private Format format;
        private byte[] encodedCiphertext;
        private byte[] coordX;
        private byte[] coordY;
        private byte[] digest;
        private byte[] ciphertext;

        public Builder format(Format format) {
            this.format = format;
            return this;
        }

        public Builder encodedCiphertext(byte[] encodedCiphertext) {
            Objects.requireNonNull(encodedCiphertext);
            this.encodedCiphertext = encodedCiphertext;
            return this;
        }

        public Builder coordX(byte[] coordX) {
            byte[] adjustedCoordX = this.adjustCoord(coordX);
            Builder.checkCoordinate(adjustedCoordX);
            this.coordX = adjustedCoordX;
            return this;
        }

        public Builder coordY(byte[] coordY) {
            byte[] adjustedCoordY = this.adjustCoord(coordY);
            Builder.checkCoordinate(adjustedCoordY);
            this.coordY = adjustedCoordY;
            return this;
        }

        public Builder digest(byte[] digest) {
            if (digest.length != 32) {
                throw new IllegalArgumentException("Illegal digest: " + CryptoUtils.toHex(digest));
            }
            this.digest = digest;
            return this;
        }

        public Builder ciphertext(byte[] ciphertext) {
            Objects.requireNonNull(ciphertext);
            this.ciphertext = ciphertext;
            return this;
        }

        private static void checkCoordinate(byte[] coordinate) {
            if (coordinate.length != 32 && (coordinate.length != 33 || coordinate[0] != 0)) {
                throw new IllegalArgumentException("Illegal coordinate: " + CryptoUtils.toHex(coordinate));
            }
        }

        public SM2Ciphertext build() throws IOException {
            return new SM2Ciphertext(this);
        }

        private byte[] adjustCoord(byte[] coord) {
            if (coord.length >= 32) {
                return coord;
            }
            byte[] adjusted = new byte[32];
            System.arraycopy(coord, 0, adjusted, adjusted.length - coord.length, coord.length);
            return adjusted;
        }
    }

    public static enum Format {
        NONE,
        DER_C1C3C2,
        RAW_C1C3C2,
        DER_C1C2C3,
        RAW_C1C2C3;

    }
}

