/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Sweeper {
    private final Collection<ResourceHolderRef> resourceHolderRefs = new ConcurrentLinkedQueue<ResourceHolderRef>();
    private final ReferenceQueue<Object> resourceHolderRefQueue = new ReferenceQueue();
    private final Thread sweeperThread = new Thread(() -> {
        while (true) {
            try {
                while (true) {
                    this.resourceHolderRefQueue.remove().clear();
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    });
    private boolean started = false;

    public static Sweeper instance() {
        return InstanceHolder.INSTANCE;
    }

    public Sweeper(boolean startImmediately) {
        this.sweeperThread.setDaemon(true);
        if (startImmediately) {
            this.start();
        }
    }

    public Sweeper() {
        this(true);
    }

    public synchronized void start() {
        if (!this.started) {
            this.sweeperThread.start();
            this.started = true;
        }
    }

    public void register(Object resourceHolder, Runnable sweep) {
        Objects.requireNonNull(resourceHolder);
        Objects.requireNonNull(sweep);
        this.resourceHolderRefs.add(new ResourceHolderRef(resourceHolder, this.resourceHolderRefQueue, sweep));
    }

    public void clean() {
    }

    public int size() {
        return this.resourceHolderRefs.size();
    }

    public boolean isEmpty() {
        return this.resourceHolderRefs.isEmpty();
    }

    private class ResourceHolderRef
    extends PhantomReference<Object> {
        private final Runnable sweep;

        private ResourceHolderRef(Object resourceHolder, ReferenceQueue<Object> resourceHolderRefQueue, Runnable sweep) {
            super(resourceHolder, resourceHolderRefQueue);
            this.sweep = sweep;
        }

        @Override
        public void clear() {
            this.sweep.run();
            Sweeper.this.resourceHolderRefs.remove(this);
            super.clear();
        }
    }

    private static class InstanceHolder {
        private static final Sweeper INSTANCE = new Sweeper();

        private InstanceHolder() {
        }
    }
}

