/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.internal.spec;

import com.tencent.kona.sun.security.action.GetBooleanAction;
import java.security.AccessController;
import java.security.spec.AlgorithmParameterSpec;

@Deprecated
public class TlsRsaPremasterSecretParameterSpec
implements AlgorithmParameterSpec {
    private final byte[] encodedSecret;
    private static final boolean rsaPreMasterSecretFix = AccessController.doPrivileged(new GetBooleanAction("com.tencent.kona.ssl.rsaPreMasterSecretFix"));
    private final int clientVersion;
    private final int serverVersion;

    public TlsRsaPremasterSecretParameterSpec(int clientVersion, int serverVersion) {
        this.clientVersion = this.checkVersion(clientVersion);
        this.serverVersion = this.checkVersion(serverVersion);
        this.encodedSecret = null;
    }

    public TlsRsaPremasterSecretParameterSpec(int clientVersion, int serverVersion, byte[] encodedSecret) {
        this.clientVersion = this.checkVersion(clientVersion);
        this.serverVersion = this.checkVersion(serverVersion);
        if (encodedSecret == null || encodedSecret.length != 48) {
            throw new IllegalArgumentException("Encoded secret is not exactly 48 bytes");
        }
        this.encodedSecret = (byte[])encodedSecret.clone();
    }

    public int getClientVersion() {
        return this.clientVersion;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public int getMajorVersion() {
        if (rsaPreMasterSecretFix || this.clientVersion >= 770) {
            return this.clientVersion >>> 8 & 0xFF;
        }
        return this.serverVersion >>> 8 & 0xFF;
    }

    public int getMinorVersion() {
        if (rsaPreMasterSecretFix || this.clientVersion >= 770) {
            return this.clientVersion & 0xFF;
        }
        return this.serverVersion & 0xFF;
    }

    private int checkVersion(int version) {
        if (version < 0 || version > 65535) {
            throw new IllegalArgumentException("Version must be between 0 and 65,535");
        }
        return version;
    }

    public byte[] getEncodedSecret() {
        return this.encodedSecret == null ? null : (byte[])this.encodedSecret.clone();
    }
}

