/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.provider;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.sun.security.internal.spec.TlsKeyMaterialParameterSpec;
import com.tencent.kona.sun.security.internal.spec.TlsKeyMaterialSpec;
import com.tencent.kona.sun.security.provider.TlsPrfGenerator;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class TlsKeyMaterialGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsKeyMaterialGenerator must be initialized using a TlsKeyMaterialParameterSpec";
    private TlsKeyMaterialParameterSpec spec;
    private int protocolVersion;

    @Override
    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof TlsKeyMaterialParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsKeyMaterialParameterSpec)params;
        if (!"RAW".equals(this.spec.getMasterSecret().getFormat())) {
            throw new InvalidAlgorithmParameterException("Key format must be RAW");
        }
        this.protocolVersion = this.spec.getMajorVersion() << 8 | this.spec.getMinorVersion();
        if (this.protocolVersion != 257 && (this.protocolVersion < 768 || this.protocolVersion > 771)) {
            throw new InvalidAlgorithmParameterException("Only TLCP, SSL 3.0, TLS 1.0/1.1/1.2 supported");
        }
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsKeyMaterialGenerator must be initialized");
        }
        byte[] masterSecret = this.spec.getMasterSecret().getEncoded();
        try {
            SecretKey secretKey = this.engineGenerateKey0(masterSecret);
            return secretKey;
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e);
        }
        finally {
            Arrays.fill(masterSecret, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKey engineGenerateKey0(byte[] masterSecret) throws GeneralSecurityException {
        byte[] keyBlock;
        byte[] seed;
        byte[] clientRandom = this.spec.getClientRandom();
        byte[] serverRandom = this.spec.getServerRandom();
        SecretKeySpec clientMacKey = null;
        SecretKeySpec serverMacKey = null;
        SecretKeySpec clientCipherKey = null;
        SecretKeySpec serverCipherKey = null;
        IvParameterSpec clientIv = null;
        IvParameterSpec serverIv = null;
        int macLength = this.spec.getMacKeyLength();
        int expandedKeyLength = this.spec.getExpandedCipherKeyLength();
        boolean isExportable = expandedKeyLength != 0;
        int keyLength = this.spec.getCipherKeyLength();
        int ivLength = this.spec.getIvLength();
        int keyBlockLen = macLength + keyLength + (isExportable ? 0 : ivLength);
        keyBlockLen <<= 1;
        MessageDigest md5 = null;
        MessageDigest sha = null;
        if (this.protocolVersion >= 771 || this.protocolVersion == 257) {
            seed = TlsPrfGenerator.concat(serverRandom, clientRandom);
            keyBlock = TlsPrfGenerator.doTLS12PRF(masterSecret, TlsPrfGenerator.LABEL_KEY_EXPANSION, seed, keyBlockLen, this.spec.getPRFHashAlg(), this.spec.getPRFHashLength(), this.spec.getPRFBlockSize());
        } else if (this.protocolVersion >= 769) {
            md5 = CryptoInsts.getMessageDigest("MD5");
            sha = CryptoInsts.getMessageDigest("SHA1");
            seed = TlsPrfGenerator.concat(serverRandom, clientRandom);
            keyBlock = TlsPrfGenerator.doTLS10PRF(masterSecret, TlsPrfGenerator.LABEL_KEY_EXPANSION, seed, keyBlockLen, md5, sha);
        } else {
            md5 = CryptoInsts.getMessageDigest("MD5");
            sha = CryptoInsts.getMessageDigest("SHA1");
            keyBlock = new byte[keyBlockLen];
            byte[] tmp = new byte[20];
            int i = 0;
            for (int remaining = keyBlockLen; remaining > 0; remaining -= 16) {
                sha.update(TlsPrfGenerator.SSL3_CONST[i]);
                sha.update(masterSecret);
                sha.update(serverRandom);
                sha.update(clientRandom);
                sha.digest(tmp, 0, 20);
                md5.update(masterSecret);
                md5.update(tmp);
                if (remaining >= 16) {
                    md5.digest(keyBlock, i << 4, 16);
                } else {
                    md5.digest(tmp, 0, 16);
                    System.arraycopy(tmp, 0, keyBlock, i << 4, remaining);
                }
                ++i;
            }
        }
        int ofs = 0;
        if (macLength != 0) {
            clientMacKey = new SecretKeySpec(keyBlock, ofs, macLength, "Mac");
            serverMacKey = new SecretKeySpec(keyBlock, ofs += macLength, macLength, "Mac");
            ofs += macLength;
        }
        if (keyLength == 0) {
            return new TlsKeyMaterialSpec(clientMacKey, serverMacKey);
        }
        String alg = this.spec.getCipherAlgorithm();
        byte[] clientKeyBytes = new byte[keyLength];
        System.arraycopy(keyBlock, ofs, clientKeyBytes, 0, keyLength);
        byte[] serverKeyBytes = new byte[keyLength];
        System.arraycopy(keyBlock, ofs += keyLength, serverKeyBytes, 0, keyLength);
        ofs += keyLength;
        try {
            if (!isExportable) {
                clientCipherKey = new SecretKeySpec(clientKeyBytes, alg);
                serverCipherKey = new SecretKeySpec(serverKeyBytes, alg);
                if (ivLength != 0) {
                    clientIv = new IvParameterSpec(keyBlock, ofs, ivLength);
                    serverIv = new IvParameterSpec(keyBlock, ofs += ivLength, ivLength);
                    ofs += ivLength;
                }
            } else {
                if (this.protocolVersion >= 770) {
                    throw new RuntimeException("Internal Error:  TLS 1.1+ should not be negotiating exportable ciphersuites");
                }
                if (this.protocolVersion == 769) {
                    byte[] seed2 = TlsPrfGenerator.concat(clientRandom, serverRandom);
                    byte[] tmp = TlsPrfGenerator.doTLS10PRF(clientKeyBytes, TlsPrfGenerator.LABEL_CLIENT_WRITE_KEY, seed2, expandedKeyLength, md5, sha);
                    clientCipherKey = new SecretKeySpec(tmp, alg);
                    Arrays.fill(tmp, (byte)0);
                    tmp = TlsPrfGenerator.doTLS10PRF(serverKeyBytes, TlsPrfGenerator.LABEL_SERVER_WRITE_KEY, seed2, expandedKeyLength, md5, sha);
                    serverCipherKey = new SecretKeySpec(tmp, alg);
                    Arrays.fill(tmp, (byte)0);
                    if (ivLength != 0) {
                        byte[] block = TlsPrfGenerator.doTLS10PRF(null, TlsPrfGenerator.LABEL_IV_BLOCK, seed2, ivLength << 1, md5, sha);
                        clientIv = new IvParameterSpec(block, 0, ivLength);
                        serverIv = new IvParameterSpec(block, ivLength, ivLength);
                    }
                } else {
                    byte[] tmp = new byte[expandedKeyLength];
                    md5.update(clientKeyBytes);
                    md5.update(clientRandom);
                    md5.update(serverRandom);
                    byte[] digest = md5.digest();
                    System.arraycopy(digest, 0, tmp, 0, expandedKeyLength);
                    clientCipherKey = new SecretKeySpec(tmp, alg);
                    Arrays.fill(digest, (byte)0);
                    md5.update(serverKeyBytes);
                    md5.update(serverRandom);
                    md5.update(clientRandom);
                    digest = md5.digest();
                    System.arraycopy(digest, 0, tmp, 0, expandedKeyLength);
                    serverCipherKey = new SecretKeySpec(tmp, alg);
                    Arrays.fill(digest, (byte)0);
                    Arrays.fill(tmp, (byte)0);
                    if (ivLength != 0) {
                        tmp = new byte[ivLength];
                        md5.update(clientRandom);
                        md5.update(serverRandom);
                        System.arraycopy(md5.digest(), 0, tmp, 0, ivLength);
                        clientIv = new IvParameterSpec(tmp);
                        md5.update(serverRandom);
                        md5.update(clientRandom);
                        System.arraycopy(md5.digest(), 0, tmp, 0, ivLength);
                        serverIv = new IvParameterSpec(tmp);
                    }
                }
            }
        }
        finally {
            Arrays.fill(serverKeyBytes, (byte)0);
            Arrays.fill(clientKeyBytes, (byte)0);
            Arrays.fill(keyBlock, (byte)0);
        }
        return new TlsKeyMaterialSpec(clientMacKey, serverMacKey, clientCipherKey, clientIv, serverCipherKey, serverIv);
    }
}

