/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.provider.certpath;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;

public class CollectionCertStore
extends CertStoreSpi {
    private final Collection<?> coll;

    public CollectionCertStore(CertStoreParameters params) throws InvalidAlgorithmParameterException {
        super(params);
        if (!(params instanceof CollectionCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("parameters must be CollectionCertStoreParameters");
        }
        this.coll = ((CollectionCertStoreParameters)params).getCollection();
    }

    public Collection<Certificate> engineGetCertificates(CertSelector selector) throws CertStoreException {
        if (this.coll == null) {
            throw new CertStoreException("Collection is null");
        }
        for (int c = 0; c < 10; ++c) {
            try {
                HashSet<Certificate> result = new HashSet<Certificate>();
                if (selector != null) {
                    for (Object o : this.coll) {
                        if (!(o instanceof Certificate) || !selector.match((Certificate)o)) continue;
                        result.add((Certificate)o);
                    }
                } else {
                    for (Object o : this.coll) {
                        if (!(o instanceof Certificate)) continue;
                        result.add((Certificate)o);
                    }
                }
                return result;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        throw new ConcurrentModificationException("Too many ConcurrentModificationExceptions");
    }

    public Collection<CRL> engineGetCRLs(CRLSelector selector) throws CertStoreException {
        if (this.coll == null) {
            throw new CertStoreException("Collection is null");
        }
        for (int c = 0; c < 10; ++c) {
            try {
                HashSet<CRL> result = new HashSet<CRL>();
                if (selector != null) {
                    for (Object o : this.coll) {
                        if (!(o instanceof CRL) || !selector.match((CRL)o)) continue;
                        result.add((CRL)o);
                    }
                } else {
                    for (Object o : this.coll) {
                        if (!(o instanceof CRL)) continue;
                        result.add((CRL)o);
                    }
                }
                return result;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        throw new ConcurrentModificationException("Too many ConcurrentModificationExceptions");
    }
}

