/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.provider.certpath;

import com.tencent.kona.sun.security.provider.certpath.AdaptableX509CertSelector;
import com.tencent.kona.sun.security.provider.certpath.Builder;
import com.tencent.kona.sun.security.provider.certpath.ForwardState;
import com.tencent.kona.sun.security.provider.certpath.KeyChecker;
import com.tencent.kona.sun.security.provider.certpath.PKIX;
import com.tencent.kona.sun.security.provider.certpath.State;
import com.tencent.kona.sun.security.provider.certpath.URICertStore;
import com.tencent.kona.sun.security.util.Debug;
import com.tencent.kona.sun.security.util.ObjectIdentifier;
import com.tencent.kona.sun.security.x509.AVA;
import com.tencent.kona.sun.security.x509.AccessDescription;
import com.tencent.kona.sun.security.x509.AuthorityInfoAccessExtension;
import com.tencent.kona.sun.security.x509.AuthorityKeyIdentifierExtension;
import com.tencent.kona.sun.security.x509.PKIXExtensions;
import com.tencent.kona.sun.security.x509.RDN;
import com.tencent.kona.sun.security.x509.X500Name;
import com.tencent.kona.sun.security.x509.X509CertImpl;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;

public class ForwardBuilder
extends Builder {
    private static final Debug debug = Debug.getInstance("certpath");
    private final Set<X509Certificate> trustedCerts;
    private final Set<X500Principal> trustedSubjectDNs;
    private final Set<TrustAnchor> trustAnchors;
    private X509CertSelector eeSelector;
    private AdaptableX509CertSelector caSelector;
    private X509CertSelector caTargetSelector;
    TrustAnchor trustAnchor;
    private final boolean searchAllCertStores;
    private static ThreadLocal<Object> gate = new ThreadLocal();

    ForwardBuilder(PKIX.BuilderParams buildParams, boolean searchAllCertStores) {
        super(buildParams);
        this.trustAnchors = buildParams.trustAnchors();
        this.trustedCerts = new HashSet<X509Certificate>(this.trustAnchors.size());
        this.trustedSubjectDNs = new HashSet<X500Principal>(this.trustAnchors.size());
        for (TrustAnchor anchor : this.trustAnchors) {
            X509Certificate trustedCert = anchor.getTrustedCert();
            if (trustedCert != null) {
                this.trustedCerts.add(trustedCert);
                this.trustedSubjectDNs.add(trustedCert.getSubjectX500Principal());
                continue;
            }
            this.trustedSubjectDNs.add(anchor.getCA());
        }
        this.searchAllCertStores = searchAllCertStores;
    }

    @Override
    Collection<X509Certificate> getMatchingCerts(State currentState, List<CertStore> certStores) throws IOException {
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingCerts()...");
        }
        ForwardState currState = (ForwardState)currentState;
        PKIXCertComparator comparator = new PKIXCertComparator(this.trustedSubjectDNs, currState.cert);
        TreeSet<X509Certificate> certs = new TreeSet<X509Certificate>(comparator);
        if (currState.isInitial()) {
            this.getMatchingEECerts(currState, certStores, certs);
        }
        this.getMatchingCACerts(currState, certStores, certs);
        return certs;
    }

    private void getMatchingEECerts(ForwardState currentState, List<CertStore> certStores, Collection<X509Certificate> eeCerts) throws IOException {
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingEECerts()...");
        }
        if (this.eeSelector == null) {
            this.eeSelector = (X509CertSelector)this.targetCertConstraints.clone();
            this.eeSelector.setCertificateValid(this.buildParams.date());
            if (this.buildParams.explicitPolicyRequired()) {
                this.eeSelector.setPolicy(this.getMatchingPolicies());
            }
            this.eeSelector.setBasicConstraints(-2);
        }
        this.addMatchingCerts(this.eeSelector, certStores, eeCerts, this.searchAllCertStores);
    }

    private void getMatchingCACerts(ForwardState currentState, List<CertStore> certStores, Collection<X509Certificate> caCerts) throws IOException {
        AuthorityInfoAccessExtension aiaExt;
        X509CertSelector sel;
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingCACerts()...");
        }
        int initialSize = caCerts.size();
        if (currentState.isInitial()) {
            if (this.targetCertConstraints.getBasicConstraints() == -2) {
                return;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.getMatchingCACerts(): the target is a CA");
            }
            if (this.caTargetSelector == null) {
                this.caTargetSelector = (X509CertSelector)this.targetCertConstraints.clone();
                if (this.buildParams.explicitPolicyRequired()) {
                    this.caTargetSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            sel = this.caTargetSelector;
        } else {
            if (this.caSelector == null) {
                this.caSelector = new AdaptableX509CertSelector();
                if (this.buildParams.explicitPolicyRequired()) {
                    this.caSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            this.caSelector.setSubject(currentState.issuerDN);
            this.caSelector.setValidityPeriod(currentState.cert.getNotBefore(), currentState.cert.getNotAfter());
            sel = this.caSelector;
        }
        sel.setBasicConstraints(-1);
        for (X509Certificate trustedCert : this.trustedCerts) {
            if (!sel.match(trustedCert)) continue;
            if (debug != null) {
                debug.println("ForwardBuilder.getMatchingCACerts: found matching trust anchor.\n  SN: " + Debug.toString(trustedCert.getSerialNumber()) + "\n  Subject: " + trustedCert.getSubjectX500Principal() + "\n  Issuer: " + trustedCert.getIssuerX500Principal());
            }
            caCerts.add(trustedCert);
        }
        sel.setCertificateValid(this.buildParams.date());
        sel.setBasicConstraints(currentState.traversedCACerts);
        if ((currentState.isInitial() || this.buildParams.maxPathLength() == -1 || this.buildParams.maxPathLength() > currentState.traversedCACerts) && this.addMatchingCerts(sel, certStores, caCerts, this.searchAllCertStores) && !this.searchAllCertStores) {
            return;
        }
        if (!currentState.isInitial() && USE_AIA && (aiaExt = currentState.cert.getAuthorityInfoAccessExtension()) != null) {
            this.getCerts(aiaExt, caCerts);
        }
        if (debug != null) {
            int numCerts = caCerts.size() - initialSize;
            debug.println("ForwardBuilder.getMatchingCACerts: found " + numCerts + " CA certs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getCerts(AuthorityInfoAccessExtension aiaExt, Collection<X509Certificate> certs) {
        if (!USE_AIA) {
            return false;
        }
        List<AccessDescription> adList = aiaExt.getAccessDescriptions();
        if (adList == null || adList.isEmpty()) {
            return false;
        }
        if (gate.get() != null) {
            if (debug != null) {
                debug.println("Recursive fetching of certs via the AIA extension detected");
            }
            return false;
        }
        gate.set(gate);
        try {
            boolean add = false;
            for (AccessDescription ad : adList) {
                CertStore cs = URICertStore.getInstance(ad);
                if (cs == null) continue;
                try {
                    if (!certs.addAll(cs.getCertificates(this.caSelector))) continue;
                    add = true;
                    if (this.searchAllCertStores) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (CertStoreException cse) {
                    if (debug == null) continue;
                    debug.println("exception getting certs from CertStore:");
                    cse.printStackTrace();
                }
            }
            boolean bl = add;
            return bl;
        }
        finally {
            gate.set(null);
        }
    }

    private static int distanceToCommonAncestor(X500Name anchor, X500Name issuer) {
        int i;
        List<RDN> anchorRdns = anchor.rdns();
        List<RDN> issuerRdns = issuer.rdns();
        int minLen = Math.min(anchorRdns.size(), issuerRdns.size());
        if (minLen == 0) {
            return -1;
        }
        for (i = 0; i < minLen; ++i) {
            RDN rdn = anchorRdns.get(i);
            if (rdn.equals(issuerRdns.get(i))) continue;
            if (i != 0) break;
            return -1;
        }
        RDN lastRDN = anchorRdns.get(i - 1);
        for (AVA ava : lastRDN.avas()) {
            ObjectIdentifier oid = ava.getObjectIdentifier();
            if (!oid.equals(X500Name.countryName_oid) && !oid.equals(X500Name.stateName_oid) && !oid.equals(X500Name.localityName_oid) && !oid.equals(X500Name.streetAddress_oid)) continue;
            return -1;
        }
        return issuer.size() - i;
    }

    @Override
    void verifyCert(X509Certificate cert, State currentState, List<X509Certificate> certPathList) throws GeneralSecurityException {
        if (debug != null) {
            debug.println("ForwardBuilder.verifyCert(SN: " + Debug.toString(cert.getSerialNumber()) + "\n  Issuer: " + cert.getIssuerX500Principal() + ")\n  Subject: " + cert.getSubjectX500Principal() + ")");
        }
        ForwardState currState = (ForwardState)currentState;
        currState.untrustedChecker.check(cert, Collections.emptySet());
        boolean isTrustedCert = this.trustedCerts.contains(cert);
        if (!isTrustedCert) {
            Set<String> unresCritExts = cert.getCriticalExtensionOIDs();
            if (unresCritExts == null) {
                unresCritExts = Collections.emptySet();
            }
            for (PKIXCertPathChecker checker : currState.forwardCheckers) {
                checker.check(cert, unresCritExts);
            }
            for (PKIXCertPathChecker checker : this.buildParams.certPathCheckers()) {
                Set<String> supportedExts;
                if (checker.isForwardCheckingSupported() || (supportedExts = checker.getSupportedExtensions()) == null) continue;
                unresCritExts.removeAll(supportedExts);
            }
            if (!unresCritExts.isEmpty()) {
                unresCritExts.remove(PKIXExtensions.BasicConstraints_Id.toString());
                unresCritExts.remove(PKIXExtensions.NameConstraints_Id.toString());
                unresCritExts.remove(PKIXExtensions.CertificatePolicies_Id.toString());
                unresCritExts.remove(PKIXExtensions.PolicyMappings_Id.toString());
                unresCritExts.remove(PKIXExtensions.PolicyConstraints_Id.toString());
                unresCritExts.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
                unresCritExts.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
                unresCritExts.remove(PKIXExtensions.KeyUsage_Id.toString());
                unresCritExts.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
                if (!unresCritExts.isEmpty()) {
                    throw new CertPathValidatorException("Unrecognized critical extension(s)", null, null, -1, PKIXReason.UNRECOGNIZED_CRIT_EXT);
                }
            }
        }
        if (currState.isInitial()) {
            return;
        }
        if (!isTrustedCert) {
            if (cert.getBasicConstraints() == -1) {
                throw new CertificateException("cert is NOT a CA cert");
            }
            KeyChecker.verifyCAKeyUsage(cert);
        }
    }

    @Override
    boolean isPathCompleted(X509Certificate cert) {
        PublicKey publicKey;
        X500Principal principal;
        ArrayList<TrustAnchor> otherAnchors = new ArrayList<TrustAnchor>();
        for (TrustAnchor anchor : this.trustAnchors) {
            if (anchor.getTrustedCert() != null) {
                if (!cert.equals(anchor.getTrustedCert())) continue;
                this.trustAnchor = anchor;
                return true;
            }
            principal = anchor.getCA();
            publicKey = anchor.getCAPublicKey();
            if (principal != null && publicKey != null && principal.equals(cert.getSubjectX500Principal()) && publicKey.equals(cert.getPublicKey())) {
                this.trustAnchor = anchor;
                return true;
            }
            otherAnchors.add(anchor);
        }
        for (TrustAnchor anchor : otherAnchors) {
            principal = anchor.getCA();
            publicKey = anchor.getCAPublicKey();
            if (principal == null || !principal.equals(cert.getIssuerX500Principal()) || PKIX.isDSAPublicKeyWithoutParams(publicKey)) continue;
            try {
                cert.verify(publicKey, this.buildParams.sigProvider());
            }
            catch (InvalidKeyException ike) {
                if (debug == null) continue;
                debug.println("ForwardBuilder.isPathCompleted() invalid DSA key found");
                continue;
            }
            catch (GeneralSecurityException e) {
                if (debug == null) continue;
                debug.println("ForwardBuilder.isPathCompleted() unexpected exception");
                e.printStackTrace();
                continue;
            }
            this.trustAnchor = anchor;
            return true;
        }
        return false;
    }

    @Override
    void addCertToPath(X509Certificate cert, LinkedList<X509Certificate> certPathList) {
        certPathList.addFirst(cert);
    }

    @Override
    void removeFinalCertFromPath(LinkedList<X509Certificate> certPathList) {
        certPathList.removeFirst();
    }

    static class PKIXCertComparator
    implements Comparator<X509Certificate> {
        static final String METHOD_NME = "PKIXCertComparator.compare()";
        private final Set<X500Principal> trustedSubjectDNs;
        private final X509CertSelector certSkidSelector;

        PKIXCertComparator(Set<X500Principal> trustedSubjectDNs, X509CertImpl previousCert) throws IOException {
            this.trustedSubjectDNs = trustedSubjectDNs;
            this.certSkidSelector = this.getSelector(previousCert);
        }

        private X509CertSelector getSelector(X509CertImpl previousCert) throws IOException {
            byte[] skid;
            AuthorityKeyIdentifierExtension akidExt;
            if (previousCert != null && (akidExt = previousCert.getAuthorityKeyIdentifierExtension()) != null && (skid = akidExt.getEncodedKeyIdentifier()) != null) {
                X509CertSelector selector = new X509CertSelector();
                selector.setSubjectKeyIdentifier(skid);
                return selector;
            }
            return null;
        }

        @Override
        public int compare(X509Certificate oCert1, X509Certificate oCert2) {
            if (oCert1.equals(oCert2)) {
                return 0;
            }
            if (this.certSkidSelector != null) {
                if (this.certSkidSelector.match(oCert1)) {
                    return -1;
                }
                if (this.certSkidSelector.match(oCert2)) {
                    return 1;
                }
            }
            X500Principal cIssuer1 = oCert1.getIssuerX500Principal();
            X500Principal cIssuer2 = oCert2.getIssuerX500Principal();
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() cert1 Issuer:  " + cIssuer1);
                debug.println("PKIXCertComparator.compare() cert2 Issuer:  " + cIssuer2);
                debug.println("PKIXCertComparator.compare() MATCH TRUSTED SUBJECT TEST...");
            }
            if (this.trustedSubjectDNs.contains(cIssuer1)) {
                return -1;
            }
            if (this.trustedSubjectDNs.contains(cIssuer2)) {
                return 1;
            }
            String debugMsg = null;
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() SAME NAMESPACE AS TRUSTED TEST...");
                debugMsg = "PKIXCertComparator.compare() distance (number of RDNs) from cert%1$s issuer to trusted subject %2$s: %3$d";
            }
            X500Name cIssuer1Name = X500Name.asX500Name(cIssuer1);
            X500Name cIssuer2Name = X500Name.asX500Name(cIssuer2);
            for (X500Principal tSubject : this.trustedSubjectDNs) {
                X500Name tSubjectName = X500Name.asX500Name(tSubject);
                int d1 = ForwardBuilder.distanceToCommonAncestor(tSubjectName, cIssuer1Name);
                int d2 = ForwardBuilder.distanceToCommonAncestor(tSubjectName, cIssuer2Name);
                if (debug != null) {
                    if (d1 != -1) {
                        debug.println(String.format(debugMsg, "1", tSubject, d1));
                    }
                    if (d2 != -1) {
                        debug.println(String.format(debugMsg, "2", tSubject, d2));
                    }
                }
                if (d1 == -1 && d2 == -1) continue;
                if (d1 != -1) {
                    if (d2 != -1) {
                        return d1 > d2 ? 1 : -1;
                    }
                    return -1;
                }
                if (d2 == -1) continue;
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() no tests matched; RETURN -1");
            }
            return -1;
        }
    }
}

