/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.provider.certpath;

import com.tencent.kona.sun.security.util.Debug;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.Extension;
import com.tencent.kona.sun.security.x509.PKIXExtensions;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Objects;

public final class OCSPNonceExtension
extends Extension {
    private static final String EXTENSION_NAME = "OCSPNonce";
    private final byte[] nonceData;

    public OCSPNonceExtension(int length) throws IOException {
        this(false, length);
    }

    public OCSPNonceExtension(boolean isCritical, int length) throws IOException {
        this.extensionId = PKIXExtensions.OCSPNonce_Id;
        this.critical = isCritical;
        if (length <= 0 || length > 32) {
            throw new IllegalArgumentException("Length of nonce must be at least 1 byte and can be up to 32 bytes");
        }
        SecureRandom rng = new SecureRandom();
        this.nonceData = new byte[length];
        rng.nextBytes(this.nonceData);
        this.extensionValue = new DerValue(4, this.nonceData).toByteArray();
    }

    public OCSPNonceExtension(byte[] incomingNonce) throws IOException {
        this(false, incomingNonce);
    }

    public OCSPNonceExtension(boolean isCritical, byte[] incomingNonce) throws IOException {
        this.extensionId = PKIXExtensions.OCSPNonce_Id;
        this.critical = isCritical;
        Objects.requireNonNull(incomingNonce, "Nonce data must be non-null");
        if (incomingNonce.length <= 0 || incomingNonce.length > 32) {
            throw new IllegalArgumentException("Nonce data must be at least 1 byte and can be up to 32 bytes in length");
        }
        this.nonceData = (byte[])incomingNonce.clone();
        this.extensionValue = new DerValue(4, this.nonceData).toByteArray();
    }

    public byte[] getNonceValue() {
        return (byte[])this.nonceData.clone();
    }

    @Override
    public String toString() {
        return super.toString() + EXTENSION_NAME + ": " + (this.nonceData == null ? "" : Debug.toString(this.nonceData)) + "\n";
    }

    @Override
    public String getName() {
        return EXTENSION_NAME;
    }
}

