/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.rsa;

import com.tencent.kona.crypto.CryptoInsts;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class MGF1 {
    private final MessageDigest md;

    MGF1(String mdAlgo) throws NoSuchAlgorithmException {
        this.md = CryptoInsts.getMessageDigest(mdAlgo);
    }

    void generateAndXor(byte[] seed, int seedOfs, int seedLen, int maskLen, byte[] out, int outOfs) throws RuntimeException {
        byte[] C = new byte[4];
        byte[] digest = new byte[this.md.getDigestLength()];
        block2: while (maskLen > 0) {
            this.md.update(seed, seedOfs, seedLen);
            this.md.update(C);
            try {
                this.md.digest(digest, 0, digest.length);
            }
            catch (DigestException e) {
                throw new RuntimeException(e.toString());
            }
            int i = 0;
            while (i < digest.length && maskLen > 0) {
                int n = outOfs++;
                out[n] = (byte)(out[n] ^ digest[i++]);
                --maskLen;
            }
            if (maskLen <= 0) continue;
            i = C.length - 1;
            while (true) {
                int n = --i;
                C[n] = (byte)(C[n] + 1);
                if (C[n] != 0 || i <= 0) continue block2;
            }
        }
    }

    String getName() {
        return "MGF1" + this.md.getAlgorithm();
    }
}

