/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.sun.security.ssl.ClientAuthType;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.HandshakeConsumer;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.Record;
import com.tencent.kona.sun.security.ssl.SSLExtension;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLStringizer;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.SignatureAlgorithmsExtension;
import com.tencent.kona.sun.security.ssl.SignatureScheme;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

final class CertSignAlgsExtension {
    static final HandshakeProducer chNetworkProducer = new CHCertSignatureSchemesProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHCertSignatureSchemesConsumer();
    static final HandshakeConsumer chOnTradeConsumer = new CHCertSignatureSchemesUpdate();
    static final HandshakeProducer crNetworkProducer = new CRCertSignatureSchemesProducer();
    static final SSLExtension.ExtensionConsumer crOnLoadConsumer = new CRCertSignatureSchemesConsumer();
    static final HandshakeConsumer crOnTradeConsumer = new CRCertSignatureSchemesUpdate();
    static final SSLStringizer ssStringizer = new CertSignatureSchemesStringizer();

    CertSignAlgsExtension() {
    }

    private static final class CRCertSignatureSchemesUpdate
    implements HandshakeConsumer {
        private CRCertSignatureSchemesUpdate() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            List<SignatureScheme> schemes;
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            SignatureAlgorithmsExtension.SignatureSchemesSpec spec = (SignatureAlgorithmsExtension.SignatureSchemesSpec)chc.handshakeExtensions.get(SSLExtension.CR_SIGNATURE_ALGORITHMS_CERT);
            if (spec == null) {
                return;
            }
            chc.peerRequestedCertSignSchemes = schemes = SignatureScheme.getSupportedAlgorithms(chc.sslConfig, chc.algorithmConstraints, chc.negotiatedProtocol, spec.signatureSchemes);
            chc.handshakeSession.setPeerSupportedSignatureAlgorithms(schemes);
        }
    }

    private static final class CRCertSignatureSchemesConsumer
    implements SSLExtension.ExtensionConsumer {
        private CRCertSignatureSchemesConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message, ByteBuffer buffer) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            if (!chc.sslConfig.isAvailable(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable signature_algorithms_cert extension", new Object[0]);
                }
                return;
            }
            SignatureAlgorithmsExtension.SignatureSchemesSpec spec = new SignatureAlgorithmsExtension.SignatureSchemesSpec(chc, buffer);
            chc.handshakeExtensions.put(SSLExtension.CR_SIGNATURE_ALGORITHMS_CERT, spec);
        }
    }

    private static final class CRCertSignatureSchemesProducer
    implements HandshakeProducer {
        private CRCertSignatureSchemesProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            if (!shc.sslConfig.isAvailable(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable signature_algorithms_cert extension", new Object[0]);
                }
                return null;
            }
            List<SignatureScheme> sigAlgs = SignatureScheme.getSupportedAlgorithms(shc.sslConfig, shc.algorithmConstraints, Arrays.asList(shc.negotiatedProtocol));
            int vectorLen = SignatureScheme.sizeInRecord() * sigAlgs.size();
            byte[] extData = new byte[vectorLen + 2];
            ByteBuffer m = ByteBuffer.wrap(extData);
            Record.putInt16(m, vectorLen);
            for (SignatureScheme ss : sigAlgs) {
                Record.putInt16(m, ss.id);
            }
            shc.handshakeExtensions.put(SSLExtension.CR_SIGNATURE_ALGORITHMS_CERT, new SignatureAlgorithmsExtension.SignatureSchemesSpec(shc.localSupportedSignAlgs));
            return extData;
        }
    }

    private static final class CHCertSignatureSchemesUpdate
    implements HandshakeConsumer {
        private CHCertSignatureSchemesUpdate() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            List<SignatureScheme> schemes;
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            SignatureAlgorithmsExtension.SignatureSchemesSpec spec = (SignatureAlgorithmsExtension.SignatureSchemesSpec)shc.handshakeExtensions.get(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT);
            if (spec == null) {
                return;
            }
            shc.peerRequestedCertSignSchemes = schemes = SignatureScheme.getSupportedAlgorithms(shc.sslConfig, shc.algorithmConstraints, shc.negotiatedProtocol, spec.signatureSchemes);
            shc.handshakeSession.setPeerSupportedSignatureAlgorithms(schemes);
            if (!shc.isResumption && shc.negotiatedProtocol.useTLS13PlusSpec()) {
                if (shc.sslConfig.clientAuthType != ClientAuthType.CLIENT_AUTH_NONE) {
                    shc.handshakeProducers.putIfAbsent(SSLHandshake.CERTIFICATE_REQUEST.id, SSLHandshake.CERTIFICATE_REQUEST);
                }
                shc.handshakeProducers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
                shc.handshakeProducers.putIfAbsent(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
            }
        }
    }

    private static final class CHCertSignatureSchemesConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHCertSignatureSchemesConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message, ByteBuffer buffer) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            if (!shc.sslConfig.isAvailable(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable signature_algorithms_cert extension", new Object[0]);
                }
                return;
            }
            SignatureAlgorithmsExtension.SignatureSchemesSpec spec = new SignatureAlgorithmsExtension.SignatureSchemesSpec(shc, buffer);
            shc.handshakeExtensions.put(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT, spec);
        }
    }

    private static final class CHCertSignatureSchemesProducer
    implements HandshakeProducer {
        private CHCertSignatureSchemesProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            if (!chc.sslConfig.isAvailable(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable signature_algorithms_cert extension", new Object[0]);
                }
                return null;
            }
            if (chc.localSupportedSignAlgs == null) {
                chc.localSupportedSignAlgs = SignatureScheme.getSupportedAlgorithms(chc.sslConfig, chc.algorithmConstraints, chc.activeProtocols);
            }
            int vectorLen = SignatureScheme.sizeInRecord() * chc.localSupportedSignAlgs.size();
            byte[] extData = new byte[vectorLen + 2];
            ByteBuffer m = ByteBuffer.wrap(extData);
            Record.putInt16(m, vectorLen);
            for (SignatureScheme ss : chc.localSupportedSignAlgs) {
                Record.putInt16(m, ss.id);
            }
            chc.handshakeExtensions.put(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT, new SignatureAlgorithmsExtension.SignatureSchemesSpec(chc.localSupportedSignAlgs));
            return extData;
        }
    }

    private static final class CertSignatureSchemesStringizer
    implements SSLStringizer {
        private CertSignatureSchemesStringizer() {
        }

        @Override
        public String toString(HandshakeContext hc, ByteBuffer buffer) {
            try {
                return new SignatureAlgorithmsExtension.SignatureSchemesSpec(hc, buffer).toString();
            }
            catch (IOException ioe) {
                return ioe.getMessage();
            }
        }
    }
}

