/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeOutStream;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.NamedGroup;
import com.tencent.kona.sun.security.ssl.NamedGroupCredentials;
import com.tencent.kona.sun.security.ssl.NamedGroupPossession;
import com.tencent.kona.sun.security.ssl.Record;
import com.tencent.kona.sun.security.ssl.SSLConsumer;
import com.tencent.kona.sun.security.ssl.SSLCredentials;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLKeyDerivation;
import com.tencent.kona.sun.security.ssl.SSLKeyExchange;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.SSLTrafficKeyDerivation;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.Utilities;
import com.tencent.kona.sun.security.ssl.X509Authentication;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Locale;
import javax.crypto.SecretKey;

final class ECDHClientKeyExchange {
    static final SSLConsumer ecdhHandshakeConsumer = new ECDHClientKeyExchangeConsumer();
    static final HandshakeProducer ecdhHandshakeProducer = new ECDHClientKeyExchangeProducer();
    static final SSLConsumer ecdheHandshakeConsumer = new ECDHEClientKeyExchangeConsumer();
    static final HandshakeProducer ecdheHandshakeProducer = new ECDHEClientKeyExchangeProducer();

    ECDHClientKeyExchange() {
    }

    private static final class ECDHEClientKeyExchangeConsumer
    implements SSLConsumer {
        private ECDHEClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            NamedGroupPossession sslPossession = null;
            NamedGroup namedGroup = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (!(possession instanceof NamedGroupPossession)) continue;
                NamedGroupPossession poss = (NamedGroupPossession)possession;
                namedGroup = poss.getNamedGroup();
                sslPossession = poss;
                break;
            }
            if (sslPossession == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "No expected ECDHE possessions for client key exchange");
            }
            if (namedGroup == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported EC server cert for ECDHE client key exchange");
            }
            SSLKeyExchange ke = SSLKeyExchange.valueOf(shc.negotiatedCipherSuite.keyExchange, shc.negotiatedProtocol);
            if (ke == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            ECDHClientKeyExchangeMessage cke = new ECDHClientKeyExchangeMessage((HandshakeContext)shc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming ECDHE ClientKeyExchange handshake message", cke);
            }
            try {
                SSLCredentials sslCredentials = namedGroup.decodeCredentials(cke.encodedPoint);
                if (shc.algorithmConstraints != null && sslCredentials instanceof NamedGroupCredentials) {
                    NamedGroupCredentials namedGroupCredentials = (NamedGroupCredentials)sslCredentials;
                    if (!shc.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroupCredentials.getPublicKey())) {
                        shc.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "ClientKeyExchange for " + (Object)((Object)namedGroup) + " does not comply with algorithm constraints");
                    }
                }
                shc.handshakeCredentials.add(sslCredentials);
            }
            catch (GeneralSecurityException e) {
                throw shc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Cannot decode named group: " + (Object)((Object)namedGroup));
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(shc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            shc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(shc.negotiatedProtocol);
            if (kd == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)shc.negotiatedProtocol));
            }
            shc.handshakeKeyDerivation = kd.createKeyDerivation(shc, masterSecret);
        }
    }

    private static final class ECDHEClientKeyExchangeProducer
    implements HandshakeProducer {
        private ECDHEClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            SSLCredentials sslCredentials = null;
            NamedGroup ng = null;
            for (SSLCredentials cd : chc.handshakeCredentials) {
                if (!(cd instanceof NamedGroupCredentials)) continue;
                NamedGroupCredentials creds = (NamedGroupCredentials)cd;
                ng = creds.getNamedGroup();
                sslCredentials = cd;
                break;
            }
            if (sslCredentials == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "No ECDHE credentials negotiated for client key exchange");
            }
            SSLPossession sslPossession = ng.createPossession(chc.sslContext.getSecureRandom());
            chc.handshakePossessions.add(sslPossession);
            ECDHClientKeyExchangeMessage cke = new ECDHClientKeyExchangeMessage((HandshakeContext)chc, sslPossession.encode());
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced ECDHE ClientKeyExchange handshake message", cke);
            }
            cke.write(chc.handshakeOutput);
            chc.handshakeOutput.flush();
            SSLKeyExchange ke = SSLKeyExchange.valueOf(chc.negotiatedCipherSuite.keyExchange, chc.negotiatedProtocol);
            if (ke == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(chc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            chc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(chc.negotiatedProtocol);
            if (kd == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)chc.negotiatedProtocol));
            }
            chc.handshakeKeyDerivation = kd.createKeyDerivation(chc, masterSecret);
            return null;
        }
    }

    private static final class ECDHClientKeyExchangeConsumer
    implements SSLConsumer {
        private ECDHClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            X509Authentication.X509Possession x509Possession = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (!(possession instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)possession;
                break;
            }
            if (x509Possession == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "No expected EC server cert for ECDH client key exchange");
            }
            ECParameterSpec params = x509Possession.getECParameterSpec();
            if (params == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not EC server cert for ECDH client key exchange");
            }
            NamedGroup namedGroup = NamedGroup.valueOf(params);
            if (namedGroup == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported EC server cert for ECDH client key exchange");
            }
            SSLKeyExchange ke = SSLKeyExchange.valueOf(shc.negotiatedCipherSuite.keyExchange, shc.negotiatedProtocol);
            if (ke == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            ECDHClientKeyExchangeMessage cke = new ECDHClientKeyExchangeMessage((HandshakeContext)shc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming ECDH ClientKeyExchange handshake message", cke);
            }
            try {
                SSLCredentials sslCredentials = namedGroup.decodeCredentials(cke.encodedPoint);
                if (shc.algorithmConstraints != null && sslCredentials instanceof NamedGroupCredentials) {
                    NamedGroupCredentials namedGroupCredentials = (NamedGroupCredentials)sslCredentials;
                    if (!shc.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroupCredentials.getPublicKey())) {
                        shc.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "ClientKeyExchange for " + (Object)((Object)namedGroup) + " does not comply with algorithm constraints");
                    }
                }
                shc.handshakeCredentials.add(sslCredentials);
            }
            catch (GeneralSecurityException e) {
                throw shc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Cannot decode ECDH PublicKey: " + (Object)((Object)namedGroup));
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(shc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            shc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(shc.negotiatedProtocol);
            if (kd == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)shc.negotiatedProtocol));
            }
            shc.handshakeKeyDerivation = kd.createKeyDerivation(shc, masterSecret);
        }
    }

    private static final class ECDHClientKeyExchangeProducer
    implements HandshakeProducer {
        private ECDHClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            X509Authentication.X509Credentials x509Credentials = null;
            for (SSLCredentials credential : chc.handshakeCredentials) {
                if (!(credential instanceof X509Authentication.X509Credentials)) continue;
                x509Credentials = (X509Authentication.X509Credentials)credential;
                break;
            }
            if (x509Credentials == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "No server certificate for ECDH client key exchange");
            }
            PublicKey publicKey = x509Credentials.popPublicKey;
            String algorithm = publicKey.getAlgorithm();
            if (!algorithm.equals("EC")) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not EC server certificate for ECDH client key exchange");
            }
            ECParameterSpec params = ((ECPublicKey)publicKey).getParams();
            NamedGroup namedGroup = NamedGroup.valueOf(params);
            if (namedGroup == null) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported EC server cert for ECDH client key exchange");
            }
            SSLPossession sslPossession = namedGroup.createPossession(chc.sslContext.getSecureRandom());
            chc.handshakePossessions.add(sslPossession);
            ECDHClientKeyExchangeMessage cke = new ECDHClientKeyExchangeMessage((HandshakeContext)chc, sslPossession.encode());
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced ECDH ClientKeyExchange handshake message", cke);
            }
            cke.write(chc.handshakeOutput);
            chc.handshakeOutput.flush();
            SSLKeyExchange ke = SSLKeyExchange.valueOf(chc.negotiatedCipherSuite.keyExchange, chc.negotiatedProtocol);
            if (ke == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(chc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            chc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(chc.negotiatedProtocol);
            if (kd == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)chc.negotiatedProtocol));
            }
            chc.handshakeKeyDerivation = kd.createKeyDerivation(chc, masterSecret);
            return null;
        }
    }

    private static final class ECDHClientKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] encodedPoint;

        ECDHClientKeyExchangeMessage(HandshakeContext handshakeContext, byte[] encodedPublicKey) {
            super(handshakeContext);
            this.encodedPoint = encodedPublicKey;
        }

        ECDHClientKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            this.encodedPoint = m.remaining() != 0 ? Record.getBytes8(m) : new byte[0];
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            if (this.encodedPoint == null || this.encodedPoint.length == 0) {
                return 0;
            }
            return 1 + this.encodedPoint.length;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            if (this.encodedPoint != null && this.encodedPoint.length != 0) {
                hos.putBytes8(this.encodedPoint);
            }
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"ECDH ClientKeyExchange\": '{'\n  \"ecdh public\": '{'\n{0}\n  '}',\n'}'", Locale.ENGLISH);
            if (this.encodedPoint == null || this.encodedPoint.length == 0) {
                Object[] messageFields = new Object[]{"    <implicit>"};
                return messageFormat.format(messageFields);
            }
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{Utilities.indent(hexEncoder.encodeBuffer(this.encodedPoint), "    ")};
            return messageFormat.format(messageFields);
        }
    }
}

