/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.crypto.spec.SM2KeyAgreementParamSpec;
import com.tencent.kona.crypto.spec.SM2PublicKeySpec;
import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeOutStream;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.NamedGroup;
import com.tencent.kona.sun.security.ssl.NamedGroupCredentials;
import com.tencent.kona.sun.security.ssl.Record;
import com.tencent.kona.sun.security.ssl.SM2EKeyExchange;
import com.tencent.kona.sun.security.ssl.SSLConsumer;
import com.tencent.kona.sun.security.ssl.SSLCredentials;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLKeyDerivation;
import com.tencent.kona.sun.security.ssl.SSLKeyExchange;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.SSLTrafficKeyDerivation;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.TLCPAuthentication;
import com.tencent.kona.sun.security.ssl.Utilities;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Locale;
import javax.crypto.SecretKey;

public class SM2EClientKeyExchange {
    static final SSLConsumer sm2eHandshakeConsumer = new SM2EClientKeyExchangeConsumer();
    static final HandshakeProducer sm2eHandshakeProducer = new SM2EClientKeyExchangeProducer();

    private static final class SM2EClientKeyExchangeConsumer
    implements SSLConsumer {
        private SM2EClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            SM2EKeyExchange.SM2EPossession sm2ePossession = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (!(possession instanceof SM2EKeyExchange.SM2EPossession)) continue;
                sm2ePossession = (SM2EKeyExchange.SM2EPossession)possession;
                break;
            }
            if (sm2ePossession == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "No expected SM2E possessions for client key exchange");
            }
            NamedGroup namedGroup = NamedGroup.valueOf(sm2ePossession.popEncPublicKey.getParams());
            if (namedGroup != NamedGroup.CURVESM2) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported EC server cert for SM2E client key exchange");
            }
            SSLKeyExchange ke = SSLKeyExchange.valueOf(shc.negotiatedCipherSuite.keyExchange, shc.negotiatedProtocol);
            if (ke == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SM2EClientKeyExchangeMessage cke = new SM2EClientKeyExchangeMessage((HandshakeContext)shc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming SM2E ClientKeyExchange handshake message", cke);
            }
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("SM2");
                ECPublicKey ecPublicKey = (ECPublicKey)keyFactory.generatePublic(new SM2PublicKeySpec(cke.encodedPoint));
                SSLCredentials sslCredentials = new SM2EKeyExchange.SM2ECredentials(ecPublicKey, namedGroup);
                if (shc.algorithmConstraints != null && sslCredentials instanceof NamedGroupCredentials) {
                    NamedGroupCredentials namedGroupCredentials = sslCredentials;
                    if (!shc.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroupCredentials.getPublicKey())) {
                        shc.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "ClientKeyExchange for " + (Object)((Object)namedGroup) + " does not comply with algorithm constraints");
                    }
                }
                shc.handshakeCredentials.add(sslCredentials);
            }
            catch (GeneralSecurityException e) {
                throw shc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Cannot decode ECDH PublicKey: " + (Object)((Object)namedGroup));
            }
            TLCPAuthentication.TLCPCredentials tlcpCredentials = null;
            for (SSLCredentials sslCredentials : shc.handshakeCredentials) {
                if (!(sslCredentials instanceof TLCPAuthentication.TLCPCredentials)) continue;
                tlcpCredentials = (TLCPAuthentication.TLCPCredentials)sslCredentials;
                break;
            }
            SM2KeyAgreementParamSpec params = new SM2KeyAgreementParamSpec(sm2ePossession.popEncPrivateKey, sm2ePossession.popEncPublicKey, (ECPublicKey)tlcpCredentials.popEncPublicKey, true, 48);
            SSLKeyDerivation masterKD = ke.createKeyDerivation(shc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", params);
            shc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(shc.negotiatedProtocol);
            if (kd == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)shc.negotiatedProtocol));
            }
            shc.handshakeKeyDerivation = kd.createKeyDerivation(shc, masterSecret);
        }
    }

    private static final class SM2EClientKeyExchangeProducer
    implements HandshakeProducer {
        private SM2EClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            SSLKeyExchange ke;
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            SM2EKeyExchange.SM2ECredentials sm2eCredentials = null;
            for (Object cd : chc.handshakeCredentials) {
                if (!(cd instanceof SM2EKeyExchange.SM2ECredentials)) continue;
                sm2eCredentials = (SM2EKeyExchange.SM2ECredentials)cd;
                break;
            }
            if (sm2eCredentials == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "No SM2E credentials negotiated for client key exchange");
            }
            TLCPAuthentication.TLCPPossession tlcpPossession = null;
            for (SSLPossession possession : chc.handshakePossessions) {
                if (!(possession instanceof TLCPAuthentication.TLCPPossession)) continue;
                tlcpPossession = (TLCPAuthentication.TLCPPossession)possession;
                break;
            }
            SM2EKeyExchange.SM2EPossession sm2ePossession = new SM2EKeyExchange.SM2EPossession(tlcpPossession, sm2eCredentials.namedGroup, chc.sslContext.getSecureRandom());
            chc.handshakePossessions.add(sm2ePossession);
            SM2EClientKeyExchangeMessage cke = new SM2EClientKeyExchangeMessage((HandshakeContext)chc, sm2ePossession.encode());
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced SM2E ClientKeyExchange handshake message", cke);
            }
            cke.write(chc.handshakeOutput);
            chc.handshakeOutput.flush();
            TLCPAuthentication.TLCPCredentials tlcpCredentials = null;
            for (SSLCredentials sslCredentials : chc.handshakeCredentials) {
                if (!(sslCredentials instanceof TLCPAuthentication.TLCPCredentials)) continue;
                tlcpCredentials = (TLCPAuthentication.TLCPCredentials)sslCredentials;
                break;
            }
            if ((ke = SSLKeyExchange.valueOf(chc.negotiatedCipherSuite.keyExchange, chc.negotiatedProtocol)) == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SM2KeyAgreementParamSpec params = new SM2KeyAgreementParamSpec((ECPrivateKey)tlcpPossession.popEncPrivateKey, (ECPublicKey)tlcpPossession.popEncPublicKey, (ECPublicKey)tlcpCredentials.popEncPublicKey, false, 48);
            SSLKeyDerivation masterKD = ke.createKeyDerivation(chc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", params);
            chc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(chc.negotiatedProtocol);
            if (kd == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)chc.negotiatedProtocol));
            }
            chc.handshakeKeyDerivation = kd.createKeyDerivation(chc, masterSecret);
            return null;
        }
    }

    private static final class SM2EClientKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private static final byte CURVE_NAMED_CURVE = 3;
        private final byte[] encodedPoint;

        SM2EClientKeyExchangeMessage(HandshakeContext handshakeContext, byte[] encodedPublicKey) {
            super(handshakeContext);
            this.encodedPoint = encodedPublicKey;
        }

        SM2EClientKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            Record.getInt8(m);
            Record.getInt16(m);
            this.encodedPoint = m.remaining() != 0 ? Record.getBytes8(m) : new byte[0];
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            if (this.encodedPoint == null || this.encodedPoint.length == 0) {
                return 0;
            }
            return 1 + this.encodedPoint.length + 3;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            hos.putInt8(3);
            hos.putInt16(NamedGroup.CURVESM2.id);
            if (this.encodedPoint != null && this.encodedPoint.length != 0) {
                hos.putBytes8(this.encodedPoint);
            }
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"SM2 ClientKeyExchange\": '{'\n  \"SM2 public\": '{'\n{0}\n  '}',\n'}'", Locale.ENGLISH);
            if (this.encodedPoint == null || this.encodedPoint.length == 0) {
                Object[] messageFields = new Object[]{"    <implicit>"};
                return messageFormat.format(messageFields);
            }
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{Utilities.indent(hexEncoder.encodeBuffer(this.encodedPoint), "    ")};
            return messageFormat.format(messageFields);
        }
    }
}

