/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.crypto.spec.SM2KeyAgreementParamSpec;
import com.tencent.kona.ssl.SSLUtils;
import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.NamedGroup;
import com.tencent.kona.sun.security.ssl.NamedGroupCredentials;
import com.tencent.kona.sun.security.ssl.NamedGroupPossession;
import com.tencent.kona.sun.security.ssl.SM2KAKeyDerivation;
import com.tencent.kona.sun.security.ssl.SSLCredentials;
import com.tencent.kona.sun.security.ssl.SSLKeyAgreementGenerator;
import com.tencent.kona.sun.security.ssl.SSLKeyDerivation;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.SSLPossessionGenerator;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.TLCPAuthentication;
import com.tencent.kona.sun.security.util.ECUtil;
import java.io.IOException;
import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.EnumSet;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;

public class SM2EKeyExchange {
    static final SSLPossessionGenerator sm2ePoGenerator = new SM2EPossessionGenerator();
    static final SSLKeyAgreementGenerator sm2eKAGenerator = new SM2EKAGenerator();

    private static final class SM2EKAGenerator
    implements SSLKeyAgreementGenerator {
        private SM2EKAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext context) throws IOException {
            SM2EPossession sm2ePossession = null;
            SM2ECredentials sm2eCredentials = null;
            for (SSLPossession poss : context.handshakePossessions) {
                if (!(poss instanceof SM2EPossession)) continue;
                NamedGroup ng = ((SM2EPossession)poss).namedGroup;
                for (SSLCredentials cred : context.handshakeCredentials) {
                    if (!(cred instanceof SM2ECredentials) || !ng.equals((Object)((SM2ECredentials)cred).namedGroup)) continue;
                    sm2eCredentials = (SM2ECredentials)cred;
                    break;
                }
                if (sm2eCredentials == null) continue;
                sm2ePossession = (SM2EPossession)poss;
                break;
            }
            if (sm2ePossession == null || sm2eCredentials == null) {
                throw context.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient SM2 key agreement parameters negotiated");
            }
            return new SM2KAKeyDerivation("SM2", context, sm2ePossession.ephemeralPrivateKey, sm2eCredentials.ephemeralPublicKey);
        }
    }

    private static final class SM2EPossessionGenerator
    implements SSLPossessionGenerator {
        private SM2EPossessionGenerator() {
        }

        @Override
        public SSLPossession createPossession(HandshakeContext context) {
            NamedGroup preferableNamedGroup = context.clientRequestedNamedGroups != null && !context.clientRequestedNamedGroups.isEmpty() ? NamedGroup.getPreferredGroup(context.sslConfig, context.negotiatedProtocol, context.algorithmConstraints, new NamedGroup.NamedGroupSpec[]{NamedGroup.NamedGroupSpec.NAMED_GROUP_ECDHE}, context.clientRequestedNamedGroups) : NamedGroup.getPreferredGroup(context.sslConfig, context.negotiatedProtocol, context.algorithmConstraints, new NamedGroup.NamedGroupSpec[]{NamedGroup.NamedGroupSpec.NAMED_GROUP_ECDHE});
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            TLCPAuthentication.TLCPPossession tlcpPossession = null;
            if (shc.interimAuthn instanceof TLCPAuthentication.TLCPPossession) {
                tlcpPossession = (TLCPAuthentication.TLCPPossession)shc.interimAuthn;
            }
            if (preferableNamedGroup == NamedGroup.CURVESM2) {
                return new SM2EPossession(tlcpPossession, preferableNamedGroup, context.sslContext.getSecureRandom());
            }
            return null;
        }
    }

    static final class SM2EPossession
    implements NamedGroupPossession {
        final ECPrivateKey ephemeralPrivateKey;
        final ECPublicKey ephemeralPublicKey;
        final ECPrivateKey popEncPrivateKey;
        final ECPublicKey popEncPublicKey;
        final NamedGroup namedGroup;

        SM2EPossession(TLCPAuthentication.TLCPPossession tlcpPossession, NamedGroup namedGroup, SecureRandom random) {
            try {
                KeyPairGenerator kpg = SSLUtils.getECKeyPairGenerator(namedGroup.name);
                kpg.initialize(namedGroup.keAlgParamSpec, null);
                KeyPair kp = kpg.generateKeyPair();
                this.ephemeralPrivateKey = (ECPrivateKey)kp.getPrivate();
                this.ephemeralPublicKey = (ECPublicKey)kp.getPublic();
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Could not generate SM2 keypair", e);
            }
            this.popEncPrivateKey = (ECPrivateKey)tlcpPossession.popEncPrivateKey;
            this.popEncPublicKey = (ECPublicKey)tlcpPossession.popEncPublicKey;
            this.namedGroup = namedGroup;
        }

        @Override
        public byte[] encode() {
            byte[] encodedPoint = ECUtil.encodePoint(this.ephemeralPublicKey.getW(), this.ephemeralPublicKey.getParams().getCurve());
            return encodedPoint;
        }

        SecretKey getAgreedSecret(ECPublicKey peerEphemeralPublicKey, boolean isInitiator) throws SSLHandshakeException {
            try {
                SM2KeyAgreementParamSpec params = new SM2KeyAgreementParamSpec(this.popEncPrivateKey, this.popEncPublicKey, peerEphemeralPublicKey, isInitiator, 32);
                KeyAgreement ka = CryptoInsts.getKeyAgreement("SM2");
                ka.init((Key)this.ephemeralPrivateKey, params);
                ka.doPhase(peerEphemeralPublicKey, true);
                return ka.generateSecret("TlsPremasterSecret");
            }
            catch (GeneralSecurityException e) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(e);
            }
        }

        SecretKey getAgreedSecret(byte[] peerEphemeralEncodedPoint, boolean initiator) throws SSLHandshakeException {
            try {
                ECParameterSpec params = this.ephemeralPublicKey.getParams();
                ECPoint point = ECUtil.decodePoint(peerEphemeralEncodedPoint, params.getCurve());
                KeyFactory kf = CryptoInsts.getKeyFactory("SM2");
                ECPublicKeySpec spec = new ECPublicKeySpec(point, params);
                ECPublicKey peerPublicKey = (ECPublicKey)kf.generatePublic(spec);
                return this.getAgreedSecret(peerPublicKey, initiator);
            }
            catch (IOException | GeneralSecurityException e) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(e);
            }
        }

        void checkConstraints(AlgorithmConstraints constraints, byte[] encodedPoint) throws SSLHandshakeException {
            try {
                ECParameterSpec params = this.ephemeralPublicKey.getParams();
                ECPoint point = ECUtil.decodePoint(encodedPoint, params.getCurve());
                ECPublicKeySpec spec = new ECPublicKeySpec(point, params);
                KeyFactory kf = CryptoInsts.getKeyFactory("SM2");
                ECPublicKey pubKey = (ECPublicKey)kf.generatePublic(spec);
                if (!constraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), pubKey)) {
                    throw new SSLHandshakeException("ECPublicKey does not comply to algorithm constraints");
                }
            }
            catch (IOException | GeneralSecurityException e) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate ECPublicKey").initCause(e);
            }
        }

        @Override
        public PublicKey getPublicKey() {
            return this.ephemeralPublicKey;
        }

        @Override
        public NamedGroup getNamedGroup() {
            return this.namedGroup;
        }

        @Override
        public PrivateKey getPrivateKey() {
            return this.ephemeralPrivateKey;
        }
    }

    static final class SM2ECredentials
    implements NamedGroupCredentials {
        final ECPublicKey ephemeralPublicKey;
        final NamedGroup namedGroup;

        SM2ECredentials(ECPublicKey ephemeralPublicKey, NamedGroup namedGroup) {
            this.ephemeralPublicKey = ephemeralPublicKey;
            this.namedGroup = namedGroup;
        }

        @Override
        public PublicKey getPublicKey() {
            return this.ephemeralPublicKey;
        }

        @Override
        public NamedGroup getNamedGroup() {
            return this.namedGroup;
        }

        static SM2ECredentials valueOf(NamedGroup namedGroup, byte[] encodedPoint) throws IOException, GeneralSecurityException {
            if (namedGroup != NamedGroup.CURVESM2) {
                throw new RuntimeException("Credentials decoding: Not named group curveSM2");
            }
            if (encodedPoint == null || encodedPoint.length == 0) {
                return null;
            }
            ECParameterSpec parameters = (ECParameterSpec)namedGroup.keAlgParamSpec;
            ECPoint point = ECUtil.decodePoint(encodedPoint, parameters.getCurve());
            KeyFactory factory = CryptoInsts.getKeyFactory("SM2");
            ECPublicKey publicKey = (ECPublicKey)factory.generatePublic(new ECPublicKeySpec(point, parameters));
            return new SM2ECredentials(publicKey, namedGroup);
        }
    }
}

