/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.spec.SM2PublicKeySpec;
import com.tencent.kona.crypto.spec.SM2SignatureParameterSpec;
import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeOutStream;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.NamedGroup;
import com.tencent.kona.sun.security.ssl.NamedGroupCredentials;
import com.tencent.kona.sun.security.ssl.Record;
import com.tencent.kona.sun.security.ssl.SM2EKeyExchange;
import com.tencent.kona.sun.security.ssl.SSLConsumer;
import com.tencent.kona.sun.security.ssl.SSLCredentials;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.SignatureScheme;
import com.tencent.kona.sun.security.ssl.TLCPAuthentication;
import com.tencent.kona.sun.security.ssl.Utilities;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Locale;

public class SM2EServerKeyExchange {
    static final SSLConsumer sm2eHandshakeConsumer = new SM2EServerKeyExchangeConsumer();
    static final HandshakeProducer sm2eHandshakeProducer = new SM2EServerKeyExchangeProducer();

    private static final class SM2EServerKeyExchangeConsumer
    implements SSLConsumer {
        private SM2EServerKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            SM2EServerKeyExchangeMessage skem = new SM2EServerKeyExchangeMessage(chc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming SM2 ServerKeyExchange handshake message", skem);
            }
            chc.handshakeCredentials.add(skem.sslCredentials);
        }
    }

    private static final class SM2EServerKeyExchangeProducer
    implements HandshakeProducer {
        private SM2EServerKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            SM2EServerKeyExchangeMessage skem = new SM2EServerKeyExchangeMessage(shc);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced SM2 ServerKeyExchange handshake message", skem);
            }
            skem.write(shc.handshakeOutput);
            shc.handshakeOutput.flush();
            return null;
        }
    }

    private static final class SM2EServerKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private static final byte CURVE_NAMED_CURVE = 3;
        private final NamedGroup namedGroup;
        private final byte[] publicPoint;
        private final byte[] paramsSignature;
        private SSLCredentials sslCredentials;

        SM2EServerKeyExchangeMessage(HandshakeContext handshakeContext) throws IOException {
            super(handshakeContext);
            byte[] signature;
            Signature signer;
            ServerHandshakeContext shc = (ServerHandshakeContext)handshakeContext;
            SM2EKeyExchange.SM2EPossession sm2ePossession = null;
            TLCPAuthentication.TLCPPossession tlcpPossession = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (possession instanceof SM2EKeyExchange.SM2EPossession) {
                    sm2ePossession = (SM2EKeyExchange.SM2EPossession)possession;
                    if (tlcpPossession == null) continue;
                    break;
                }
                if (!(possession instanceof TLCPAuthentication.TLCPPossession)) continue;
                tlcpPossession = (TLCPAuthentication.TLCPPossession)possession;
                if (sm2ePossession == null) continue;
                break;
            }
            if (sm2ePossession == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No SM2 credentials negotiated for server key exchange");
            }
            ECParameterSpec params = sm2ePossession.popEncPublicKey.getParams();
            NamedGroup namedGroup = this.namedGroup = params != null ? NamedGroup.valueOf(params) : null;
            if (this.namedGroup == null || !this.namedGroup.isAvailable || this.namedGroup != NamedGroup.CURVESM2) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Missing or improper named group: " + (Object)((Object)this.namedGroup));
            }
            ECPoint ecPoint = sm2ePossession.popEncPublicKey.getW();
            if (ecPoint == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Missing public point for named group: " + (Object)((Object)this.namedGroup));
            }
            this.publicPoint = CryptoUtils.pubKey(sm2ePossession.ephemeralPublicKey.getW());
            try {
                signer = CryptoInsts.getSignature(SignatureScheme.SM2SIG_SM3.algorithm);
                signer.setParameter(new SM2SignatureParameterSpec((ECPublicKey)tlcpPossession.popSignPublicKey));
                signer.initSign(tlcpPossession.popSignPrivateKey);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException e) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + sm2ePossession.popEncPrivateKey.getAlgorithm(), e);
            }
            try {
                SM2EServerKeyExchangeMessage.updateSignature(signer, shc.clientHelloRandom.randomBytes, shc.serverHelloRandom.randomBytes, this.namedGroup.id, this.publicPoint);
                signature = signer.sign();
            }
            catch (SignatureException ex) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Failed to sign ecdhe parameters: " + sm2ePossession.popEncPrivateKey.getAlgorithm(), ex);
            }
            this.paramsSignature = signature;
        }

        SM2EServerKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            Signature signer;
            ClientHandshakeContext chc = (ClientHandshakeContext)handshakeContext;
            byte curveType = (byte)Record.getInt8(m);
            if (curveType != 3) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported ECCurveType: " + curveType);
            }
            int namedGroupId = Record.getInt16(m);
            this.namedGroup = NamedGroup.valueOf(namedGroupId);
            if (this.namedGroup == null) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unknown named group ID: " + namedGroupId);
            }
            if (!NamedGroup.isEnabled(chc.sslConfig, this.namedGroup)) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported named group: " + (Object)((Object)this.namedGroup));
            }
            this.publicPoint = Record.getBytes8(m);
            if (this.publicPoint.length == 0) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Insufficient Point data: " + (Object)((Object)this.namedGroup));
            }
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("SM2");
                ECPublicKey ecPublicKey = (ECPublicKey)keyFactory.generatePublic(new SM2PublicKeySpec(this.publicPoint));
                this.sslCredentials = new SM2EKeyExchange.SM2ECredentials(ecPublicKey, this.namedGroup);
                if (handshakeContext.algorithmConstraints != null && this.sslCredentials instanceof NamedGroupCredentials) {
                    NamedGroupCredentials namedGroupCredentials = (NamedGroupCredentials)this.sslCredentials;
                    if (!handshakeContext.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroupCredentials.getPublicKey())) {
                        chc.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "ServerKeyExchange for " + (Object)((Object)this.namedGroup) + " does not comply with algorithm constraints");
                    }
                }
            }
            catch (GeneralSecurityException ex) {
                throw chc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Cannot decode named group: " + NamedGroup.nameOf(namedGroupId));
            }
            TLCPAuthentication.TLCPCredentials tlcpCredentials = null;
            for (SSLCredentials cd : chc.handshakeCredentials) {
                if (!(cd instanceof TLCPAuthentication.TLCPCredentials)) continue;
                tlcpCredentials = (TLCPAuthentication.TLCPCredentials)cd;
                break;
            }
            if (tlcpCredentials == null) {
                if (m.hasRemaining()) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid DH ServerKeyExchange: unknown extra data");
                }
                this.paramsSignature = null;
                return;
            }
            this.paramsSignature = Record.getBytes16(m);
            try {
                signer = CryptoInsts.getSignature(SignatureScheme.SM2SIG_SM3.algorithm);
                signer.setParameter(new SM2SignatureParameterSpec((ECPublicKey)tlcpCredentials.popSignPublicKey));
                signer.initVerify(tlcpCredentials.popSignPublicKey);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException e) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + tlcpCredentials.popSignPublicKey.getAlgorithm(), e);
            }
            try {
                SM2EServerKeyExchangeMessage.updateSignature(signer, chc.clientHelloRandom.randomBytes, chc.serverHelloRandom.randomBytes, this.namedGroup.id, this.publicPoint);
                if (!signer.verify(this.paramsSignature)) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid SM2 ServerKeyExchange signature");
                }
            }
            catch (SignatureException ex) {
                throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify SM2 ServerKeyExchange signature", ex);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.SERVER_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            int sigLen = 0;
            if (this.paramsSignature != null) {
                sigLen = 2 + this.paramsSignature.length;
            }
            return 4 + this.publicPoint.length + sigLen;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            hos.putInt8(3);
            hos.putInt16(this.namedGroup.id);
            hos.putBytes8(this.publicPoint);
            if (this.paramsSignature != null) {
                hos.putBytes16(this.paramsSignature);
            }
        }

        public String toString() {
            if (this.paramsSignature != null) {
                MessageFormat messageFormat = new MessageFormat("\"SM2 ServerKeyExchange\": '{'\n  \"parameters\":  '{'\n    \"named group\": \"{0}\"\n    \"ecdh public\": '{'\n{1}\n    '}',\n  '}',\n  \"signature\": '{'\n{2}\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexEncoder = new HexDumpEncoder();
                Object[] messageFields = new Object[]{this.namedGroup.name, Utilities.indent(hexEncoder.encodeBuffer(this.publicPoint), "      "), Utilities.indent(hexEncoder.encodeBuffer(this.paramsSignature), "    ")};
                return messageFormat.format(messageFields);
            }
            MessageFormat messageFormat = new MessageFormat("\"SM2 ServerKeyExchange\": '{'\n  \"parameters\":  '{'\n    \"named group\": \"{0}\"\n    \"ecdh public\": '{'\n{1}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{this.namedGroup.name, Utilities.indent(hexEncoder.encodeBuffer(this.publicPoint), "      ")};
            return messageFormat.format(messageFields);
        }

        private static void updateSignature(Signature sig, byte[] clntNonce, byte[] svrNonce, int namedGroupId, byte[] publicPoint) throws SignatureException {
            sig.update(clntNonce);
            sig.update(svrNonce);
            sig.update((byte)3);
            sig.update((byte)(namedGroupId >> 8 & 0xFF));
            sig.update((byte)(namedGroupId & 0xFF));
            sig.update((byte)publicPoint.length);
            sig.update(publicPoint);
        }
    }
}

