/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.SSLKeyDerivation;
import com.tencent.kona.sun.security.ssl.SSLMasterKeyDerivation;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;

final class SM2KAKeyDerivation
implements SSLKeyDerivation {
    private final String algorithmName;
    private final HandshakeContext context;
    private final ECPrivateKey localEphemeralPrivateKey;
    private final ECPublicKey peerEphemeralPublicKey;

    SM2KAKeyDerivation(String algorithmName, HandshakeContext context, ECPrivateKey localEphemeralPrivateKey, ECPublicKey peerEphemeralPublicKey) {
        this.algorithmName = algorithmName;
        this.context = context;
        this.localEphemeralPrivateKey = localEphemeralPrivateKey;
        this.peerEphemeralPublicKey = peerEphemeralPublicKey;
    }

    @Override
    public SecretKey deriveKey(String algorithm, AlgorithmParameterSpec params) throws IOException {
        try {
            KeyAgreement ka = CryptoInsts.getKeyAgreement(this.algorithmName);
            ka.init(this.localEphemeralPrivateKey, params, null);
            ka.doPhase(this.peerEphemeralPublicKey, true);
            SecretKey preMasterSecret = ka.generateSecret("TlsPremasterSecret");
            SSLMasterKeyDerivation mskd = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
            if (mskd == null) {
                throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
            }
            SSLKeyDerivation kd = mskd.createKeyDerivation(this.context, preMasterSecret);
            return kd.deriveKey("MasterSecret", params);
        }
        catch (GeneralSecurityException gse) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(gse);
        }
    }
}

