/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.crypto.spec.SM2SignatureParameterSpec;
import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeOutStream;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.Record;
import com.tencent.kona.sun.security.ssl.SSLConsumer;
import com.tencent.kona.sun.security.ssl.SSLCredentials;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.SignatureScheme;
import com.tencent.kona.sun.security.ssl.TLCPAuthentication;
import com.tencent.kona.sun.security.ssl.Utilities;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.text.MessageFormat;
import java.util.Locale;

final class SM2ServerKeyExchange {
    static final SSLConsumer sm2HandshakeConsumer = new SM2ServerKeyExchangeConsumer();
    static final HandshakeProducer sm2HandshakeProducer = new SM2ServerKeyExchangeProducer();

    SM2ServerKeyExchange() {
    }

    private static final class SM2ServerKeyExchangeConsumer
    implements SSLConsumer {
        private SM2ServerKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            SM2ServerKeyExchangeMessage skem = new SM2ServerKeyExchangeMessage(chc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming SM2 ServerKeyExchange handshake message", skem);
            }
        }
    }

    private static final class SM2ServerKeyExchangeProducer
    implements HandshakeProducer {
        private SM2ServerKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            SM2ServerKeyExchangeMessage skem = new SM2ServerKeyExchangeMessage(shc);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced SM2 ServerKeyExchange handshake message", skem);
            }
            skem.write(shc.handshakeOutput);
            shc.handshakeOutput.flush();
            return null;
        }
    }

    private static final class SM2ServerKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] paramsSignature;
        private final boolean useExplicitSigAlgorithm;
        private final SignatureScheme signatureScheme;

        SM2ServerKeyExchangeMessage(HandshakeContext handshakeContext) throws IOException {
            super(handshakeContext);
            byte[] signature;
            ServerHandshakeContext shc = (ServerHandshakeContext)handshakeContext;
            TLCPAuthentication.TLCPPossession tlcpPossession = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (!(possession instanceof TLCPAuthentication.TLCPPossession)) continue;
                tlcpPossession = (TLCPAuthentication.TLCPPossession)possession;
                break;
            }
            if (tlcpPossession == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No SM2 credentials negotiated for server key exchange");
            }
            this.useExplicitSigAlgorithm = shc.negotiatedProtocol.useTLS12PlusSpec();
            if (this.useExplicitSigAlgorithm) {
                if (shc.peerRequestedSignatureSchemes == null || !shc.peerRequestedSignatureSchemes.contains((Object)SignatureScheme.SM2SIG_SM3)) {
                    throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "No supported signature algorithm for " + tlcpPossession.popSignPrivateKey.getAlgorithm() + " key");
                }
                this.signatureScheme = SignatureScheme.SM2SIG_SM3;
            } else {
                this.signatureScheme = null;
            }
            try {
                Signature signer = CryptoInsts.getSignature(SignatureScheme.SM2SIG_SM3.algorithm);
                signer.setParameter(new SM2SignatureParameterSpec((ECPublicKey)tlcpPossession.popSignPublicKey));
                signer.initSign(tlcpPossession.popSignPrivateKey);
                SM2ServerKeyExchangeMessage.updateSignature(signer, shc.clientHelloRandom.randomBytes, shc.serverHelloRandom.randomBytes, tlcpPossession.popEncCert);
                signature = signer.sign();
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateEncodingException ex) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Failed to sign SM2 parameters: " + tlcpPossession.popSignPrivateKey.getAlgorithm(), ex);
            }
            this.paramsSignature = signature;
        }

        SM2ServerKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            ClientHandshakeContext chc = (ClientHandshakeContext)handshakeContext;
            TLCPAuthentication.TLCPCredentials tlcpCredentials = null;
            for (SSLCredentials cd : chc.handshakeCredentials) {
                if (!(cd instanceof TLCPAuthentication.TLCPCredentials)) continue;
                tlcpCredentials = (TLCPAuthentication.TLCPCredentials)cd;
                break;
            }
            if (tlcpCredentials == null) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No SM2 credentials negotiated for server key exchange");
            }
            this.useExplicitSigAlgorithm = chc.negotiatedProtocol.useTLS12PlusSpec();
            if (this.useExplicitSigAlgorithm) {
                int ssid = Record.getInt16(m);
                this.signatureScheme = SignatureScheme.valueOf(ssid);
                if (this.signatureScheme == null) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature algorithm (" + ssid + ") used in SM2 ServerKeyExchange handshake message");
                }
                if (!chc.localSupportedSignAlgs.contains((Object)this.signatureScheme)) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsupported signature algorithm (" + this.signatureScheme.name + ") used in SM2 ServerKeyExchange handshake message");
                }
            } else {
                this.signatureScheme = null;
            }
            this.paramsSignature = Record.getBytes16(m);
            try {
                Signature signer = CryptoInsts.getSignature(SignatureScheme.SM2SIG_SM3.algorithm);
                signer.setParameter(new SM2SignatureParameterSpec((ECPublicKey)tlcpCredentials.popSignCert.getPublicKey()));
                signer.initVerify(tlcpCredentials.popSignPublicKey);
                SM2ServerKeyExchangeMessage.updateSignature(signer, chc.clientHelloRandom.randomBytes, chc.serverHelloRandom.randomBytes, tlcpCredentials.popEncCert);
                if (!signer.verify(this.paramsSignature)) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid SM2 ServerKeyExchange signature");
                }
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateEncodingException ex) {
                throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify SM2 ServerKeyExchange signature", ex);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.SERVER_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            int sigLen = 2 + this.paramsSignature.length;
            if (this.useExplicitSigAlgorithm) {
                sigLen += SignatureScheme.sizeInRecord();
            }
            return sigLen;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            if (this.useExplicitSigAlgorithm) {
                hos.putInt16(this.signatureScheme.id);
            }
            hos.putBytes16(this.paramsSignature);
        }

        public String toString() {
            if (this.useExplicitSigAlgorithm) {
                MessageFormat messageFormat = new MessageFormat("\"SM2E ServerKeyExchange\": '{'\n  \"digital signature\":  '{'\n    \"signature algorithm\": \"{0}\"\n    \"signature\": '{'\n{1}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexEncoder = new HexDumpEncoder();
                Object[] messageFields = new Object[]{this.signatureScheme.name, Utilities.indent(hexEncoder.encodeBuffer(this.paramsSignature), "      ")};
                return messageFormat.format(messageFields);
            }
            MessageFormat messageFormat = new MessageFormat("\"SM2 ServerKeyExchange\": '{'\n  \"digital signature\":  '{'\n    \"signature\": '{'\n{0}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{Utilities.indent(hexEncoder.encodeBuffer(this.paramsSignature), "      ")};
            return messageFormat.format(messageFields);
        }

        private static void updateSignature(Signature sig, byte[] clntNonce, byte[] svrNonce, X509Certificate encCert) throws SignatureException, CertificateEncodingException {
            sig.update(clntNonce);
            sig.update(svrNonce);
            byte[] encodedEncCert = encCert.getEncoded();
            int certLength = encodedEncCert.length;
            sig.update((byte)(certLength >> 16 & 0xFF));
            sig.update((byte)(certLength >> 8 & 0xFF));
            sig.update((byte)(certLength & 0xFF));
            sig.update(encodedEncCert);
        }
    }
}

