/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.CipherSuite;
import com.tencent.kona.sun.security.ssl.Ciphertext;
import com.tencent.kona.sun.security.ssl.ClientAuthType;
import com.tencent.kona.sun.security.ssl.ContentType;
import com.tencent.kona.sun.security.ssl.DTLSInputRecord;
import com.tencent.kona.sun.security.ssl.DTLSOutputRecord;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeHash;
import com.tencent.kona.sun.security.ssl.NewSessionTicket;
import com.tencent.kona.sun.security.ssl.Plaintext;
import com.tencent.kona.sun.security.ssl.PostHandshakeContext;
import com.tencent.kona.sun.security.ssl.ProtocolVersion;
import com.tencent.kona.sun.security.ssl.SSLContextImpl;
import com.tencent.kona.sun.security.ssl.SSLEngineInputRecord;
import com.tencent.kona.sun.security.ssl.SSLEngineOutputRecord;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLSessionImpl;
import com.tencent.kona.sun.security.ssl.SSLTransport;
import com.tencent.kona.sun.security.ssl.TransportContext;
import com.tencent.kona.sun.security.ssl.Utilities;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;

final class SSLEngineImpl
extends SSLEngine
implements SSLTransport {
    private final SSLContextImpl sslContext;
    final TransportContext conContext;
    private final ReentrantLock engineLock = new ReentrantLock();

    SSLEngineImpl(SSLContextImpl sslContext) {
        this(sslContext, null, -1);
    }

    SSLEngineImpl(SSLContextImpl sslContext, String host, int port) {
        super(host, port);
        this.sslContext = sslContext;
        HandshakeHash handshakeHash = new HandshakeHash();
        this.conContext = sslContext.isDTLS() ? new TransportContext(sslContext, this, new DTLSInputRecord(handshakeHash), new DTLSOutputRecord(handshakeHash)) : new TransportContext(sslContext, this, new SSLEngineInputRecord(handshakeHash), new SSLEngineOutputRecord(handshakeHash));
        if (host != null) {
            this.conContext.sslConfig.serverNames = Utilities.addToSNIServerNameList(this.conContext.sslConfig.serverNames, host);
        }
    }

    @Override
    public void beginHandshake() throws SSLException {
        this.engineLock.lock();
        try {
            if (this.conContext.isUnsureMode) {
                throw new IllegalStateException("Client/Server mode has not yet been set.");
            }
            try {
                this.conContext.kickstart();
            }
            catch (IOException ioe) {
                throw this.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Couldn't kickstart handshaking", ioe);
            }
            catch (Exception ex) {
                throw this.conContext.fatal(Alert.INTERNAL_ERROR, "Fail to begin handshake", ex);
            }
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] appData, int offset, int length, ByteBuffer netData) throws SSLException {
        return this.wrap(appData, offset, length, new ByteBuffer[]{netData}, 0, 1);
    }

    /*
     * Exception decompiling
     */
    public SSLEngineResult wrap(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws SSLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SSLEngineResult writeRecord(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws IOException {
        SSLEngineResult.Status status;
        if (this.conContext.needHandshakeFinishedStatus) {
            this.conContext.needHandshakeFinishedStatus = false;
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.FINISHED, 0, 0);
        }
        if (this.isOutboundDone()) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.conContext.getHandshakeStatus(), 0, 0);
        }
        HandshakeContext hc = this.conContext.handshakeContext;
        SSLEngineResult.HandshakeStatus hsStatus = null;
        if (!(this.conContext.isNegotiated || this.conContext.isBroken || this.conContext.isInboundClosed() || this.conContext.isOutboundClosed())) {
            this.conContext.kickstart();
            hsStatus = this.conContext.getHandshakeStatus();
            if (!(hsStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || this.sslContext.isDTLS() && hc != null && hc.sslConfig.enableRetransmissions && !this.conContext.outputRecord.firstMessage)) {
                return new SSLEngineResult(SSLEngineResult.Status.OK, hsStatus, 0, 0);
            }
        }
        if (hsStatus == null) {
            hsStatus = this.conContext.getHandshakeStatus();
        }
        if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, hsStatus, 0, 0);
        }
        int dstsRemains = 0;
        for (int i = dstsOffset; i < dstsOffset + dstsLength; ++i) {
            dstsRemains += dsts[i].remaining();
        }
        if (dstsRemains < this.conContext.conSession.getPacketBufferSize()) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.conContext.getHandshakeStatus(), 0, 0);
        }
        int srcsRemains = 0;
        for (int i = srcsOffset; i < srcsOffset + srcsLength; ++i) {
            srcsRemains += srcs[i].remaining();
        }
        Ciphertext ciphertext = null;
        try {
            if (!this.conContext.outputRecord.isEmpty() || hc != null && hc.sslConfig.enableRetransmissions && hc.sslContext.isDTLS() && hsStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                ciphertext = this.encode(null, 0, 0, dsts, dstsOffset, dstsLength);
            }
            if (ciphertext == null && srcsRemains != 0) {
                ciphertext = this.encode(srcs, srcsOffset, srcsLength, dsts, dstsOffset, dstsLength);
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof SSLException) {
                throw ioe;
            }
            throw new SSLException("Write problems", ioe);
        }
        SSLEngineResult.Status status2 = status = this.isOutboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
        if (ciphertext != null && ciphertext.handshakeStatus != null) {
            hsStatus = ciphertext.handshakeStatus;
        } else {
            hsStatus = this.conContext.getHandshakeStatus();
            if (ciphertext == null && !this.conContext.isNegotiated && this.conContext.isInboundClosed() && hsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                status = SSLEngineResult.Status.CLOSED;
            }
        }
        int deltaSrcs = srcsRemains;
        for (int i = srcsOffset; i < srcsOffset + srcsLength; ++i) {
            deltaSrcs -= srcs[i].remaining();
        }
        int deltaDsts = dstsRemains;
        for (int i = dstsOffset; i < dstsOffset + dstsLength; ++i) {
            deltaDsts -= dsts[i].remaining();
        }
        return new SSLEngineResult(status, hsStatus, deltaSrcs, deltaDsts);
    }

    private Ciphertext encode(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws IOException {
        Ciphertext ciphertext;
        try {
            ciphertext = this.conContext.outputRecord.encode(srcs, srcsOffset, srcsLength, dsts, dstsOffset, dstsLength);
        }
        catch (SSLHandshakeException she) {
            throw this.conContext.fatal(Alert.HANDSHAKE_FAILURE, she);
        }
        catch (IOException e) {
            throw this.conContext.fatal(Alert.UNEXPECTED_MESSAGE, e);
        }
        if (ciphertext == null) {
            return null;
        }
        boolean needRetransmission = this.conContext.sslContext.isDTLS() && this.conContext.handshakeContext != null && this.conContext.handshakeContext.sslConfig.enableRetransmissions;
        SSLEngineResult.HandshakeStatus hsStatus = this.tryToFinishHandshake(ciphertext.contentType);
        if (needRetransmission && hsStatus == SSLEngineResult.HandshakeStatus.FINISHED && this.conContext.sslContext.isDTLS() && ciphertext.handshakeType == SSLHandshake.FINISHED.id) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,verbose")) {
                SSLLogger.finest("retransmit the last flight messages", new Object[0]);
            }
            this.conContext.outputRecord.launchRetransmission();
            hsStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        if (hsStatus == null) {
            hsStatus = this.conContext.getHandshakeStatus();
        }
        if (this.conContext.outputRecord.seqNumIsHuge() || this.conContext.outputRecord.writeCipher.atKeyLimit()) {
            hsStatus = this.tryKeyUpdate(hsStatus);
        }
        if (this.conContext.conSession.updateNST && !this.conContext.sslConfig.isClientMode) {
            hsStatus = this.tryNewSessionTicket(hsStatus);
        }
        ciphertext.handshakeStatus = hsStatus;
        return ciphertext;
    }

    private SSLEngineResult.HandshakeStatus tryToFinishHandshake(byte contentType) {
        SSLEngineResult.HandshakeStatus hsStatus = null;
        if (contentType == ContentType.HANDSHAKE.id && this.conContext.outputRecord.isEmpty()) {
            if (this.conContext.handshakeContext == null) {
                hsStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.conContext.isPostHandshakeContext()) {
                hsStatus = this.conContext.finishPostHandshake();
            } else if (this.conContext.handshakeContext.handshakeFinished) {
                hsStatus = this.conContext.finishHandshake();
            }
        }
        return hsStatus;
    }

    private SSLEngineResult.HandshakeStatus tryKeyUpdate(SSLEngineResult.HandshakeStatus currentHandshakeStatus) throws IOException {
        if (this.conContext.handshakeContext == null && !this.conContext.isOutboundClosed() && !this.conContext.isBroken) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest("trigger key update", new Object[0]);
            }
            this.beginHandshake();
            return this.conContext.getHandshakeStatus();
        }
        return currentHandshakeStatus;
    }

    private SSLEngineResult.HandshakeStatus tryNewSessionTicket(SSLEngineResult.HandshakeStatus currentHandshakeStatus) throws IOException {
        if (this.conContext.handshakeContext == null && this.conContext.protocolVersion.useTLS13PlusSpec() && !this.conContext.isOutboundClosed() && !this.conContext.isInboundClosed() && !this.conContext.isBroken) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest("trigger NST", new Object[0]);
            }
            this.conContext.conSession.updateNST = false;
            NewSessionTicket.t13PosthandshakeProducer.produce(new PostHandshakeContext(this.conContext));
            return this.conContext.getHandshakeStatus();
        }
        return currentHandshakeStatus;
    }

    private static void checkParams(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) {
        int i;
        if (srcs == null || dsts == null) {
            throw new IllegalArgumentException("source or destination buffer is null");
        }
        if (dstsOffset < 0 || dstsLength < 0 || dstsOffset > dsts.length - dstsLength) {
            throw new IndexOutOfBoundsException("index out of bound of the destination buffers");
        }
        if (srcsOffset < 0 || srcsLength < 0 || srcsOffset > srcs.length - srcsLength) {
            throw new IndexOutOfBoundsException("index out of bound of the source buffers");
        }
        for (i = dstsOffset; i < dstsOffset + dstsLength; ++i) {
            if (dsts[i] == null) {
                throw new IllegalArgumentException("destination buffer[" + i + "] == null");
            }
            if (!dsts[i].isReadOnly()) continue;
            throw new ReadOnlyBufferException();
        }
        for (i = srcsOffset; i < srcsOffset + srcsLength; ++i) {
            if (srcs[i] != null) continue;
            throw new IllegalArgumentException("source buffer[" + i + "] == null");
        }
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        return this.unwrap(new ByteBuffer[]{src}, 0, 1, dsts, offset, length);
    }

    /*
     * Exception decompiling
     */
    public SSLEngineResult unwrap(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws SSLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SSLEngineResult readRecord(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws IOException {
        Plaintext plainText;
        int FragLen;
        int packetLen;
        if (this.isInboundDone()) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.conContext.getHandshakeStatus(), 0, 0);
        }
        SSLEngineResult.HandshakeStatus hsStatus = null;
        if (!(this.conContext.isNegotiated || this.conContext.isBroken || this.conContext.isInboundClosed() || this.conContext.isOutboundClosed())) {
            this.conContext.kickstart();
            hsStatus = this.conContext.getHandshakeStatus();
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                return new SSLEngineResult(SSLEngineResult.Status.OK, hsStatus, 0, 0);
            }
        }
        if (hsStatus == null) {
            hsStatus = this.conContext.getHandshakeStatus();
        }
        if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, hsStatus, 0, 0);
        }
        int srcsRemains = 0;
        for (int i = srcsOffset; i < srcsOffset + srcsLength; ++i) {
            srcsRemains += srcs[i].remaining();
        }
        if (srcsRemains == 0) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, hsStatus, 0, 0);
        }
        try {
            packetLen = this.conContext.inputRecord.bytesInCompletePacket(srcs, srcsOffset, srcsLength);
        }
        catch (SSLException ssle) {
            if (this.sslContext.isDTLS()) {
                SSLEngineResult.Status status;
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,verbose")) {
                    SSLLogger.finest("Discard invalid DTLS records", ssle);
                }
                for (int i = srcsOffset; i < srcsOffset + srcsLength; ++i) {
                    srcs[i].position(srcs[i].limit());
                }
                SSLEngineResult.Status status2 = status = this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
                if (hsStatus == null) {
                    hsStatus = this.conContext.getHandshakeStatus();
                }
                return new SSLEngineResult(status, hsStatus, srcsRemains, 0);
            }
            throw ssle;
        }
        if (packetLen > this.conContext.conSession.getPacketBufferSize()) {
            int largestRecordSize;
            int n = largestRecordSize = this.sslContext.isDTLS() ? 16717 : 33093;
            if (packetLen <= largestRecordSize && !this.sslContext.isDTLS()) {
                this.conContext.conSession.expandBufferSizes();
            }
            if (packetLen > (largestRecordSize = this.conContext.conSession.getPacketBufferSize())) {
                throw new SSLProtocolException("Input record too big: max = " + largestRecordSize + " len = " + packetLen);
            }
        }
        int dstsRemains = 0;
        for (int i = dstsOffset; i < dstsOffset + dstsLength; ++i) {
            dstsRemains += dsts[i].remaining();
        }
        if (this.conContext.isNegotiated && (FragLen = this.conContext.inputRecord.estimateFragmentSize(packetLen)) > dstsRemains) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, hsStatus, 0, 0);
        }
        if (packetLen == -1 || srcsRemains < packetLen) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, hsStatus, 0, 0);
        }
        try {
            plainText = this.decode(srcs, srcsOffset, srcsLength, dsts, dstsOffset, dstsLength);
        }
        catch (IOException ioe) {
            if (ioe instanceof SSLException) {
                throw ioe;
            }
            throw new SSLException("readRecord", ioe);
        }
        SSLEngineResult.Status status = this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
        hsStatus = plainText.handshakeStatus != null ? plainText.handshakeStatus : this.conContext.getHandshakeStatus();
        int deltaNet = srcsRemains;
        for (int i = srcsOffset; i < srcsOffset + srcsLength; ++i) {
            deltaNet -= srcs[i].remaining();
        }
        int deltaApp = dstsRemains;
        for (int i = dstsOffset; i < dstsOffset + dstsLength; ++i) {
            deltaApp -= dsts[i].remaining();
        }
        return new SSLEngineResult(status, hsStatus, deltaNet, deltaApp);
    }

    private Plaintext decode(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws IOException {
        Plaintext pt = SSLTransport.decode(this.conContext, srcs, srcsOffset, srcsLength, dsts, dstsOffset, dstsLength);
        if (pt != Plaintext.PLAINTEXT_NULL) {
            SSLEngineResult.HandshakeStatus hsStatus = this.tryToFinishHandshake(pt.contentType);
            pt.handshakeStatus = hsStatus == null ? this.conContext.getHandshakeStatus() : hsStatus;
            if (this.conContext.inputRecord.seqNumIsHuge() || this.conContext.inputRecord.readCipher.atKeyLimit()) {
                pt.handshakeStatus = this.tryKeyUpdate(pt.handshakeStatus);
            }
        }
        return pt;
    }

    @Override
    public Runnable getDelegatedTask() {
        this.engineLock.lock();
        try {
            if (this.conContext.handshakeContext != null && !this.conContext.handshakeContext.taskDelegated && !this.conContext.handshakeContext.delegatedActions.isEmpty()) {
                this.conContext.handshakeContext.taskDelegated = true;
                DelegatedTask delegatedTask = new DelegatedTask(this);
                return delegatedTask;
            }
        }
        finally {
            this.engineLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeInbound() throws SSLException {
        this.engineLock.lock();
        try {
            if (this.isInboundDone()) {
                return;
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest("Closing inbound of SSLEngine", new Object[0]);
            }
            if (!this.conContext.isInputCloseNotified && (this.conContext.isNegotiated || this.conContext.handshakeContext != null)) {
                throw new SSLException("closing inbound before receiving peer's close_notify");
            }
        }
        finally {
            try {
                this.conContext.closeInbound();
            }
            finally {
                this.engineLock.unlock();
            }
        }
    }

    @Override
    public boolean isInboundDone() {
        this.engineLock.lock();
        try {
            boolean bl = this.conContext.isInboundClosed();
            return bl;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public void closeOutbound() {
        this.engineLock.lock();
        try {
            if (this.conContext.isOutboundClosed()) {
                return;
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest("Closing outbound of SSLEngine", new Object[0]);
            }
            this.conContext.closeOutbound();
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public boolean isOutboundDone() {
        this.engineLock.lock();
        try {
            boolean bl = this.conContext.isOutboundDone();
            return bl;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return CipherSuite.namesOf(this.sslContext.getSupportedCipherSuites());
    }

    @Override
    public String[] getEnabledCipherSuites() {
        this.engineLock.lock();
        try {
            String[] stringArray = CipherSuite.namesOf(this.conContext.sslConfig.enabledCipherSuites);
            return stringArray;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.engineLock.lock();
        try {
            this.conContext.sslConfig.enabledCipherSuites = CipherSuite.validValuesOf(suites);
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public String[] getSupportedProtocols() {
        return ProtocolVersion.toStringArray(this.sslContext.getSupportedProtocolVersions());
    }

    @Override
    public String[] getEnabledProtocols() {
        this.engineLock.lock();
        try {
            String[] stringArray = ProtocolVersion.toStringArray(this.conContext.sslConfig.enabledProtocols);
            return stringArray;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.engineLock.lock();
        try {
            if (protocols == null) {
                throw new IllegalArgumentException("Protocols cannot be null");
            }
            this.conContext.sslConfig.enabledProtocols = ProtocolVersion.namesOf(protocols);
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public SSLSession getSession() {
        this.engineLock.lock();
        try {
            SSLSessionImpl sSLSessionImpl = this.conContext.conSession;
            return sSLSessionImpl;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public SSLSession getHandshakeSession() {
        this.engineLock.lock();
        try {
            SSLSessionImpl sSLSessionImpl = this.conContext.handshakeContext == null ? null : this.conContext.handshakeContext.handshakeSession;
            return sSLSessionImpl;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        this.engineLock.lock();
        try {
            SSLEngineResult.HandshakeStatus handshakeStatus = this.conContext.getHandshakeStatus();
            return handshakeStatus;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public void setUseClientMode(boolean mode) {
        this.engineLock.lock();
        try {
            this.conContext.setUseClientMode(mode);
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public boolean getUseClientMode() {
        this.engineLock.lock();
        try {
            boolean bl = this.conContext.sslConfig.isClientMode;
            return bl;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.engineLock.lock();
        try {
            this.conContext.sslConfig.clientAuthType = need ? ClientAuthType.CLIENT_AUTH_REQUIRED : ClientAuthType.CLIENT_AUTH_NONE;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public boolean getNeedClientAuth() {
        this.engineLock.lock();
        try {
            boolean bl = this.conContext.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUIRED;
            return bl;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.engineLock.lock();
        try {
            this.conContext.sslConfig.clientAuthType = want ? ClientAuthType.CLIENT_AUTH_REQUESTED : ClientAuthType.CLIENT_AUTH_NONE;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public boolean getWantClientAuth() {
        this.engineLock.lock();
        try {
            boolean bl = this.conContext.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUESTED;
            return bl;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.engineLock.lock();
        try {
            this.conContext.sslConfig.enableSessionCreation = flag;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public boolean getEnableSessionCreation() {
        this.engineLock.lock();
        try {
            boolean bl = this.conContext.sslConfig.enableSessionCreation;
            return bl;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public SSLParameters getSSLParameters() {
        this.engineLock.lock();
        try {
            SSLParameters sSLParameters = this.conContext.sslConfig.getSSLParameters();
            return sSLParameters;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        this.engineLock.lock();
        try {
            this.conContext.sslConfig.setSSLParameters(params);
            if (this.conContext.sslConfig.maximumPacketSize != 0) {
                this.conContext.outputRecord.changePacketSize(this.conContext.sslConfig.maximumPacketSize);
            }
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public String getApplicationProtocol() {
        this.engineLock.lock();
        try {
            String string = this.conContext.applicationProtocol;
            return string;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public String getHandshakeApplicationProtocol() {
        this.engineLock.lock();
        try {
            String string = this.conContext.handshakeContext == null ? null : this.conContext.handshakeContext.applicationProtocol;
            return string;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public void setHandshakeApplicationProtocolSelector(BiFunction<SSLEngine, List<String>, String> selector) {
        this.engineLock.lock();
        try {
            this.conContext.sslConfig.engineAPSelector = selector;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector() {
        this.engineLock.lock();
        try {
            BiFunction<SSLEngine, List<String>, String> biFunction = this.conContext.sslConfig.engineAPSelector;
            return biFunction;
        }
        finally {
            this.engineLock.unlock();
        }
    }

    @Override
    public boolean useDelegatedTask() {
        return true;
    }

    public String toString() {
        return "SSLEngine[hostname=" + this.getPeerHost() + ", port=" + this.getPeerPort() + ", " + this.conContext.conSession + "]";
    }

    private void checkTaskThrown() throws SSLException {
        Exception exc = null;
        this.engineLock.lock();
        try {
            HandshakeContext hc = this.conContext.handshakeContext;
            if (hc != null && hc.delegatedThrown != null) {
                exc = hc.delegatedThrown;
                hc.delegatedThrown = null;
            }
            if (this.conContext.delegatedThrown != null) {
                if (exc != null) {
                    if (this.conContext.delegatedThrown == exc) {
                        this.conContext.delegatedThrown = null;
                    }
                } else {
                    exc = this.conContext.delegatedThrown;
                    this.conContext.delegatedThrown = null;
                }
            }
        }
        finally {
            this.engineLock.unlock();
        }
        if (exc == null) {
            return;
        }
        if (exc instanceof SSLException) {
            throw (SSLException)exc;
        }
        if (exc instanceof RuntimeException) {
            throw (RuntimeException)exc;
        }
        throw SSLEngineImpl.getTaskThrown(exc);
    }

    private static SSLException getTaskThrown(Exception taskThrown) {
        String msg = taskThrown.getMessage();
        if (msg == null) {
            msg = "Delegated task threw Exception or Error";
        }
        if (taskThrown instanceof RuntimeException) {
            throw new RuntimeException(msg, taskThrown);
        }
        if (taskThrown instanceof SSLHandshakeException) {
            return (SSLHandshakeException)new SSLHandshakeException(msg).initCause(taskThrown);
        }
        if (taskThrown instanceof SSLKeyException) {
            return (SSLKeyException)new SSLKeyException(msg).initCause(taskThrown);
        }
        if (taskThrown instanceof SSLPeerUnverifiedException) {
            return (SSLPeerUnverifiedException)new SSLPeerUnverifiedException(msg).initCause(taskThrown);
        }
        if (taskThrown instanceof SSLProtocolException) {
            return (SSLProtocolException)new SSLProtocolException(msg).initCause(taskThrown);
        }
        if (taskThrown instanceof SSLException) {
            return (SSLException)taskThrown;
        }
        return new SSLException(msg, taskThrown);
    }

    private static class DelegatedTask
    implements Runnable {
        private final SSLEngineImpl engine;

        DelegatedTask(SSLEngineImpl engineInstance) {
            this.engine = engineInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.engine.engineLock.lock();
            try {
                HandshakeContext hc;
                block15: {
                    hc = this.engine.conContext.handshakeContext;
                    if (hc == null || hc.delegatedActions.isEmpty()) {
                        return;
                    }
                    try {
                        AccessController.doPrivileged(new DelegatedAction(hc), this.engine.conContext.acc);
                    }
                    catch (PrivilegedActionException pae) {
                        Exception reportedException = pae.getException();
                        if (this.engine.conContext.delegatedThrown == null) {
                            this.engine.conContext.delegatedThrown = reportedException;
                        }
                        if ((hc = this.engine.conContext.handshakeContext) != null) {
                            hc.delegatedThrown = reportedException;
                        } else if (this.engine.conContext.closeReason != null) {
                            this.engine.conContext.closeReason = SSLEngineImpl.getTaskThrown(reportedException);
                        }
                    }
                    catch (RuntimeException rte) {
                        if (this.engine.conContext.delegatedThrown == null) {
                            this.engine.conContext.delegatedThrown = rte;
                        }
                        if ((hc = this.engine.conContext.handshakeContext) != null) {
                            hc.delegatedThrown = rte;
                        }
                        if (this.engine.conContext.closeReason == null) break block15;
                        this.engine.conContext.closeReason = rte;
                    }
                }
                hc = this.engine.conContext.handshakeContext;
                if (hc != null) {
                    hc.taskDelegated = false;
                }
            }
            finally {
                this.engine.engineLock.unlock();
            }
        }

        private static class DelegatedAction
        implements PrivilegedExceptionAction<Void> {
            final HandshakeContext context;

            DelegatedAction(HandshakeContext context) {
                this.context = context;
            }

            @Override
            public Void run() throws Exception {
                while (!this.context.delegatedActions.isEmpty()) {
                    Map.Entry<Byte, ByteBuffer> me = this.context.delegatedActions.poll();
                    if (me == null) continue;
                    try {
                        this.context.dispatch((byte)me.getKey(), me.getValue());
                    }
                    catch (Exception e) {
                        throw this.context.conContext.fatal(Alert.INTERNAL_ERROR, "Unhandled exception", e);
                    }
                }
                return null;
            }
        }
    }
}

