/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.Ciphertext;
import com.tencent.kona.sun.security.ssl.ContentType;
import com.tencent.kona.sun.security.ssl.HandshakeHash;
import com.tencent.kona.sun.security.ssl.OutputRecord;
import com.tencent.kona.sun.security.ssl.ProtocolVersion;
import com.tencent.kona.sun.security.ssl.SSLCipher;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLRecord;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import javax.net.ssl.SSLHandshakeException;

final class SSLEngineOutputRecord
extends OutputRecord
implements SSLRecord {
    private HandshakeFragment fragmenter;
    private boolean isTalkingToV2;
    private ByteBuffer v2ClientHello;
    private volatile boolean isCloseWaiting;

    SSLEngineOutputRecord(HandshakeHash handshakeHash) {
        super(handshakeHash, SSLCipher.SSLWriteCipher.nullTlsWriteCipher());
        this.packetSize = 16709;
        this.protocolVersion = ProtocolVersion.NONE;
    }

    @Override
    public void close() throws IOException {
        this.recordLock.lock();
        try {
            if (!this.isClosed) {
                if (this.fragmenter != null && !this.fragmenter.isEmpty()) {
                    this.isCloseWaiting = true;
                } else {
                    super.close();
                }
            }
        }
        finally {
            this.recordLock.unlock();
        }
    }

    @Override
    boolean isClosed() {
        return this.isClosed || this.isCloseWaiting;
    }

    @Override
    void encodeAlert(byte level, byte description) {
        if (this.isClosed()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound alert message: " + Alert.nameOf(description), new Object[0]);
            }
            return;
        }
        if (this.fragmenter == null) {
            this.fragmenter = new HandshakeFragment();
        }
        this.fragmenter.queueUpAlert(level, description);
    }

    @Override
    void encodeHandshake(byte[] source, int offset, int length) {
        byte handshakeType;
        if (this.isClosed()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound handshake message", ByteBuffer.wrap(source, offset, length));
            }
            return;
        }
        if (this.fragmenter == null) {
            this.fragmenter = new HandshakeFragment();
        }
        if (this.firstMessage) {
            this.firstMessage = false;
            if (this.helloVersion == ProtocolVersion.SSL20Hello && source[offset] == SSLHandshake.CLIENT_HELLO.id && source[offset + 4 + 2 + 32] == 0) {
                this.v2ClientHello = SSLEngineOutputRecord.encodeV2ClientHello(source, offset + 4, length - 4);
                this.v2ClientHello.position(2);
                this.handshakeHash.deliver(this.v2ClientHello);
                this.v2ClientHello.position(0);
                return;
            }
        }
        if (this.handshakeHash.isHashable(handshakeType = source[offset])) {
            this.handshakeHash.deliver(source, offset, length);
        }
        this.fragmenter.queueUpFragment(source, offset, length);
    }

    @Override
    void encodeChangeCipherSpec() {
        if (this.isClosed()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound change_cipher_spec message", new Object[0]);
            }
            return;
        }
        if (this.fragmenter == null) {
            this.fragmenter = new HandshakeFragment();
        }
        this.fragmenter.queueUpChangeCipherSpec();
    }

    @Override
    void disposeWriteCipher() {
        if (this.fragmenter == null) {
            this.writeCipher.dispose();
        } else {
            this.fragmenter.queueUpCipherDispose();
        }
    }

    @Override
    void encodeV2NoCipher() {
        this.isTalkingToV2 = true;
    }

    @Override
    Ciphertext encode(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws IOException {
        if (this.isClosed) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound application data or cached messages", new Object[0]);
            }
            return null;
        }
        if (this.isCloseWaiting) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound application data", new Object[0]);
            }
            srcs = null;
        }
        return this.encode(srcs, srcsOffset, srcsLength, dsts[0]);
    }

    private Ciphertext encode(ByteBuffer[] sources, int offset, int length, ByteBuffer destination) throws IOException {
        if (this.writeCipher.authenticator.seqNumOverflow()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine("sequence number extremely close to overflow (2^64-1 packets). Closing connection.", new Object[0]);
            }
            throw new SSLHandshakeException("sequence number overflow");
        }
        Ciphertext ct = this.acquireCiphertext(destination);
        if (ct != null) {
            return ct;
        }
        if (sources == null || sources.length == 0) {
            return null;
        }
        int srcsRemains = 0;
        for (int i = offset; i < offset + length; ++i) {
            srcsRemains += sources[i].remaining();
        }
        if (srcsRemains == 0) {
            return null;
        }
        int dstLim = destination.limit();
        boolean isFirstRecordOfThePayload = true;
        int packetLeftSize = Math.min(16709, this.packetSize);
        boolean needMorePayload = true;
        long recordSN = 0L;
        while (needMorePayload) {
            int fragLen;
            if (isFirstRecordOfThePayload && this.needToSplitPayload()) {
                needMorePayload = true;
                fragLen = 1;
                isFirstRecordOfThePayload = false;
            } else {
                needMorePayload = false;
                if (packetLeftSize > 0) {
                    fragLen = this.writeCipher.calculateFragmentSize(packetLeftSize, 5);
                    fragLen = Math.min(fragLen, 16384);
                } else {
                    fragLen = 16384;
                }
                fragLen = this.calculateFragmentSize(fragLen);
            }
            int dstPos = destination.position();
            int dstContent = dstPos + 5 + this.writeCipher.getExplicitNonceSize();
            destination.position(dstContent);
            int remains = Math.min(fragLen, destination.remaining());
            fragLen = 0;
            int srcsLen = offset + length;
            for (int i = offset; i < srcsLen && remains > 0; ++i) {
                int amount = Math.min(sources[i].remaining(), remains);
                int srcLimit = sources[i].limit();
                sources[i].limit(sources[i].position() + amount);
                destination.put(sources[i]);
                sources[i].limit(srcLimit);
                fragLen += amount;
                if ((remains -= amount) <= 0) continue;
                ++offset;
                --length;
            }
            destination.limit(destination.position());
            destination.position(dstContent);
            if (SSLLogger.isOn && SSLLogger.isOn("record")) {
                SSLLogger.fine("WRITE: " + this.protocolVersion.name + " " + ContentType.APPLICATION_DATA.name + ", length = " + destination.remaining(), new Object[0]);
            }
            recordSN = SSLEngineOutputRecord.encrypt(this.writeCipher, ContentType.APPLICATION_DATA.id, destination, dstPos, dstLim, 5, this.protocolVersion);
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                ByteBuffer temporary = destination.duplicate();
                temporary.limit(temporary.position());
                temporary.position(dstPos);
                SSLLogger.fine("Raw write", temporary);
            }
            packetLeftSize -= destination.position() - dstPos;
            destination.limit(dstLim);
            if (!this.isFirstAppOutputRecord) continue;
            this.isFirstAppOutputRecord = false;
        }
        return new Ciphertext(ContentType.APPLICATION_DATA.id, SSLHandshake.NOT_APPLICABLE.id, recordSN);
    }

    private Ciphertext acquireCiphertext(ByteBuffer destination) throws IOException {
        if (this.isTalkingToV2) {
            destination.put(v2NoCipher);
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                SSLLogger.fine("Raw write", new Object[]{v2NoCipher});
            }
            this.isTalkingToV2 = false;
            return new Ciphertext(ContentType.ALERT.id, SSLHandshake.NOT_APPLICABLE.id, -1L);
        }
        if (this.v2ClientHello != null) {
            if (SSLLogger.isOn) {
                if (SSLLogger.isOn("record")) {
                    SSLLogger.fine(Thread.currentThread().getName() + ", WRITE: SSLv2 ClientHello message, length = " + this.v2ClientHello.remaining(), new Object[0]);
                }
                if (SSLLogger.isOn("packet")) {
                    SSLLogger.fine("Raw write", this.v2ClientHello);
                }
            }
            destination.put(this.v2ClientHello);
            this.v2ClientHello = null;
            return new Ciphertext(ContentType.HANDSHAKE.id, SSLHandshake.CLIENT_HELLO.id, -1L);
        }
        if (this.fragmenter != null) {
            return this.fragmenter.acquireCiphertext(destination);
        }
        return null;
    }

    @Override
    boolean isEmpty() {
        return !this.isTalkingToV2 && this.v2ClientHello == null && (this.fragmenter == null || this.fragmenter.isEmpty());
    }

    boolean needToSplitPayload() {
        return !this.protocolVersion.useTLS11PlusSpec() && !this.protocolVersion.isTLCP11() && this.writeCipher.isCBCMode() && !this.isFirstAppOutputRecord && enableCBCProtection;
    }

    final class HandshakeFragment {
        private final LinkedList<RecordMemo> handshakeMemos = new LinkedList();

        HandshakeFragment() {
        }

        void queueUpFragment(byte[] source, int offset, int length) {
            HandshakeMemo memo = new HandshakeMemo();
            memo.contentType = ContentType.HANDSHAKE.id;
            memo.majorVersion = SSLEngineOutputRecord.this.protocolVersion.major;
            memo.minorVersion = SSLEngineOutputRecord.this.protocolVersion.minor;
            memo.encodeCipher = SSLEngineOutputRecord.this.writeCipher;
            memo.handshakeType = source[offset];
            memo.acquireOffset = 0;
            memo.fragment = new byte[length - 4];
            System.arraycopy(source, offset + 4, memo.fragment, 0, length - 4);
            this.handshakeMemos.add(memo);
        }

        void queueUpChangeCipherSpec() {
            RecordMemo memo = new RecordMemo();
            memo.contentType = ContentType.CHANGE_CIPHER_SPEC.id;
            memo.majorVersion = SSLEngineOutputRecord.this.protocolVersion.major;
            memo.minorVersion = SSLEngineOutputRecord.this.protocolVersion.minor;
            memo.encodeCipher = SSLEngineOutputRecord.this.writeCipher;
            memo.fragment = new byte[1];
            memo.fragment[0] = 1;
            this.handshakeMemos.add(memo);
        }

        void queueUpAlert(byte level, byte description) {
            RecordMemo memo = new RecordMemo();
            memo.contentType = ContentType.ALERT.id;
            memo.majorVersion = SSLEngineOutputRecord.this.protocolVersion.major;
            memo.minorVersion = SSLEngineOutputRecord.this.protocolVersion.minor;
            memo.encodeCipher = SSLEngineOutputRecord.this.writeCipher;
            memo.fragment = new byte[2];
            memo.fragment[0] = level;
            memo.fragment[1] = description;
            this.handshakeMemos.add(memo);
        }

        void queueUpCipherDispose() {
            RecordMemo lastMemo = this.handshakeMemos.peekLast();
            if (lastMemo != null) {
                lastMemo.disposeCipher = true;
            } else {
                SSLEngineOutputRecord.this.writeCipher.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Ciphertext acquireCiphertext(ByteBuffer dstBuf) throws IOException {
            int fragLen;
            if (this.isEmpty()) {
                return null;
            }
            RecordMemo memo = this.handshakeMemos.getFirst();
            HandshakeMemo hsMemo = null;
            if (memo.contentType == ContentType.HANDSHAKE.id) {
                hsMemo = (HandshakeMemo)memo;
            }
            if (SSLEngineOutputRecord.this.packetSize > 0) {
                fragLen = Math.min(16709, SSLEngineOutputRecord.this.packetSize);
                fragLen = memo.encodeCipher.calculateFragmentSize(fragLen, 5);
            } else {
                fragLen = 16384;
            }
            fragLen = SSLEngineOutputRecord.this.calculateFragmentSize(fragLen);
            int dstPos = dstBuf.position();
            int dstLim = dstBuf.limit();
            int dstContent = dstPos + 5 + memo.encodeCipher.getExplicitNonceSize();
            dstBuf.position(dstContent);
            if (hsMemo != null) {
                int chipLen;
                for (int remainingFragLen = fragLen; remainingFragLen > 0 && !this.handshakeMemos.isEmpty(); remainingFragLen -= chipLen) {
                    int memoFragLen = hsMemo.fragment.length;
                    if (hsMemo.acquireOffset == 0) {
                        if (remainingFragLen <= 4) break;
                        dstBuf.put(hsMemo.handshakeType);
                        dstBuf.put((byte)(memoFragLen >> 16 & 0xFF));
                        dstBuf.put((byte)(memoFragLen >> 8 & 0xFF));
                        dstBuf.put((byte)(memoFragLen & 0xFF));
                        remainingFragLen -= 4;
                    }
                    chipLen = Math.min(remainingFragLen, memoFragLen - hsMemo.acquireOffset);
                    dstBuf.put(hsMemo.fragment, hsMemo.acquireOffset, chipLen);
                    hsMemo.acquireOffset += chipLen;
                    if (hsMemo.acquireOffset != memoFragLen) continue;
                    this.handshakeMemos.removeFirst();
                    if (remainingFragLen <= chipLen || this.handshakeMemos.isEmpty()) continue;
                    RecordMemo rm = this.handshakeMemos.getFirst();
                    if (rm.contentType == ContentType.HANDSHAKE.id && rm.encodeCipher == hsMemo.encodeCipher) {
                        hsMemo = (HandshakeMemo)rm;
                        continue;
                    }
                    break;
                }
            } else {
                fragLen = Math.min(fragLen, memo.fragment.length);
                dstBuf.put(memo.fragment, 0, fragLen);
                this.handshakeMemos.removeFirst();
            }
            dstBuf.limit(dstBuf.position());
            dstBuf.position(dstContent);
            if (SSLLogger.isOn && SSLLogger.isOn("record")) {
                SSLLogger.fine("WRITE: " + SSLEngineOutputRecord.this.protocolVersion.name + " " + ContentType.nameOf(memo.contentType) + ", length = " + dstBuf.remaining(), new Object[0]);
            }
            long recordSN = OutputRecord.encrypt(memo.encodeCipher, memo.contentType, dstBuf, dstPos, dstLim, 5, ProtocolVersion.valueOf(memo.majorVersion, memo.minorVersion));
            if (memo.disposeCipher) {
                memo.encodeCipher.dispose();
            }
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                ByteBuffer temporary = dstBuf.duplicate();
                temporary.limit(temporary.position());
                temporary.position(dstPos);
                SSLLogger.fine("Raw write", temporary);
            }
            dstBuf.limit(dstLim);
            try {
                if (hsMemo != null) {
                    Ciphertext ciphertext = new Ciphertext(hsMemo.contentType, hsMemo.handshakeType, recordSN);
                    return ciphertext;
                }
                Ciphertext ciphertext = new Ciphertext(memo.contentType, SSLHandshake.NOT_APPLICABLE.id, recordSN);
                return ciphertext;
            }
            finally {
                if (SSLEngineOutputRecord.this.isCloseWaiting && this.isEmpty()) {
                    SSLEngineOutputRecord.this.close();
                }
            }
        }

        boolean isEmpty() {
            return this.handshakeMemos.isEmpty();
        }
    }

    private static class HandshakeMemo
    extends RecordMemo {
        byte handshakeType;
        int acquireOffset;

        private HandshakeMemo() {
        }
    }

    private static class RecordMemo {
        byte contentType;
        byte majorVersion;
        byte minorVersion;
        SSLCipher.SSLWriteCipher encodeCipher;
        boolean disposeCipher;
        byte[] fragment;

        private RecordMemo() {
        }
    }
}

