/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.sun.security.ssl.CipherSuite;
import com.tencent.kona.sun.security.ssl.ClientAuthType;
import com.tencent.kona.sun.security.ssl.ProtocolVersion;
import com.tencent.kona.sun.security.ssl.SSLConfiguration;
import com.tencent.kona.sun.security.ssl.SSLContextImpl;
import com.tencent.kona.sun.security.ssl.SSLSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;

final class SSLServerSocketImpl
extends SSLServerSocket {
    private final SSLContextImpl sslContext;
    private final SSLConfiguration sslConfig;
    private final ReentrantLock serverSocketLock = new ReentrantLock();

    SSLServerSocketImpl(SSLContextImpl sslContext) throws IOException {
        this.sslContext = sslContext;
        this.sslConfig = new SSLConfiguration(sslContext, false);
    }

    SSLServerSocketImpl(SSLContextImpl sslContext, int port, int backlog) throws IOException {
        super(port, backlog);
        this.sslContext = sslContext;
        this.sslConfig = new SSLConfiguration(sslContext, false);
    }

    SSLServerSocketImpl(SSLContextImpl sslContext, int port, int backlog, InetAddress address) throws IOException {
        super(port, backlog, address);
        this.sslContext = sslContext;
        this.sslConfig = new SSLConfiguration(sslContext, false);
    }

    @Override
    public String[] getEnabledCipherSuites() {
        this.serverSocketLock.lock();
        try {
            String[] stringArray = CipherSuite.namesOf(this.sslConfig.enabledCipherSuites);
            return stringArray;
        }
        finally {
            this.serverSocketLock.unlock();
        }
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.serverSocketLock.lock();
        try {
            this.sslConfig.enabledCipherSuites = CipherSuite.validValuesOf(suites);
        }
        finally {
            this.serverSocketLock.unlock();
        }
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return CipherSuite.namesOf(this.sslContext.getSupportedCipherSuites());
    }

    @Override
    public String[] getSupportedProtocols() {
        return ProtocolVersion.toStringArray(this.sslContext.getSupportedProtocolVersions());
    }

    @Override
    public String[] getEnabledProtocols() {
        this.serverSocketLock.lock();
        try {
            String[] stringArray = ProtocolVersion.toStringArray(this.sslConfig.enabledProtocols);
            return stringArray;
        }
        finally {
            this.serverSocketLock.unlock();
        }
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.serverSocketLock.lock();
        try {
            if (protocols == null) {
                throw new IllegalArgumentException("Protocols cannot be null");
            }
            this.sslConfig.enabledProtocols = ProtocolVersion.namesOf(protocols);
        }
        finally {
            this.serverSocketLock.unlock();
        }
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.serverSocketLock.lock();
        try {
            this.sslConfig.clientAuthType = need ? ClientAuthType.CLIENT_AUTH_REQUIRED : ClientAuthType.CLIENT_AUTH_NONE;
        }
        finally {
            this.serverSocketLock.unlock();
        }
    }

    @Override
    public boolean getNeedClientAuth() {
        this.serverSocketLock.lock();
        try {
            boolean bl = this.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUIRED;
            return bl;
        }
        finally {
            this.serverSocketLock.unlock();
        }
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.serverSocketLock.lock();
        try {
            this.sslConfig.clientAuthType = want ? ClientAuthType.CLIENT_AUTH_REQUESTED : ClientAuthType.CLIENT_AUTH_NONE;
        }
        finally {
            this.serverSocketLock.unlock();
        }
    }

    @Override
    public boolean getWantClientAuth() {
        this.serverSocketLock.lock();
        try {
            boolean bl = this.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUESTED;
            return bl;
        }
        finally {
            this.serverSocketLock.unlock();
        }
    }

    @Override
    public void setUseClientMode(boolean useClientMode) {
        this.serverSocketLock.lock();
        try {
            if (this.sslConfig.isClientMode != useClientMode) {
                if (this.sslContext.isDefaultProtocolVesions(this.sslConfig.enabledProtocols)) {
                    this.sslConfig.enabledProtocols = this.sslContext.getDefaultProtocolVersions(!useClientMode);
                }
                if (this.sslContext.isDefaultCipherSuiteList(this.sslConfig.enabledCipherSuites)) {
                    this.sslConfig.enabledCipherSuites = this.sslContext.getDefaultCipherSuites(!useClientMode);
                }
                this.sslConfig.toggleClientMode();
            }
        }
        finally {
            this.serverSocketLock.unlock();
        }
    }

    @Override
    public boolean getUseClientMode() {
        this.serverSocketLock.lock();
        try {
            boolean bl = this.sslConfig.isClientMode;
            return bl;
        }
        finally {
            this.serverSocketLock.unlock();
        }
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.serverSocketLock.lock();
        try {
            this.sslConfig.enableSessionCreation = flag;
        }
        finally {
            this.serverSocketLock.unlock();
        }
    }

    @Override
    public boolean getEnableSessionCreation() {
        this.serverSocketLock.lock();
        try {
            boolean bl = this.sslConfig.enableSessionCreation;
            return bl;
        }
        finally {
            this.serverSocketLock.unlock();
        }
    }

    @Override
    public SSLParameters getSSLParameters() {
        this.serverSocketLock.lock();
        try {
            SSLParameters sSLParameters = this.sslConfig.getSSLParameters();
            return sSLParameters;
        }
        finally {
            this.serverSocketLock.unlock();
        }
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        this.serverSocketLock.lock();
        try {
            this.sslConfig.setSSLParameters(params);
        }
        finally {
            this.serverSocketLock.unlock();
        }
    }

    @Override
    public Socket accept() throws IOException {
        SSLSocketImpl s = new SSLSocketImpl(this.sslContext, this.sslConfig);
        this.implAccept(s);
        s.doneConnect();
        return s;
    }

    @Override
    public String toString() {
        return "[SSL: " + super.toString() + "]";
    }
}

