/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.CertificateRequest;
import com.tencent.kona.sun.security.ssl.CertificateStatus;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeOutStream;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.Record;
import com.tencent.kona.sun.security.ssl.SSLConsumer;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.TLCPAuthentication;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.security.auth.x500.X500Principal;

final class TLCPCertificateRequest {
    static final SSLConsumer tlcpHandshakeConsumer = new TLCPCertificateRequestConsumer();
    static final HandshakeProducer tlcpHandshakeProducer = new TLCPCertificateRequestProducer();

    TLCPCertificateRequest() {
    }

    private static final class TLCPCertificateRequestConsumer
    implements SSLConsumer {
        private TLCPCertificateRequestConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            chc.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_REQUEST.id);
            chc.receivedCertReq = true;
            if (chc.handshakeConsumers.containsKey(SSLHandshake.CERTIFICATE.id)) {
                throw chc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected CertificateRequest handshake message");
            }
            SSLConsumer certStatCons = (SSLConsumer)chc.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_STATUS.id);
            if (certStatCons != null) {
                CertificateStatus.handshakeAbsence.absent(context, null);
            }
            TLCPCertificateRequestMessage crm = new TLCPCertificateRequestMessage((HandshakeContext)chc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming CertificateRequest handshake message", crm);
            }
            chc.handshakeProducers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
            try {
                chc.peerSupportedAuthorities = crm.getAuthorities();
            }
            catch (IllegalArgumentException iae) {
                chc.conContext.fatal(Alert.DECODE_ERROR, "The distinguished names of the peer's certificate authorities could not be parsed", iae);
            }
            SSLPossession pos = TLCPAuthentication.createPossession(chc, new String[]{"EC"});
            if (pos == null) {
                return;
            }
            chc.handshakePossessions.add(pos);
            chc.handshakeProducers.put(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
        }
    }

    private static final class TLCPCertificateRequestProducer
    implements HandshakeProducer {
        private TLCPCertificateRequestProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            X509Certificate[] caCerts = shc.sslContext.getX509TrustManager().getAcceptedIssuers();
            TLCPCertificateRequestMessage crm = new TLCPCertificateRequestMessage((HandshakeContext)shc, caCerts);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced CertificateRequest handshake message", crm);
            }
            crm.write(shc.handshakeOutput);
            shc.handshakeOutput.flush();
            shc.handshakeConsumers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
            shc.handshakeConsumers.put(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
            return null;
        }
    }

    private static final class TLCPCertificateRequestMessage
    extends SSLHandshake.HandshakeMessage {
        final byte[] types;
        final List<byte[]> authorities;

        TLCPCertificateRequestMessage(HandshakeContext handshakeContext, X509Certificate[] trustedCerts) throws IOException {
            super(handshakeContext);
            this.types = new byte[]{CertificateRequest.ClientCertificateType.ECDSA_SIGN.id, CertificateRequest.ClientCertificateType.RSA_SIGN.id};
            this.authorities = new ArrayList<byte[]>(trustedCerts.length);
            for (X509Certificate cert : trustedCerts) {
                X500Principal x500Principal = cert.getSubjectX500Principal();
                this.authorities.add(x500Principal.getEncoded());
            }
        }

        TLCPCertificateRequestMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            if (m.remaining() < 4) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest handshake message: no sufficient data");
            }
            this.types = Record.getBytes8(m);
            if (m.remaining() < 2) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest handshake message: no sufficient data");
            }
            int listLen = Record.getInt16(m);
            if (listLen > m.remaining()) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest message: no sufficient data");
            }
            if (listLen > 0) {
                this.authorities = new LinkedList<byte[]>();
                while (listLen > 0) {
                    byte[] encoded = Record.getBytes16(m);
                    listLen -= 2 + encoded.length;
                    this.authorities.add(encoded);
                }
            } else {
                this.authorities = Collections.emptyList();
            }
        }

        String[] getKeyTypes() {
            return CertificateRequest.ClientCertificateType.getKeyTypes(this.types);
        }

        X500Principal[] getAuthorities() {
            X500Principal[] principals = new X500Principal[this.authorities.size()];
            int i = 0;
            for (byte[] encoded : this.authorities) {
                principals[i++] = new X500Principal(encoded);
            }
            return principals;
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE_REQUEST;
        }

        @Override
        public int messageLength() {
            int len = 1 + this.types.length + 2;
            for (byte[] encoded : this.authorities) {
                len += encoded.length + 2;
            }
            return len;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            hos.putBytes8(this.types);
            int listLen = 0;
            for (byte[] encoded : this.authorities) {
                listLen += encoded.length + 2;
            }
            hos.putInt16(listLen);
            for (byte[] encoded : this.authorities) {
                hos.putBytes16(encoded);
            }
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"CertificateRequest\": '{'\n  \"certificate types\": {0}\n  \"supported signature algorithms\": [sm2sig_sm3]\n  \"certificate authorities\": {1}\n'}'", Locale.ENGLISH);
            ArrayList<String> typeNames = new ArrayList<String>(this.types.length);
            for (byte type : this.types) {
                typeNames.add(CertificateRequest.ClientCertificateType.nameOf(type));
            }
            ArrayList<String> authorityNames = new ArrayList<String>(this.authorities.size());
            for (byte[] encoded : this.authorities) {
                try {
                    X500Principal principal = new X500Principal(encoded);
                    authorityNames.add(principal.toString());
                }
                catch (IllegalArgumentException iae) {
                    authorityNames.add("unparseable distinguished name: " + iae);
                }
            }
            Object[] messageFields = new Object[]{typeNames, authorityNames};
            return messageFormat.format(messageFields);
        }
    }
}

