/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.pkix.PKIXUtils;
import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeOutStream;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.Record;
import com.tencent.kona.sun.security.ssl.SSLConsumer;
import com.tencent.kona.sun.security.ssl.SSLCredentials;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.SignatureScheme;
import com.tencent.kona.sun.security.ssl.TLCPAuthentication;
import com.tencent.kona.sun.security.ssl.Utilities;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.text.MessageFormat;
import java.util.Locale;

final class TLCPCertificateVerify {
    static final SSLConsumer tlcpHandshakeConsumer = new TLCPCertificateVerifyConsumer();
    static final HandshakeProducer tlcpHandshakeProducer = new TLCPCertificateVerifyProducer();

    TLCPCertificateVerify() {
    }

    private static final class TLCPCertificateVerifyConsumer
    implements SSLConsumer {
        private TLCPCertificateVerifyConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            shc.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_VERIFY.id);
            if (shc.handshakeConsumers.containsKey(SSLHandshake.CLIENT_KEY_EXCHANGE.id)) {
                throw shc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected CertificateVerify handshake message");
            }
            TLCPCertificateVerifyMessage cvm = new TLCPCertificateVerifyMessage((HandshakeContext)shc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming CertificateVerify handshake message", cvm);
            }
        }
    }

    private static final class TLCPCertificateVerifyProducer
    implements HandshakeProducer {
        private TLCPCertificateVerifyProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            TLCPAuthentication.TLCPPossession tlcpPossession = null;
            for (SSLPossession possession : chc.handshakePossessions) {
                if (!(possession instanceof TLCPAuthentication.TLCPPossession)) continue;
                tlcpPossession = (TLCPAuthentication.TLCPPossession)possession;
                break;
            }
            if (tlcpPossession == null || tlcpPossession.popSignPrivateKey == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("No X.509 credentials negotiated for CertificateVerify", new Object[0]);
                }
                return null;
            }
            TLCPCertificateVerifyMessage cvm = new TLCPCertificateVerifyMessage((HandshakeContext)chc, tlcpPossession);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced CertificateVerify handshake message", cvm);
            }
            cvm.write(chc.handshakeOutput);
            chc.handshakeOutput.flush();
            return null;
        }
    }

    private static final class TLCPCertificateVerifyMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] signature;

        TLCPCertificateVerifyMessage(HandshakeContext context, TLCPAuthentication.TLCPPossession tlcpPossession) throws IOException {
            super(context);
            byte[] temporary;
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            try {
                Signature signer = SignatureScheme.SM2SIG_SM3.getSigner(tlcpPossession.popSignPrivateKey, tlcpPossession.popSignPublicKey, false);
                signer.update(chc.handshakeHash.digest());
                temporary = signer.sign();
            }
            catch (SignatureException se) {
                throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot produce CertificateVerify signature", se);
            }
            this.signature = temporary;
        }

        TLCPCertificateVerifyMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            ServerHandshakeContext shc = (ServerHandshakeContext)handshakeContext;
            if (m.remaining() < 2) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateVerify message: no sufficient data");
            }
            TLCPAuthentication.TLCPCredentials tlcpCredentials = null;
            for (SSLCredentials cd : shc.handshakeCredentials) {
                if (!(cd instanceof TLCPAuthentication.TLCPCredentials)) continue;
                tlcpCredentials = (TLCPAuthentication.TLCPCredentials)cd;
                break;
            }
            if (tlcpCredentials == null || tlcpCredentials.popSignPublicKey == null) {
                throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No X509 credentials negotiated for CertificateVerify");
            }
            this.signature = Record.getBytes16(m);
            if (!PKIXUtils.isSMCert(tlcpCredentials.popSignCert)) {
                throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Only support SM certificate");
            }
            try {
                Signature signer = SignatureScheme.SM2SIG_SM3.getVerifier(tlcpCredentials.popSignPublicKey);
                signer.update(shc.handshakeHash.digest());
                if (!signer.verify(this.signature)) {
                    throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid CertificateVerify signature");
                }
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException nsae) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm (sm2sig_sm3)used in CertificateVerify handshake message", nsae);
            }
            catch (InvalidKeyException | SignatureException ikse) {
                throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify CertificateVerify signature", ikse);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE_VERIFY;
        }

        @Override
        public int messageLength() {
            return 2 + this.signature.length;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            hos.putBytes16(this.signature);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"CertificateVerify\": '{'\n  \"signature algorithm\": sm2sig_sm3\n  \"signature\": '{'\n{0}\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{Utilities.indent(hexEncoder.encodeBuffer(this.signature), "    ")};
            return messageFormat.format(messageFields);
        }
    }
}

