/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.sun.security.ssl.CipherSuite;
import com.tencent.kona.sun.security.ssl.ProtocolVersion;
import com.tencent.kona.sun.security.ssl.SSLContextImpl;
import java.util.ArrayList;
import java.util.List;

public final class TLCPContextImpl {

    public static final class TLCPContext
    extends SSLContextImpl.AbstractTLSContext {
        private static final List<ProtocolVersion> serverDefaultProtocols;
        private static final List<CipherSuite> serverDefaultCipherSuites;
        private static final List<ProtocolVersion> clientDefaultProtocols;
        private static final List<CipherSuite> clientDefaultCipherSuites;
        private static final IllegalArgumentException reservedException;

        private static List<ProtocolVersion> customizedProtocols(boolean client, List<ProtocolVersion> customized) {
            ArrayList<ProtocolVersion> refactored = new ArrayList<ProtocolVersion>();
            for (ProtocolVersion pv : customized) {
                if (pv.isDTLS) continue;
                refactored.add(pv);
            }
            ProtocolVersion[] candidates = refactored.isEmpty() ? new ProtocolVersion[]{ProtocolVersion.TLCP11, ProtocolVersion.TLS13, ProtocolVersion.TLS12, ProtocolVersion.TLS11, ProtocolVersion.TLS10} : refactored.toArray(new ProtocolVersion[0]);
            return TLCPContext.getAvailableProtocols(candidates);
        }

        @Override
        List<ProtocolVersion> getServerDefaultProtocolVersions() {
            return serverDefaultProtocols;
        }

        @Override
        List<CipherSuite> getServerDefaultCipherSuites() {
            return serverDefaultCipherSuites;
        }

        @Override
        List<ProtocolVersion> getClientDefaultProtocolVersions() {
            return clientDefaultProtocols;
        }

        @Override
        List<CipherSuite> getClientDefaultCipherSuites() {
            return clientDefaultCipherSuites;
        }

        static {
            reservedException = SSLContextImpl.CustomizedSSLProtocols.reservedException;
            if (reservedException == null) {
                clientDefaultProtocols = TLCPContext.customizedProtocols(true, SSLContextImpl.CustomizedSSLProtocols.customizedClientProtocols);
                serverDefaultProtocols = TLCPContext.customizedProtocols(false, SSLContextImpl.CustomizedSSLProtocols.customizedServerProtocols);
                clientDefaultCipherSuites = TLCPContext.getApplicableEnabledCipherSuites(clientDefaultProtocols, true);
                serverDefaultCipherSuites = TLCPContext.getApplicableEnabledCipherSuites(serverDefaultProtocols, false);
            } else {
                clientDefaultProtocols = null;
                serverDefaultProtocols = null;
                clientDefaultCipherSuites = null;
                serverDefaultCipherSuites = null;
            }
        }
    }

    public static final class TLCP11Context
    extends SSLContextImpl.AbstractTLSContext {
        private static final List<ProtocolVersion> serverDefaultProtocols = TLCP11Context.getAvailableProtocols(new ProtocolVersion[]{ProtocolVersion.TLCP11});
        private static final List<CipherSuite> serverDefaultCipherSuites;
        private static final List<ProtocolVersion> clientDefaultProtocols;
        private static final List<CipherSuite> clientDefaultCipherSuites;

        @Override
        List<ProtocolVersion> getServerDefaultProtocolVersions() {
            return serverDefaultProtocols;
        }

        @Override
        List<CipherSuite> getServerDefaultCipherSuites() {
            return serverDefaultCipherSuites;
        }

        @Override
        List<ProtocolVersion> getClientDefaultProtocolVersions() {
            return clientDefaultProtocols;
        }

        @Override
        List<CipherSuite> getClientDefaultCipherSuites() {
            return clientDefaultCipherSuites;
        }

        static {
            clientDefaultProtocols = TLCP11Context.getAvailableProtocols(new ProtocolVersion[]{ProtocolVersion.TLCP11});
            serverDefaultCipherSuites = TLCP11Context.getApplicableEnabledCipherSuites(serverDefaultProtocols, false);
            clientDefaultCipherSuites = TLCP11Context.getApplicableEnabledCipherSuites(clientDefaultProtocols, true);
        }
    }
}

