/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.SM2ClientKeyExchange;
import com.tencent.kona.sun.security.ssl.SM2EClientKeyExchange;
import com.tencent.kona.sun.security.ssl.SM2EKeyExchange;
import com.tencent.kona.sun.security.ssl.SM2EServerKeyExchange;
import com.tencent.kona.sun.security.ssl.SM2KeyExchange;
import com.tencent.kona.sun.security.ssl.SM2ServerKeyExchange;
import com.tencent.kona.sun.security.ssl.SSLConsumer;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLKeyAgreement;
import com.tencent.kona.sun.security.ssl.SSLKeyAgreementGenerator;
import com.tencent.kona.sun.security.ssl.SSLKeyDerivation;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.SSLPossessionGenerator;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

enum TLCPKeyAgreement implements SSLKeyAgreement
{
    SM2("sm2", SM2KeyExchange.sm2PoGenerator, SM2KeyExchange.sm2KAGenerator),
    SM2E("sm2e", SM2EKeyExchange.sm2ePoGenerator, SM2EKeyExchange.sm2eKAGenerator);

    final String name;
    final SSLPossessionGenerator possessionGenerator;
    final SSLKeyAgreementGenerator keyAgreementGenerator;

    private TLCPKeyAgreement(String name, SSLPossessionGenerator possessionGenerator, SSLKeyAgreementGenerator keyAgreementGenerator) {
        this.name = name;
        this.possessionGenerator = possessionGenerator;
        this.keyAgreementGenerator = keyAgreementGenerator;
    }

    @Override
    public SSLPossession createPossession(HandshakeContext context) {
        if (this.possessionGenerator != null) {
            return this.possessionGenerator.createPossession(context);
        }
        return null;
    }

    @Override
    public SSLKeyDerivation createKeyDerivation(HandshakeContext context) throws IOException {
        return this.keyAgreementGenerator.createKeyDerivation(context);
    }

    @Override
    public SSLHandshake[] getRelatedHandshakers(HandshakeContext handshakeContext) {
        if (!handshakeContext.negotiatedProtocol.useTLS13PlusSpec() && this.possessionGenerator != null) {
            return new SSLHandshake[]{SSLHandshake.SERVER_KEY_EXCHANGE};
        }
        return new SSLHandshake[0];
    }

    @Override
    public Map.Entry<Byte, HandshakeProducer>[] getHandshakeProducers(HandshakeContext handshakeContext) {
        if (handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
            return new Map.Entry[0];
        }
        if (handshakeContext.sslConfig.isClientMode) {
            switch (this) {
                case SM2: {
                    return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, SM2ClientKeyExchange.sm2HandshakeProducer)};
                }
                case SM2E: {
                    return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, SM2EClientKeyExchange.sm2eHandshakeProducer)};
                }
            }
        } else {
            switch (this) {
                case SM2: {
                    return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, SM2ServerKeyExchange.sm2HandshakeProducer)};
                }
                case SM2E: {
                    return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, HandshakeProducer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, SM2EServerKeyExchange.sm2eHandshakeProducer)};
                }
            }
        }
        return new Map.Entry[0];
    }

    @Override
    public Map.Entry<Byte, SSLConsumer>[] getHandshakeConsumers(HandshakeContext handshakeContext) {
        if (handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
            return new Map.Entry[0];
        }
        if (handshakeContext.sslConfig.isClientMode) {
            switch (this) {
                case SM2: {
                    return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, SM2ServerKeyExchange.sm2HandshakeConsumer)};
                }
                case SM2E: {
                    return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.SERVER_KEY_EXCHANGE.id, SM2EServerKeyExchange.sm2eHandshakeConsumer)};
                }
            }
        } else {
            switch (this) {
                case SM2: {
                    return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, SM2ClientKeyExchange.sm2HandshakeConsumer)};
                }
                case SM2E: {
                    return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLConsumer>(SSLHandshake.CLIENT_KEY_EXCHANGE.id, SM2EClientKeyExchange.sm2eHandshakeConsumer)};
                }
            }
        }
        return new Map.Entry[0];
    }
}

