/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.NamedGroup;
import com.tencent.kona.sun.security.ssl.SSLAuthentication;
import com.tencent.kona.sun.security.ssl.SSLCredentials;
import com.tencent.kona.sun.security.ssl.SSLEngineImpl;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.SSLSocketImpl;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.X509ExtendedKeyManager;

enum X509Authentication implements SSLAuthentication
{
    RSA("RSA", "RSA"),
    RSASSA_PSS("RSASSA-PSS", "RSASSA-PSS"),
    RSA_OR_PSS("RSA_OR_PSS", "RSA", "RSASSA-PSS"),
    DSA("DSA", "DSA"),
    EC("EC", "EC"),
    EDDSA("EdDSA", "EdDSA");

    final String keyAlgorithm;
    final String[] keyTypes;

    private X509Authentication(String keyAlgorithm, String ... keyTypes) {
        this.keyAlgorithm = keyAlgorithm;
        this.keyTypes = keyTypes;
    }

    static X509Authentication valueOfKeyAlgorithm(String keyAlgorithm) {
        for (X509Authentication au : X509Authentication.values()) {
            if (!au.keyAlgorithm.equals(keyAlgorithm)) continue;
            return au;
        }
        return null;
    }

    @Override
    public SSLPossession createPossession(HandshakeContext handshakeContext) {
        return X509Authentication.createPossession(handshakeContext, this.keyTypes);
    }

    @Override
    public SSLHandshake[] getRelatedHandshakers(HandshakeContext handshakeContext) {
        if (!handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
            return new SSLHandshake[]{SSLHandshake.CERTIFICATE, SSLHandshake.CERTIFICATE_REQUEST};
        }
        return new SSLHandshake[0];
    }

    @Override
    public Map.Entry<Byte, HandshakeProducer>[] getHandshakeProducers(HandshakeContext handshakeContext) {
        if (!handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
            return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLHandshake>(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE)};
        }
        return new Map.Entry[0];
    }

    public static SSLPossession createPossession(HandshakeContext context, String[] keyTypes) {
        if (context.sslConfig.isClientMode) {
            return X509Authentication.createClientPossession((ClientHandshakeContext)context, keyTypes);
        }
        return X509Authentication.createServerPossession((ServerHandshakeContext)context, keyTypes);
    }

    private static SSLPossession createClientPossession(ClientHandshakeContext chc, String[] keyTypes) {
        X509ExtendedKeyManager km = chc.sslContext.getX509KeyManager();
        if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
            SSLLogger.finest("X509KeyManager class: " + km.getClass().getName(), new Object[0]);
        }
        String clientAlias = null;
        if (chc.conContext.transport instanceof SSLSocketImpl) {
            SSLSocketImpl socket = (SSLSocketImpl)chc.conContext.transport;
            clientAlias = km.chooseClientAlias(keyTypes, chc.peerSupportedAuthorities == null ? null : (Principal[])chc.peerSupportedAuthorities.clone(), socket);
        } else if (chc.conContext.transport instanceof SSLEngineImpl) {
            SSLEngineImpl engine = (SSLEngineImpl)chc.conContext.transport;
            clientAlias = km.chooseEngineClientAlias(keyTypes, chc.peerSupportedAuthorities == null ? null : (Principal[])chc.peerSupportedAuthorities.clone(), engine);
        }
        if (clientAlias == null) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest("No X.509 cert selected for " + Arrays.toString(keyTypes), new Object[0]);
            }
            return null;
        }
        PrivateKey clientPrivateKey = km.getPrivateKey(clientAlias);
        if (clientPrivateKey == null) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest(clientAlias + " is not a private key entry", new Object[0]);
            }
            return null;
        }
        X509Certificate[] clientCerts = km.getCertificateChain(clientAlias);
        if (clientCerts == null || clientCerts.length == 0) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest(clientAlias + " is a private key entry with no cert chain stored", new Object[0]);
            }
            return null;
        }
        String privateKeyAlgorithm = clientPrivateKey.getAlgorithm();
        if (!Arrays.asList(keyTypes).contains(privateKeyAlgorithm)) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine(clientAlias + " private key algorithm " + privateKeyAlgorithm + " not in request list", new Object[0]);
            }
            return null;
        }
        String publicKeyAlgorithm = clientCerts[0].getPublicKey().getAlgorithm();
        if (!privateKeyAlgorithm.equals(publicKeyAlgorithm)) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine(clientAlias + " private or public key is not of same algorithm: " + privateKeyAlgorithm + " vs " + publicKeyAlgorithm, new Object[0]);
            }
            return null;
        }
        return new X509Possession(clientPrivateKey, clientCerts);
    }

    private static SSLPossession createServerPossession(ServerHandshakeContext shc, String[] keyTypes) {
        X509ExtendedKeyManager km = shc.sslContext.getX509KeyManager();
        if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
            SSLLogger.finest("X509KeyManager class: " + km.getClass().getName(), new Object[0]);
        }
        for (String keyType : keyTypes) {
            String serverAlias = null;
            if (shc.conContext.transport instanceof SSLSocketImpl) {
                SSLSocketImpl socket = (SSLSocketImpl)shc.conContext.transport;
                serverAlias = km.chooseServerAlias(keyType, shc.peerSupportedAuthorities == null ? null : (Principal[])shc.peerSupportedAuthorities.clone(), socket);
            } else if (shc.conContext.transport instanceof SSLEngineImpl) {
                SSLEngineImpl engine = (SSLEngineImpl)shc.conContext.transport;
                serverAlias = km.chooseEngineServerAlias(keyType, shc.peerSupportedAuthorities == null ? null : (Principal[])shc.peerSupportedAuthorities.clone(), engine);
            }
            if (serverAlias == null) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                SSLLogger.finest("No X.509 cert selected for " + keyType, new Object[0]);
                continue;
            }
            PrivateKey serverPrivateKey = km.getPrivateKey(serverAlias);
            if (serverPrivateKey == null) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                SSLLogger.finest(serverAlias + " is not a private key entry", new Object[0]);
                continue;
            }
            X509Certificate[] serverCerts = km.getCertificateChain(serverAlias);
            if (serverCerts == null || serverCerts.length == 0) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                SSLLogger.finest(serverAlias + " is not a certificate entry", new Object[0]);
                continue;
            }
            PublicKey serverPublicKey = serverCerts[0].getPublicKey();
            if (!serverPrivateKey.getAlgorithm().equals(keyType) || !serverPublicKey.getAlgorithm().equals(keyType)) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                SSLLogger.fine(serverAlias + " private or public key is not of " + keyType + " algorithm", new Object[0]);
                continue;
            }
            if (!shc.negotiatedProtocol.useTLS13PlusSpec() && keyType.equals("EC")) {
                if (!(serverPublicKey instanceof ECPublicKey)) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                    SSLLogger.warning(serverAlias + " public key is not an instance of ECPublicKey", new Object[0]);
                    continue;
                }
                ECParameterSpec params = ((ECPublicKey)serverPublicKey).getParams();
                NamedGroup namedGroup = NamedGroup.valueOf(params);
                if (namedGroup == null || !NamedGroup.isEnabled(shc.sslConfig, namedGroup) || shc.clientRequestedNamedGroups != null && !shc.clientRequestedNamedGroups.contains((Object)namedGroup)) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                    SSLLogger.warning("Unsupported named group (" + (Object)((Object)namedGroup) + ") used in the " + serverAlias + " certificate", new Object[0]);
                    continue;
                }
            }
            return new X509Possession(serverPrivateKey, serverCerts);
        }
        return null;
    }

    static final class X509Credentials
    implements SSLCredentials {
        final X509Certificate[] popCerts;
        final PublicKey popPublicKey;

        X509Credentials(PublicKey popPublicKey, X509Certificate[] popCerts) {
            this.popCerts = popCerts;
            this.popPublicKey = popPublicKey;
        }
    }

    static final class X509Possession
    implements SSLPossession {
        final X509Certificate[] popCerts;
        final PrivateKey popPrivateKey;

        X509Possession(PrivateKey popPrivateKey, X509Certificate[] popCerts) {
            this.popCerts = popCerts;
            this.popPrivateKey = popPrivateKey;
        }

        ECParameterSpec getECParameterSpec() {
            PublicKey publicKey;
            if (this.popPrivateKey == null || !"EC".equals(this.popPrivateKey.getAlgorithm())) {
                return null;
            }
            if (this.popPrivateKey instanceof ECKey) {
                return ((ECKey)((Object)this.popPrivateKey)).getParams();
            }
            if (this.popCerts != null && this.popCerts.length != 0 && (publicKey = this.popCerts[0].getPublicKey()) instanceof ECKey) {
                return ((ECKey)((Object)publicKey)).getParams();
            }
            return null;
        }
    }
}

