/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.tools.keytool;

import com.tencent.kona.sun.security.util.SignatureUtil;
import com.tencent.kona.sun.security.x509.CertificateExtensions;
import com.tencent.kona.sun.security.x509.CertificateSerialNumber;
import com.tencent.kona.sun.security.x509.CertificateValidity;
import com.tencent.kona.sun.security.x509.CertificateVersion;
import com.tencent.kona.sun.security.x509.CertificateX509Key;
import com.tencent.kona.sun.security.x509.X500Name;
import com.tencent.kona.sun.security.x509.X509CertImpl;
import com.tencent.kona.sun.security.x509.X509CertInfo;
import com.tencent.kona.sun.security.x509.X509Key;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class CertAndKeyGen {
    private SecureRandom prng;
    private final String keyType;
    private String sigAlg;
    private KeyPairGenerator keyGen;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private boolean signerFlag;
    private PrivateKey signerPrivateKey;
    private X500Name signerSubjectName;

    public CertAndKeyGen(String keyType, String sigAlg) throws NoSuchAlgorithmException {
        this.keyGen = KeyPairGenerator.getInstance(keyType);
        this.sigAlg = sigAlg;
        this.keyType = keyType;
    }

    public CertAndKeyGen(String keyType, String sigAlg, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        this(keyType, sigAlg, providerName, null, null);
    }

    public CertAndKeyGen(String keyType, String sigAlg, String providerName, PrivateKey signerPrivateKey, X500Name signerSubjectName) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (providerName == null) {
            this.keyGen = KeyPairGenerator.getInstance(keyType);
        } else {
            try {
                this.keyGen = KeyPairGenerator.getInstance(keyType, providerName);
            }
            catch (Exception e) {
                this.keyGen = KeyPairGenerator.getInstance(keyType);
            }
        }
        this.sigAlg = sigAlg;
        this.keyType = keyType;
        this.signerPrivateKey = signerPrivateKey;
        this.signerSubjectName = signerSubjectName;
        this.signerFlag = signerPrivateKey != null;
    }

    public void setRandom(SecureRandom generator) {
        this.prng = generator;
    }

    public void generate(String name) {
        try {
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            if (!this.keyType.equalsIgnoreCase("EC")) {
                throw new UnsupportedOperationException("Only support EC: " + name);
            }
            this.keyGen.initialize(new ECGenParameterSpec(name), this.prng);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        this.generateInternal();
    }

    public void generate(int keyBits) {
        if (keyBits != -1) {
            try {
                if (this.prng == null) {
                    this.prng = new SecureRandom();
                }
                this.keyGen.initialize(keyBits, this.prng);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        this.generateInternal();
    }

    private void generateInternal() {
        KeyPair pair = this.keyGen.generateKeyPair();
        this.publicKey = pair.getPublic();
        this.privateKey = pair.getPrivate();
        if (!"X.509".equalsIgnoreCase(this.publicKey.getFormat())) {
            throw new IllegalArgumentException("Public key format is " + this.publicKey.getFormat() + ", must be X.509");
        }
        if (this.sigAlg == null) {
            if (this.signerFlag) {
                this.sigAlg = SignatureUtil.getDefaultSigAlgForKey(this.signerPrivateKey);
                if (this.sigAlg == null) {
                    throw new IllegalArgumentException("Cannot derive signature algorithm from " + this.signerPrivateKey.getAlgorithm());
                }
            } else {
                this.sigAlg = SignatureUtil.getDefaultSigAlgForKey(this.privateKey);
                if (this.sigAlg == null) {
                    throw new IllegalArgumentException("Cannot derive signature algorithm from " + this.privateKey.getAlgorithm());
                }
            }
        }
    }

    public X509Key getPublicKey() {
        if (!(this.publicKey instanceof X509Key)) {
            return null;
        }
        return (X509Key)this.publicKey;
    }

    public PublicKey getPublicKeyAnyway() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getSelfCertificate(X500Name myname, Date firstDate, long validity) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.getSelfCertificate(myname, firstDate, validity, null);
    }

    public X509Certificate getSelfCertificate(X500Name myname, Date firstDate, long validity, CertificateExtensions ext) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            Date lastDate = new Date();
            lastDate.setTime(firstDate.getTime() + validity * 1000L);
            GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            c.setTime(lastDate);
            if (c.get(1) > 9999) {
                throw new CertificateException("Validity period ends at calendar year " + c.get(1) + " which is greater than 9999");
            }
            CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
            X509CertInfo info = new X509CertInfo();
            info.setVersion(new CertificateVersion(2));
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            info.setSerialNumber(CertificateSerialNumber.newRandom64bit(this.prng));
            info.setSubject(myname);
            info.setKey(new CertificateX509Key(this.publicKey));
            info.setValidity(interval);
            if (this.signerFlag) {
                info.setIssuer(this.signerSubjectName);
            } else {
                info.setIssuer(myname);
            }
            if (ext != null) {
                info.setExtensions(ext);
            }
            X509CertImpl cert = this.signerFlag ? X509CertImpl.newSigned(info, this.signerPrivateKey, this.sigAlg) : X509CertImpl.newSigned(info, this.privateKey, this.sigAlg);
            return cert;
        }
        catch (IOException e) {
            throw new CertificateEncodingException("getSelfCert: " + e.getMessage(), e);
        }
    }

    public X509Certificate getSelfCertificate(X500Name myname, long validity) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.getSelfCertificate(myname, new Date(), validity);
    }
}

