/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.util.math.intpoly;

import com.tencent.kona.sun.security.util.math.intpoly.IntegerPolynomial;
import java.math.BigInteger;

public final class P521OrderField
extends IntegerPolynomial {
    private static final int BITS_PER_LIMB = 28;
    private static final int NUM_LIMBS = 19;
    private static final int MAX_ADDS = 1;
    public static final BigInteger MODULUS = P521OrderField.evaluateModulus();
    private static final long CARRY_ADD = 0x8000000L;
    private static final int LIMB_MASK = 0xFFFFFFF;
    public static final P521OrderField ONE = new P521OrderField();

    private P521OrderField() {
        super(28, 19, 1, MODULUS);
    }

    private static BigInteger evaluateModulus() {
        BigInteger result = BigInteger.valueOf(2L).pow(521);
        result = result.add(BigInteger.valueOf(20472841L));
        result = result.add(BigInteger.valueOf(117141993L).shiftLeft(28));
        result = result.subtract(BigInteger.valueOf(62411077L).shiftLeft(56));
        result = result.subtract(BigInteger.valueOf(56915814L).shiftLeft(84));
        result = result.add(BigInteger.valueOf(97532854L).shiftLeft(112));
        result = result.add(BigInteger.valueOf(76509338L).shiftLeft(140));
        result = result.subtract(BigInteger.valueOf(75510783L).shiftLeft(168));
        result = result.subtract(BigInteger.valueOf(67962521L).shiftLeft(196));
        result = result.add(BigInteger.valueOf(25593732L).shiftLeft(224));
        result = result.subtract(BigInteger.valueOf(91L).shiftLeft(252));
        return result;
    }

    @Override
    protected void reduceIn(long[] limbs, long v, int i) {
        long t0 = -20472841L * v;
        int n = i - 19;
        limbs[n] = limbs[n] + (t0 << 11 & 0xFFFFFFFL);
        int n2 = i - 18;
        limbs[n2] = limbs[n2] + (t0 >> 17);
        long t1 = -117141993L * v;
        int n3 = i - 18;
        limbs[n3] = limbs[n3] + (t1 << 11 & 0xFFFFFFFL);
        int n4 = i - 17;
        limbs[n4] = limbs[n4] + (t1 >> 17);
        long t2 = 62411077L * v;
        int n5 = i - 17;
        limbs[n5] = limbs[n5] + (t2 << 11 & 0xFFFFFFFL);
        int n6 = i - 16;
        limbs[n6] = limbs[n6] + (t2 >> 17);
        long t3 = 56915814L * v;
        int n7 = i - 16;
        limbs[n7] = limbs[n7] + (t3 << 11 & 0xFFFFFFFL);
        int n8 = i - 15;
        limbs[n8] = limbs[n8] + (t3 >> 17);
        long t4 = -97532854L * v;
        int n9 = i - 15;
        limbs[n9] = limbs[n9] + (t4 << 11 & 0xFFFFFFFL);
        int n10 = i - 14;
        limbs[n10] = limbs[n10] + (t4 >> 17);
        long t5 = -76509338L * v;
        int n11 = i - 14;
        limbs[n11] = limbs[n11] + (t5 << 11 & 0xFFFFFFFL);
        int n12 = i - 13;
        limbs[n12] = limbs[n12] + (t5 >> 17);
        long t6 = 75510783L * v;
        int n13 = i - 13;
        limbs[n13] = limbs[n13] + (t6 << 11 & 0xFFFFFFFL);
        int n14 = i - 12;
        limbs[n14] = limbs[n14] + (t6 >> 17);
        long t7 = 67962521L * v;
        int n15 = i - 12;
        limbs[n15] = limbs[n15] + (t7 << 11 & 0xFFFFFFFL);
        int n16 = i - 11;
        limbs[n16] = limbs[n16] + (t7 >> 17);
        long t8 = -25593732L * v;
        int n17 = i - 11;
        limbs[n17] = limbs[n17] + (t8 << 11 & 0xFFFFFFFL);
        int n18 = i - 10;
        limbs[n18] = limbs[n18] + (t8 >> 17);
        long t9 = 91L * v;
        int n19 = i - 10;
        limbs[n19] = limbs[n19] + (t9 << 11 & 0xFFFFFFFL);
        int n20 = i - 9;
        limbs[n20] = limbs[n20] + (t9 >> 17);
    }

    @Override
    protected void finalCarryReduceLast(long[] limbs) {
        long c = limbs[18] >> 17;
        limbs[18] = limbs[18] - (c << 17);
        long t10 = -20472841L * c;
        limbs[0] = limbs[0] + t10;
        t10 = -117141993L * c;
        limbs[1] = limbs[1] + t10;
        t10 = 62411077L * c;
        limbs[2] = limbs[2] + t10;
        t10 = 56915814L * c;
        limbs[3] = limbs[3] + t10;
        t10 = -97532854L * c;
        limbs[4] = limbs[4] + t10;
        t10 = -76509338L * c;
        limbs[5] = limbs[5] + t10;
        t10 = 75510783L * c;
        limbs[6] = limbs[6] + t10;
        t10 = 67962521L * c;
        limbs[7] = limbs[7] + t10;
        t10 = -25593732L * c;
        limbs[8] = limbs[8] + t10;
        t10 = 91L * c;
        limbs[9] = limbs[9] + t10;
    }

    private void carryReduce(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18, long c19, long c20, long c21, long c22, long c23, long c24, long c25, long c26, long c27, long c28, long c29, long c30, long c31, long c32, long c33, long c34, long c35, long c36) {
        long c37 = 0L;
        long t0 = c0 + 0x8000000L >> 28;
        c0 -= t0 << 28;
        c1 += t0;
        t0 = c1 + 0x8000000L >> 28;
        c1 -= t0 << 28;
        c2 += t0;
        t0 = c2 + 0x8000000L >> 28;
        c2 -= t0 << 28;
        c3 += t0;
        t0 = c3 + 0x8000000L >> 28;
        c3 -= t0 << 28;
        c4 += t0;
        t0 = c4 + 0x8000000L >> 28;
        c4 -= t0 << 28;
        c5 += t0;
        t0 = c5 + 0x8000000L >> 28;
        c5 -= t0 << 28;
        c6 += t0;
        t0 = c6 + 0x8000000L >> 28;
        c6 -= t0 << 28;
        c7 += t0;
        t0 = c7 + 0x8000000L >> 28;
        c7 -= t0 << 28;
        c8 += t0;
        t0 = c8 + 0x8000000L >> 28;
        c8 -= t0 << 28;
        c9 += t0;
        t0 = c9 + 0x8000000L >> 28;
        c9 -= t0 << 28;
        c10 += t0;
        t0 = c10 + 0x8000000L >> 28;
        c10 -= t0 << 28;
        c11 += t0;
        t0 = c11 + 0x8000000L >> 28;
        c11 -= t0 << 28;
        c12 += t0;
        t0 = c12 + 0x8000000L >> 28;
        c12 -= t0 << 28;
        c13 += t0;
        t0 = c13 + 0x8000000L >> 28;
        c13 -= t0 << 28;
        c14 += t0;
        t0 = c14 + 0x8000000L >> 28;
        c14 -= t0 << 28;
        c15 += t0;
        t0 = c15 + 0x8000000L >> 28;
        c15 -= t0 << 28;
        c16 += t0;
        t0 = c16 + 0x8000000L >> 28;
        c16 -= t0 << 28;
        c17 += t0;
        t0 = c17 + 0x8000000L >> 28;
        c17 -= t0 << 28;
        c18 += t0;
        t0 = c18 + 0x8000000L >> 28;
        c18 -= t0 << 28;
        c19 += t0;
        t0 = c19 + 0x8000000L >> 28;
        c19 -= t0 << 28;
        c20 += t0;
        t0 = c20 + 0x8000000L >> 28;
        c20 -= t0 << 28;
        c21 += t0;
        t0 = c21 + 0x8000000L >> 28;
        c21 -= t0 << 28;
        c22 += t0;
        t0 = c22 + 0x8000000L >> 28;
        c22 -= t0 << 28;
        c23 += t0;
        t0 = c23 + 0x8000000L >> 28;
        c23 -= t0 << 28;
        c24 += t0;
        t0 = c24 + 0x8000000L >> 28;
        c24 -= t0 << 28;
        c25 += t0;
        t0 = c25 + 0x8000000L >> 28;
        c25 -= t0 << 28;
        c26 += t0;
        t0 = c26 + 0x8000000L >> 28;
        c26 -= t0 << 28;
        c27 += t0;
        t0 = c27 + 0x8000000L >> 28;
        c27 -= t0 << 28;
        c28 += t0;
        t0 = c28 + 0x8000000L >> 28;
        c28 -= t0 << 28;
        c29 += t0;
        t0 = c29 + 0x8000000L >> 28;
        c29 -= t0 << 28;
        c30 += t0;
        t0 = c30 + 0x8000000L >> 28;
        c30 -= t0 << 28;
        c31 += t0;
        t0 = c31 + 0x8000000L >> 28;
        c31 -= t0 << 28;
        c32 += t0;
        t0 = c32 + 0x8000000L >> 28;
        c32 -= t0 << 28;
        c33 += t0;
        t0 = c33 + 0x8000000L >> 28;
        c33 -= t0 << 28;
        c34 += t0;
        t0 = c34 + 0x8000000L >> 28;
        c34 -= t0 << 28;
        c35 += t0;
        t0 = c35 + 0x8000000L >> 28;
        c35 -= t0 << 28;
        c36 += t0;
        t0 = c36 + 0x8000000L >> 28;
        this.carryReduce0(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30, c31, c32, c33, c34, c35, c36 -= t0 << 28, c37 += t0);
    }

    void carryReduce0(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18, long c19, long c20, long c21, long c22, long c23, long c24, long c25, long c26, long c27, long c28, long c29, long c30, long c31, long c32, long c33, long c34, long c35, long c36, long c37) {
        long t0 = -20472841L * c37;
        c18 += t0 << 11 & 0xFFFFFFFL;
        c19 += t0 >> 17;
        t0 = -117141993L * c37;
        c19 += t0 << 11 & 0xFFFFFFFL;
        c20 += t0 >> 17;
        t0 = 62411077L * c37;
        c20 += t0 << 11 & 0xFFFFFFFL;
        c21 += t0 >> 17;
        t0 = 56915814L * c37;
        c21 += t0 << 11 & 0xFFFFFFFL;
        c22 += t0 >> 17;
        t0 = -97532854L * c37;
        c22 += t0 << 11 & 0xFFFFFFFL;
        c23 += t0 >> 17;
        t0 = -76509338L * c37;
        c23 += t0 << 11 & 0xFFFFFFFL;
        c24 += t0 >> 17;
        t0 = 75510783L * c37;
        c24 += t0 << 11 & 0xFFFFFFFL;
        c25 += t0 >> 17;
        t0 = 67962521L * c37;
        c25 += t0 << 11 & 0xFFFFFFFL;
        c26 += t0 >> 17;
        t0 = -25593732L * c37;
        c26 += t0 << 11 & 0xFFFFFFFL;
        c27 += t0 >> 17;
        t0 = 91L * c37;
        c27 += t0 << 11 & 0xFFFFFFFL;
        c28 += t0 >> 17;
        t0 = -20472841L * c36;
        c17 += t0 << 11 & 0xFFFFFFFL;
        c18 += t0 >> 17;
        t0 = -117141993L * c36;
        c18 += t0 << 11 & 0xFFFFFFFL;
        c19 += t0 >> 17;
        t0 = 62411077L * c36;
        c19 += t0 << 11 & 0xFFFFFFFL;
        c20 += t0 >> 17;
        t0 = 56915814L * c36;
        c20 += t0 << 11 & 0xFFFFFFFL;
        c21 += t0 >> 17;
        t0 = -97532854L * c36;
        c21 += t0 << 11 & 0xFFFFFFFL;
        c22 += t0 >> 17;
        t0 = -76509338L * c36;
        c22 += t0 << 11 & 0xFFFFFFFL;
        c23 += t0 >> 17;
        t0 = 75510783L * c36;
        c23 += t0 << 11 & 0xFFFFFFFL;
        c24 += t0 >> 17;
        t0 = 67962521L * c36;
        c24 += t0 << 11 & 0xFFFFFFFL;
        c25 += t0 >> 17;
        t0 = -25593732L * c36;
        c25 += t0 << 11 & 0xFFFFFFFL;
        c26 += t0 >> 17;
        t0 = 91L * c36;
        c26 += t0 << 11 & 0xFFFFFFFL;
        c27 += t0 >> 17;
        t0 = -20472841L * c35;
        c16 += t0 << 11 & 0xFFFFFFFL;
        c17 += t0 >> 17;
        t0 = -117141993L * c35;
        c17 += t0 << 11 & 0xFFFFFFFL;
        c18 += t0 >> 17;
        t0 = 62411077L * c35;
        c18 += t0 << 11 & 0xFFFFFFFL;
        c19 += t0 >> 17;
        t0 = 56915814L * c35;
        c19 += t0 << 11 & 0xFFFFFFFL;
        c20 += t0 >> 17;
        t0 = -97532854L * c35;
        c20 += t0 << 11 & 0xFFFFFFFL;
        c21 += t0 >> 17;
        t0 = -76509338L * c35;
        c21 += t0 << 11 & 0xFFFFFFFL;
        c22 += t0 >> 17;
        t0 = 75510783L * c35;
        c22 += t0 << 11 & 0xFFFFFFFL;
        c23 += t0 >> 17;
        t0 = 67962521L * c35;
        c23 += t0 << 11 & 0xFFFFFFFL;
        c24 += t0 >> 17;
        t0 = -25593732L * c35;
        c24 += t0 << 11 & 0xFFFFFFFL;
        c25 += t0 >> 17;
        t0 = 91L * c35;
        c25 += t0 << 11 & 0xFFFFFFFL;
        c26 += t0 >> 17;
        t0 = -20472841L * c34;
        c15 += t0 << 11 & 0xFFFFFFFL;
        c16 += t0 >> 17;
        t0 = -117141993L * c34;
        c16 += t0 << 11 & 0xFFFFFFFL;
        c17 += t0 >> 17;
        t0 = 62411077L * c34;
        c17 += t0 << 11 & 0xFFFFFFFL;
        c18 += t0 >> 17;
        t0 = 56915814L * c34;
        c18 += t0 << 11 & 0xFFFFFFFL;
        c19 += t0 >> 17;
        t0 = -97532854L * c34;
        c19 += t0 << 11 & 0xFFFFFFFL;
        c20 += t0 >> 17;
        t0 = -76509338L * c34;
        c20 += t0 << 11 & 0xFFFFFFFL;
        c21 += t0 >> 17;
        t0 = 75510783L * c34;
        c21 += t0 << 11 & 0xFFFFFFFL;
        c22 += t0 >> 17;
        t0 = 67962521L * c34;
        c22 += t0 << 11 & 0xFFFFFFFL;
        c23 += t0 >> 17;
        t0 = -25593732L * c34;
        c23 += t0 << 11 & 0xFFFFFFFL;
        c24 += t0 >> 17;
        t0 = 91L * c34;
        c24 += t0 << 11 & 0xFFFFFFFL;
        c25 += t0 >> 17;
        t0 = -20472841L * c33;
        c14 += t0 << 11 & 0xFFFFFFFL;
        c15 += t0 >> 17;
        t0 = -117141993L * c33;
        c15 += t0 << 11 & 0xFFFFFFFL;
        c16 += t0 >> 17;
        t0 = 62411077L * c33;
        c16 += t0 << 11 & 0xFFFFFFFL;
        c17 += t0 >> 17;
        t0 = 56915814L * c33;
        c17 += t0 << 11 & 0xFFFFFFFL;
        c18 += t0 >> 17;
        t0 = -97532854L * c33;
        c18 += t0 << 11 & 0xFFFFFFFL;
        c19 += t0 >> 17;
        t0 = -76509338L * c33;
        c19 += t0 << 11 & 0xFFFFFFFL;
        c20 += t0 >> 17;
        t0 = 75510783L * c33;
        c20 += t0 << 11 & 0xFFFFFFFL;
        c21 += t0 >> 17;
        t0 = 67962521L * c33;
        c21 += t0 << 11 & 0xFFFFFFFL;
        c22 += t0 >> 17;
        t0 = -25593732L * c33;
        c22 += t0 << 11 & 0xFFFFFFFL;
        c23 += t0 >> 17;
        t0 = 91L * c33;
        c23 += t0 << 11 & 0xFFFFFFFL;
        c24 += t0 >> 17;
        t0 = -20472841L * c32;
        c13 += t0 << 11 & 0xFFFFFFFL;
        c14 += t0 >> 17;
        t0 = -117141993L * c32;
        c14 += t0 << 11 & 0xFFFFFFFL;
        c15 += t0 >> 17;
        t0 = 62411077L * c32;
        c15 += t0 << 11 & 0xFFFFFFFL;
        c16 += t0 >> 17;
        t0 = 56915814L * c32;
        c16 += t0 << 11 & 0xFFFFFFFL;
        c17 += t0 >> 17;
        t0 = -97532854L * c32;
        c17 += t0 << 11 & 0xFFFFFFFL;
        c18 += t0 >> 17;
        t0 = -76509338L * c32;
        c18 += t0 << 11 & 0xFFFFFFFL;
        c19 += t0 >> 17;
        t0 = 75510783L * c32;
        c19 += t0 << 11 & 0xFFFFFFFL;
        c20 += t0 >> 17;
        t0 = 67962521L * c32;
        c20 += t0 << 11 & 0xFFFFFFFL;
        c21 += t0 >> 17;
        t0 = -25593732L * c32;
        c21 += t0 << 11 & 0xFFFFFFFL;
        c22 += t0 >> 17;
        t0 = 91L * c32;
        c22 += t0 << 11 & 0xFFFFFFFL;
        c23 += t0 >> 17;
        t0 = -20472841L * c31;
        c12 += t0 << 11 & 0xFFFFFFFL;
        c13 += t0 >> 17;
        t0 = -117141993L * c31;
        c13 += t0 << 11 & 0xFFFFFFFL;
        c14 += t0 >> 17;
        t0 = 62411077L * c31;
        c14 += t0 << 11 & 0xFFFFFFFL;
        c15 += t0 >> 17;
        t0 = 56915814L * c31;
        c15 += t0 << 11 & 0xFFFFFFFL;
        c16 += t0 >> 17;
        t0 = -97532854L * c31;
        c16 += t0 << 11 & 0xFFFFFFFL;
        c17 += t0 >> 17;
        t0 = -76509338L * c31;
        c17 += t0 << 11 & 0xFFFFFFFL;
        c18 += t0 >> 17;
        t0 = 75510783L * c31;
        c18 += t0 << 11 & 0xFFFFFFFL;
        c19 += t0 >> 17;
        t0 = 67962521L * c31;
        c19 += t0 << 11 & 0xFFFFFFFL;
        c20 += t0 >> 17;
        t0 = -25593732L * c31;
        c20 += t0 << 11 & 0xFFFFFFFL;
        c21 += t0 >> 17;
        t0 = 91L * c31;
        c21 += t0 << 11 & 0xFFFFFFFL;
        c22 += t0 >> 17;
        t0 = -20472841L * c30;
        c11 += t0 << 11 & 0xFFFFFFFL;
        c12 += t0 >> 17;
        t0 = -117141993L * c30;
        c12 += t0 << 11 & 0xFFFFFFFL;
        c13 += t0 >> 17;
        t0 = 62411077L * c30;
        c13 += t0 << 11 & 0xFFFFFFFL;
        c14 += t0 >> 17;
        t0 = 56915814L * c30;
        c14 += t0 << 11 & 0xFFFFFFFL;
        c15 += t0 >> 17;
        t0 = -97532854L * c30;
        c15 += t0 << 11 & 0xFFFFFFFL;
        c16 += t0 >> 17;
        t0 = -76509338L * c30;
        c16 += t0 << 11 & 0xFFFFFFFL;
        c17 += t0 >> 17;
        t0 = 75510783L * c30;
        c17 += t0 << 11 & 0xFFFFFFFL;
        c18 += t0 >> 17;
        t0 = 67962521L * c30;
        c18 += t0 << 11 & 0xFFFFFFFL;
        c19 += t0 >> 17;
        t0 = -25593732L * c30;
        c19 += t0 << 11 & 0xFFFFFFFL;
        c20 += t0 >> 17;
        t0 = 91L * c30;
        c20 += t0 << 11 & 0xFFFFFFFL;
        c21 += t0 >> 17;
        t0 = -20472841L * c29;
        c10 += t0 << 11 & 0xFFFFFFFL;
        c11 += t0 >> 17;
        t0 = -117141993L * c29;
        c11 += t0 << 11 & 0xFFFFFFFL;
        c12 += t0 >> 17;
        t0 = 62411077L * c29;
        c12 += t0 << 11 & 0xFFFFFFFL;
        c13 += t0 >> 17;
        t0 = 56915814L * c29;
        c13 += t0 << 11 & 0xFFFFFFFL;
        c14 += t0 >> 17;
        t0 = -97532854L * c29;
        c14 += t0 << 11 & 0xFFFFFFFL;
        c15 += t0 >> 17;
        t0 = -76509338L * c29;
        c15 += t0 << 11 & 0xFFFFFFFL;
        c16 += t0 >> 17;
        t0 = 75510783L * c29;
        c16 += t0 << 11 & 0xFFFFFFFL;
        c17 += t0 >> 17;
        t0 = 67962521L * c29;
        c17 += t0 << 11 & 0xFFFFFFFL;
        c18 += t0 >> 17;
        t0 = -25593732L * c29;
        c18 += t0 << 11 & 0xFFFFFFFL;
        c19 += t0 >> 17;
        t0 = 91L * c29;
        c19 += t0 << 11 & 0xFFFFFFFL;
        c20 += t0 >> 17;
        t0 = -20472841L * c28;
        c9 += t0 << 11 & 0xFFFFFFFL;
        c10 += t0 >> 17;
        t0 = -117141993L * c28;
        c10 += t0 << 11 & 0xFFFFFFFL;
        c11 += t0 >> 17;
        t0 = 62411077L * c28;
        c11 += t0 << 11 & 0xFFFFFFFL;
        c12 += t0 >> 17;
        t0 = 56915814L * c28;
        c12 += t0 << 11 & 0xFFFFFFFL;
        c13 += t0 >> 17;
        t0 = -97532854L * c28;
        c13 += t0 << 11 & 0xFFFFFFFL;
        c14 += t0 >> 17;
        t0 = -76509338L * c28;
        c14 += t0 << 11 & 0xFFFFFFFL;
        c15 += t0 >> 17;
        t0 = 75510783L * c28;
        c15 += t0 << 11 & 0xFFFFFFFL;
        c16 += t0 >> 17;
        t0 = 67962521L * c28;
        c16 += t0 << 11 & 0xFFFFFFFL;
        c17 += t0 >> 17;
        t0 = -25593732L * c28;
        c17 += t0 << 11 & 0xFFFFFFFL;
        c18 += t0 >> 17;
        t0 = 91L * c28;
        this.carryReduce1(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18 += t0 << 11 & 0xFFFFFFFL, c19 += t0 >> 17, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30, c31, c32, c33, c34, c35, c36, c37);
    }

    void carryReduce1(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18, long c19, long c20, long c21, long c22, long c23, long c24, long c25, long c26, long c27, long c28, long c29, long c30, long c31, long c32, long c33, long c34, long c35, long c36, long c37) {
        long t0 = c19 + 0x8000000L >> 28;
        c19 -= t0 << 28;
        c20 += t0;
        t0 = c20 + 0x8000000L >> 28;
        c20 -= t0 << 28;
        c21 += t0;
        t0 = c21 + 0x8000000L >> 28;
        c21 -= t0 << 28;
        c22 += t0;
        t0 = c22 + 0x8000000L >> 28;
        c22 -= t0 << 28;
        c23 += t0;
        t0 = c23 + 0x8000000L >> 28;
        c23 -= t0 << 28;
        c24 += t0;
        t0 = c24 + 0x8000000L >> 28;
        c24 -= t0 << 28;
        c25 += t0;
        t0 = c25 + 0x8000000L >> 28;
        c25 -= t0 << 28;
        c26 += t0;
        t0 = c26 + 0x8000000L >> 28;
        c26 -= t0 << 28;
        c27 += t0;
        t0 = -20472841L * c27;
        c8 += t0 << 11 & 0xFFFFFFFL;
        c9 += t0 >> 17;
        t0 = -117141993L * c27;
        c9 += t0 << 11 & 0xFFFFFFFL;
        c10 += t0 >> 17;
        t0 = 62411077L * c27;
        c10 += t0 << 11 & 0xFFFFFFFL;
        c11 += t0 >> 17;
        t0 = 56915814L * c27;
        c11 += t0 << 11 & 0xFFFFFFFL;
        c12 += t0 >> 17;
        t0 = -97532854L * c27;
        c12 += t0 << 11 & 0xFFFFFFFL;
        c13 += t0 >> 17;
        t0 = -76509338L * c27;
        c13 += t0 << 11 & 0xFFFFFFFL;
        c14 += t0 >> 17;
        t0 = 75510783L * c27;
        c14 += t0 << 11 & 0xFFFFFFFL;
        c15 += t0 >> 17;
        t0 = 67962521L * c27;
        c15 += t0 << 11 & 0xFFFFFFFL;
        c16 += t0 >> 17;
        t0 = -25593732L * c27;
        c16 += t0 << 11 & 0xFFFFFFFL;
        c17 += t0 >> 17;
        t0 = 91L * c27;
        c17 += t0 << 11 & 0xFFFFFFFL;
        c18 += t0 >> 17;
        t0 = -20472841L * c26;
        c7 += t0 << 11 & 0xFFFFFFFL;
        c8 += t0 >> 17;
        t0 = -117141993L * c26;
        c8 += t0 << 11 & 0xFFFFFFFL;
        c9 += t0 >> 17;
        t0 = 62411077L * c26;
        c9 += t0 << 11 & 0xFFFFFFFL;
        c10 += t0 >> 17;
        t0 = 56915814L * c26;
        c10 += t0 << 11 & 0xFFFFFFFL;
        c11 += t0 >> 17;
        t0 = -97532854L * c26;
        c11 += t0 << 11 & 0xFFFFFFFL;
        c12 += t0 >> 17;
        t0 = -76509338L * c26;
        c12 += t0 << 11 & 0xFFFFFFFL;
        c13 += t0 >> 17;
        t0 = 75510783L * c26;
        c13 += t0 << 11 & 0xFFFFFFFL;
        c14 += t0 >> 17;
        t0 = 67962521L * c26;
        c14 += t0 << 11 & 0xFFFFFFFL;
        c15 += t0 >> 17;
        t0 = -25593732L * c26;
        c15 += t0 << 11 & 0xFFFFFFFL;
        c16 += t0 >> 17;
        t0 = 91L * c26;
        c16 += t0 << 11 & 0xFFFFFFFL;
        c17 += t0 >> 17;
        t0 = -20472841L * c25;
        c6 += t0 << 11 & 0xFFFFFFFL;
        c7 += t0 >> 17;
        t0 = -117141993L * c25;
        c7 += t0 << 11 & 0xFFFFFFFL;
        c8 += t0 >> 17;
        t0 = 62411077L * c25;
        c8 += t0 << 11 & 0xFFFFFFFL;
        c9 += t0 >> 17;
        t0 = 56915814L * c25;
        c9 += t0 << 11 & 0xFFFFFFFL;
        c10 += t0 >> 17;
        t0 = -97532854L * c25;
        c10 += t0 << 11 & 0xFFFFFFFL;
        c11 += t0 >> 17;
        t0 = -76509338L * c25;
        c11 += t0 << 11 & 0xFFFFFFFL;
        c12 += t0 >> 17;
        t0 = 75510783L * c25;
        c12 += t0 << 11 & 0xFFFFFFFL;
        c13 += t0 >> 17;
        t0 = 67962521L * c25;
        c13 += t0 << 11 & 0xFFFFFFFL;
        c14 += t0 >> 17;
        t0 = -25593732L * c25;
        c14 += t0 << 11 & 0xFFFFFFFL;
        c15 += t0 >> 17;
        t0 = 91L * c25;
        c15 += t0 << 11 & 0xFFFFFFFL;
        c16 += t0 >> 17;
        t0 = -20472841L * c24;
        c5 += t0 << 11 & 0xFFFFFFFL;
        c6 += t0 >> 17;
        t0 = -117141993L * c24;
        c6 += t0 << 11 & 0xFFFFFFFL;
        c7 += t0 >> 17;
        t0 = 62411077L * c24;
        c7 += t0 << 11 & 0xFFFFFFFL;
        c8 += t0 >> 17;
        t0 = 56915814L * c24;
        c8 += t0 << 11 & 0xFFFFFFFL;
        c9 += t0 >> 17;
        t0 = -97532854L * c24;
        c9 += t0 << 11 & 0xFFFFFFFL;
        c10 += t0 >> 17;
        t0 = -76509338L * c24;
        c10 += t0 << 11 & 0xFFFFFFFL;
        c11 += t0 >> 17;
        t0 = 75510783L * c24;
        c11 += t0 << 11 & 0xFFFFFFFL;
        c12 += t0 >> 17;
        t0 = 67962521L * c24;
        c12 += t0 << 11 & 0xFFFFFFFL;
        c13 += t0 >> 17;
        t0 = -25593732L * c24;
        c13 += t0 << 11 & 0xFFFFFFFL;
        c14 += t0 >> 17;
        t0 = 91L * c24;
        c14 += t0 << 11 & 0xFFFFFFFL;
        c15 += t0 >> 17;
        t0 = -20472841L * c23;
        c4 += t0 << 11 & 0xFFFFFFFL;
        c5 += t0 >> 17;
        t0 = -117141993L * c23;
        c5 += t0 << 11 & 0xFFFFFFFL;
        c6 += t0 >> 17;
        t0 = 62411077L * c23;
        c6 += t0 << 11 & 0xFFFFFFFL;
        c7 += t0 >> 17;
        t0 = 56915814L * c23;
        c7 += t0 << 11 & 0xFFFFFFFL;
        c8 += t0 >> 17;
        t0 = -97532854L * c23;
        c8 += t0 << 11 & 0xFFFFFFFL;
        c9 += t0 >> 17;
        t0 = -76509338L * c23;
        c9 += t0 << 11 & 0xFFFFFFFL;
        c10 += t0 >> 17;
        t0 = 75510783L * c23;
        c10 += t0 << 11 & 0xFFFFFFFL;
        c11 += t0 >> 17;
        t0 = 67962521L * c23;
        c11 += t0 << 11 & 0xFFFFFFFL;
        c12 += t0 >> 17;
        t0 = -25593732L * c23;
        c12 += t0 << 11 & 0xFFFFFFFL;
        c13 += t0 >> 17;
        t0 = 91L * c23;
        c13 += t0 << 11 & 0xFFFFFFFL;
        c14 += t0 >> 17;
        t0 = -20472841L * c22;
        c3 += t0 << 11 & 0xFFFFFFFL;
        c4 += t0 >> 17;
        t0 = -117141993L * c22;
        c4 += t0 << 11 & 0xFFFFFFFL;
        c5 += t0 >> 17;
        t0 = 62411077L * c22;
        c5 += t0 << 11 & 0xFFFFFFFL;
        c6 += t0 >> 17;
        t0 = 56915814L * c22;
        c6 += t0 << 11 & 0xFFFFFFFL;
        c7 += t0 >> 17;
        t0 = -97532854L * c22;
        c7 += t0 << 11 & 0xFFFFFFFL;
        c8 += t0 >> 17;
        t0 = -76509338L * c22;
        c8 += t0 << 11 & 0xFFFFFFFL;
        c9 += t0 >> 17;
        t0 = 75510783L * c22;
        c9 += t0 << 11 & 0xFFFFFFFL;
        c10 += t0 >> 17;
        t0 = 67962521L * c22;
        c10 += t0 << 11 & 0xFFFFFFFL;
        c11 += t0 >> 17;
        t0 = -25593732L * c22;
        c11 += t0 << 11 & 0xFFFFFFFL;
        c12 += t0 >> 17;
        t0 = 91L * c22;
        c12 += t0 << 11 & 0xFFFFFFFL;
        c13 += t0 >> 17;
        t0 = -20472841L * c21;
        c2 += t0 << 11 & 0xFFFFFFFL;
        c3 += t0 >> 17;
        t0 = -117141993L * c21;
        c3 += t0 << 11 & 0xFFFFFFFL;
        c4 += t0 >> 17;
        t0 = 62411077L * c21;
        c4 += t0 << 11 & 0xFFFFFFFL;
        c5 += t0 >> 17;
        t0 = 56915814L * c21;
        c5 += t0 << 11 & 0xFFFFFFFL;
        c6 += t0 >> 17;
        t0 = -97532854L * c21;
        c6 += t0 << 11 & 0xFFFFFFFL;
        c7 += t0 >> 17;
        t0 = -76509338L * c21;
        c7 += t0 << 11 & 0xFFFFFFFL;
        c8 += t0 >> 17;
        t0 = 75510783L * c21;
        c8 += t0 << 11 & 0xFFFFFFFL;
        c9 += t0 >> 17;
        t0 = 67962521L * c21;
        c9 += t0 << 11 & 0xFFFFFFFL;
        c10 += t0 >> 17;
        t0 = -25593732L * c21;
        c10 += t0 << 11 & 0xFFFFFFFL;
        c11 += t0 >> 17;
        t0 = 91L * c21;
        c11 += t0 << 11 & 0xFFFFFFFL;
        c12 += t0 >> 17;
        t0 = -20472841L * c20;
        c1 += t0 << 11 & 0xFFFFFFFL;
        c2 += t0 >> 17;
        t0 = -117141993L * c20;
        c2 += t0 << 11 & 0xFFFFFFFL;
        c3 += t0 >> 17;
        t0 = 62411077L * c20;
        c3 += t0 << 11 & 0xFFFFFFFL;
        c4 += t0 >> 17;
        t0 = 56915814L * c20;
        c4 += t0 << 11 & 0xFFFFFFFL;
        c5 += t0 >> 17;
        t0 = -97532854L * c20;
        c5 += t0 << 11 & 0xFFFFFFFL;
        c6 += t0 >> 17;
        t0 = -76509338L * c20;
        c6 += t0 << 11 & 0xFFFFFFFL;
        c7 += t0 >> 17;
        t0 = 75510783L * c20;
        c7 += t0 << 11 & 0xFFFFFFFL;
        c8 += t0 >> 17;
        t0 = 67962521L * c20;
        c8 += t0 << 11 & 0xFFFFFFFL;
        c9 += t0 >> 17;
        t0 = -25593732L * c20;
        c9 += t0 << 11 & 0xFFFFFFFL;
        c10 += t0 >> 17;
        t0 = 91L * c20;
        c10 += t0 << 11 & 0xFFFFFFFL;
        c11 += t0 >> 17;
        t0 = -20472841L * c19;
        c0 += t0 << 11 & 0xFFFFFFFL;
        c1 += t0 >> 17;
        t0 = -117141993L * c19;
        c1 += t0 << 11 & 0xFFFFFFFL;
        c2 += t0 >> 17;
        t0 = 62411077L * c19;
        c2 += t0 << 11 & 0xFFFFFFFL;
        c3 += t0 >> 17;
        t0 = 56915814L * c19;
        c3 += t0 << 11 & 0xFFFFFFFL;
        c4 += t0 >> 17;
        t0 = -97532854L * c19;
        c4 += t0 << 11 & 0xFFFFFFFL;
        c5 += t0 >> 17;
        t0 = -76509338L * c19;
        c5 += t0 << 11 & 0xFFFFFFFL;
        c6 += t0 >> 17;
        t0 = 75510783L * c19;
        c6 += t0 << 11 & 0xFFFFFFFL;
        c7 += t0 >> 17;
        t0 = 67962521L * c19;
        c7 += t0 << 11 & 0xFFFFFFFL;
        c8 += t0 >> 17;
        t0 = -25593732L * c19;
        c8 += t0 << 11 & 0xFFFFFFFL;
        c9 += t0 >> 17;
        t0 = 91L * c19;
        c19 = 0L;
        this.carryReduce2(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9 += t0 << 11 & 0xFFFFFFFL, c10 += t0 >> 17, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30, c31, c32, c33, c34, c35, c36, c37);
    }

    void carryReduce2(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18, long c19, long c20, long c21, long c22, long c23, long c24, long c25, long c26, long c27, long c28, long c29, long c30, long c31, long c32, long c33, long c34, long c35, long c36, long c37) {
        long t0 = c0 + 0x8000000L >> 28;
        c0 -= t0 << 28;
        c1 += t0;
        t0 = c1 + 0x8000000L >> 28;
        c1 -= t0 << 28;
        c2 += t0;
        t0 = c2 + 0x8000000L >> 28;
        c2 -= t0 << 28;
        c3 += t0;
        t0 = c3 + 0x8000000L >> 28;
        c3 -= t0 << 28;
        c4 += t0;
        t0 = c4 + 0x8000000L >> 28;
        c4 -= t0 << 28;
        c5 += t0;
        t0 = c5 + 0x8000000L >> 28;
        c5 -= t0 << 28;
        c6 += t0;
        t0 = c6 + 0x8000000L >> 28;
        c6 -= t0 << 28;
        c7 += t0;
        t0 = c7 + 0x8000000L >> 28;
        c7 -= t0 << 28;
        c8 += t0;
        t0 = c8 + 0x8000000L >> 28;
        c8 -= t0 << 28;
        c9 += t0;
        t0 = c9 + 0x8000000L >> 28;
        c9 -= t0 << 28;
        c10 += t0;
        t0 = c10 + 0x8000000L >> 28;
        c10 -= t0 << 28;
        c11 += t0;
        t0 = c11 + 0x8000000L >> 28;
        c11 -= t0 << 28;
        c12 += t0;
        t0 = c12 + 0x8000000L >> 28;
        c12 -= t0 << 28;
        c13 += t0;
        t0 = c13 + 0x8000000L >> 28;
        c13 -= t0 << 28;
        c14 += t0;
        t0 = c14 + 0x8000000L >> 28;
        c14 -= t0 << 28;
        c15 += t0;
        t0 = c15 + 0x8000000L >> 28;
        c15 -= t0 << 28;
        c16 += t0;
        t0 = c16 + 0x8000000L >> 28;
        c16 -= t0 << 28;
        c17 += t0;
        t0 = c17 + 0x8000000L >> 28;
        c17 -= t0 << 28;
        c18 += t0;
        t0 = c18 + 0x8000000L >> 28;
        this.carryReduce3(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18 -= t0 << 28, c19 += t0, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30, c31, c32, c33, c34, c35, c36, c37);
    }

    void carryReduce3(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18, long c19, long c20, long c21, long c22, long c23, long c24, long c25, long c26, long c27, long c28, long c29, long c30, long c31, long c32, long c33, long c34, long c35, long c36, long c37) {
        long t0 = -20472841L * c19;
        c0 += t0 << 11 & 0xFFFFFFFL;
        c1 += t0 >> 17;
        t0 = -117141993L * c19;
        c1 += t0 << 11 & 0xFFFFFFFL;
        c2 += t0 >> 17;
        t0 = 62411077L * c19;
        c2 += t0 << 11 & 0xFFFFFFFL;
        c3 += t0 >> 17;
        t0 = 56915814L * c19;
        c3 += t0 << 11 & 0xFFFFFFFL;
        c4 += t0 >> 17;
        t0 = -97532854L * c19;
        c4 += t0 << 11 & 0xFFFFFFFL;
        c5 += t0 >> 17;
        t0 = -76509338L * c19;
        c5 += t0 << 11 & 0xFFFFFFFL;
        c6 += t0 >> 17;
        t0 = 75510783L * c19;
        c6 += t0 << 11 & 0xFFFFFFFL;
        c7 += t0 >> 17;
        t0 = 67962521L * c19;
        c7 += t0 << 11 & 0xFFFFFFFL;
        c8 += t0 >> 17;
        t0 = -25593732L * c19;
        c8 += t0 << 11 & 0xFFFFFFFL;
        c9 += t0 >> 17;
        t0 = 91L * c19;
        c9 += t0 << 11 & 0xFFFFFFFL;
        c10 += t0 >> 17;
        t0 = c0 + 0x8000000L >> 28;
        c0 -= t0 << 28;
        c1 += t0;
        t0 = c1 + 0x8000000L >> 28;
        c1 -= t0 << 28;
        c2 += t0;
        t0 = c2 + 0x8000000L >> 28;
        c2 -= t0 << 28;
        c3 += t0;
        t0 = c3 + 0x8000000L >> 28;
        c3 -= t0 << 28;
        c4 += t0;
        t0 = c4 + 0x8000000L >> 28;
        c4 -= t0 << 28;
        c5 += t0;
        t0 = c5 + 0x8000000L >> 28;
        c5 -= t0 << 28;
        c6 += t0;
        t0 = c6 + 0x8000000L >> 28;
        c6 -= t0 << 28;
        c7 += t0;
        t0 = c7 + 0x8000000L >> 28;
        c7 -= t0 << 28;
        c8 += t0;
        t0 = c8 + 0x8000000L >> 28;
        c8 -= t0 << 28;
        c9 += t0;
        t0 = c9 + 0x8000000L >> 28;
        c9 -= t0 << 28;
        c10 += t0;
        t0 = c10 + 0x8000000L >> 28;
        c10 -= t0 << 28;
        c11 += t0;
        t0 = c11 + 0x8000000L >> 28;
        c11 -= t0 << 28;
        c12 += t0;
        t0 = c12 + 0x8000000L >> 28;
        c12 -= t0 << 28;
        c13 += t0;
        t0 = c13 + 0x8000000L >> 28;
        c13 -= t0 << 28;
        c14 += t0;
        t0 = c14 + 0x8000000L >> 28;
        c14 -= t0 << 28;
        c15 += t0;
        t0 = c15 + 0x8000000L >> 28;
        c15 -= t0 << 28;
        c16 += t0;
        t0 = c16 + 0x8000000L >> 28;
        c16 -= t0 << 28;
        c17 += t0;
        t0 = c17 + 0x8000000L >> 28;
        c17 -= t0 << 28;
        c18 += t0;
        r[0] = c0;
        r[1] = c1;
        r[2] = c2;
        r[3] = c3;
        r[4] = c4;
        r[5] = c5;
        r[6] = c6;
        r[7] = c7;
        r[8] = c8;
        r[9] = c9;
        r[10] = c10;
        r[11] = c11;
        r[12] = c12;
        r[13] = c13;
        r[14] = c14;
        r[15] = c15;
        r[16] = c16;
        r[17] = c17;
        r[18] = c18;
    }

    private void carryReduce(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18) {
        long c19 = 0L;
        long t0 = c0 + 0x8000000L >> 28;
        c0 -= t0 << 28;
        c1 += t0;
        t0 = c1 + 0x8000000L >> 28;
        c1 -= t0 << 28;
        c2 += t0;
        t0 = c2 + 0x8000000L >> 28;
        c2 -= t0 << 28;
        c3 += t0;
        t0 = c3 + 0x8000000L >> 28;
        c3 -= t0 << 28;
        c4 += t0;
        t0 = c4 + 0x8000000L >> 28;
        c4 -= t0 << 28;
        c5 += t0;
        t0 = c5 + 0x8000000L >> 28;
        c5 -= t0 << 28;
        c6 += t0;
        t0 = c6 + 0x8000000L >> 28;
        c6 -= t0 << 28;
        c7 += t0;
        t0 = c7 + 0x8000000L >> 28;
        c7 -= t0 << 28;
        c8 += t0;
        t0 = c8 + 0x8000000L >> 28;
        c8 -= t0 << 28;
        c9 += t0;
        t0 = c9 + 0x8000000L >> 28;
        c9 -= t0 << 28;
        c10 += t0;
        t0 = c10 + 0x8000000L >> 28;
        c10 -= t0 << 28;
        c11 += t0;
        t0 = c11 + 0x8000000L >> 28;
        c11 -= t0 << 28;
        c12 += t0;
        t0 = c12 + 0x8000000L >> 28;
        c12 -= t0 << 28;
        c13 += t0;
        t0 = c13 + 0x8000000L >> 28;
        c13 -= t0 << 28;
        c14 += t0;
        t0 = c14 + 0x8000000L >> 28;
        c14 -= t0 << 28;
        c15 += t0;
        t0 = c15 + 0x8000000L >> 28;
        c15 -= t0 << 28;
        c16 += t0;
        t0 = c16 + 0x8000000L >> 28;
        c16 -= t0 << 28;
        c17 += t0;
        t0 = c17 + 0x8000000L >> 28;
        c17 -= t0 << 28;
        c18 += t0;
        t0 = c18 + 0x8000000L >> 28;
        this.carryReduce0(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18 -= t0 << 28, c19 += t0);
    }

    void carryReduce0(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18, long c19) {
        long t0 = -20472841L * c19;
        c0 += t0 << 11 & 0xFFFFFFFL;
        c1 += t0 >> 17;
        t0 = -117141993L * c19;
        c1 += t0 << 11 & 0xFFFFFFFL;
        c2 += t0 >> 17;
        t0 = 62411077L * c19;
        c2 += t0 << 11 & 0xFFFFFFFL;
        c3 += t0 >> 17;
        t0 = 56915814L * c19;
        c3 += t0 << 11 & 0xFFFFFFFL;
        c4 += t0 >> 17;
        t0 = -97532854L * c19;
        c4 += t0 << 11 & 0xFFFFFFFL;
        c5 += t0 >> 17;
        t0 = -76509338L * c19;
        c5 += t0 << 11 & 0xFFFFFFFL;
        c6 += t0 >> 17;
        t0 = 75510783L * c19;
        c6 += t0 << 11 & 0xFFFFFFFL;
        c7 += t0 >> 17;
        t0 = 67962521L * c19;
        c7 += t0 << 11 & 0xFFFFFFFL;
        c8 += t0 >> 17;
        t0 = -25593732L * c19;
        c8 += t0 << 11 & 0xFFFFFFFL;
        c9 += t0 >> 17;
        t0 = 91L * c19;
        c9 += t0 << 11 & 0xFFFFFFFL;
        c10 += t0 >> 17;
        t0 = c0 + 0x8000000L >> 28;
        c0 -= t0 << 28;
        c1 += t0;
        t0 = c1 + 0x8000000L >> 28;
        c1 -= t0 << 28;
        c2 += t0;
        t0 = c2 + 0x8000000L >> 28;
        c2 -= t0 << 28;
        c3 += t0;
        t0 = c3 + 0x8000000L >> 28;
        c3 -= t0 << 28;
        c4 += t0;
        t0 = c4 + 0x8000000L >> 28;
        c4 -= t0 << 28;
        c5 += t0;
        t0 = c5 + 0x8000000L >> 28;
        c5 -= t0 << 28;
        c6 += t0;
        t0 = c6 + 0x8000000L >> 28;
        c6 -= t0 << 28;
        c7 += t0;
        t0 = c7 + 0x8000000L >> 28;
        c7 -= t0 << 28;
        c8 += t0;
        t0 = c8 + 0x8000000L >> 28;
        c8 -= t0 << 28;
        c9 += t0;
        t0 = c9 + 0x8000000L >> 28;
        c9 -= t0 << 28;
        c10 += t0;
        t0 = c10 + 0x8000000L >> 28;
        c10 -= t0 << 28;
        c11 += t0;
        t0 = c11 + 0x8000000L >> 28;
        c11 -= t0 << 28;
        c12 += t0;
        t0 = c12 + 0x8000000L >> 28;
        c12 -= t0 << 28;
        c13 += t0;
        t0 = c13 + 0x8000000L >> 28;
        c13 -= t0 << 28;
        c14 += t0;
        t0 = c14 + 0x8000000L >> 28;
        c14 -= t0 << 28;
        c15 += t0;
        t0 = c15 + 0x8000000L >> 28;
        c15 -= t0 << 28;
        c16 += t0;
        t0 = c16 + 0x8000000L >> 28;
        c16 -= t0 << 28;
        c17 += t0;
        t0 = c17 + 0x8000000L >> 28;
        c17 -= t0 << 28;
        c18 += t0;
        r[0] = c0;
        r[1] = c1;
        r[2] = c2;
        r[3] = c3;
        r[4] = c4;
        r[5] = c5;
        r[6] = c6;
        r[7] = c7;
        r[8] = c8;
        r[9] = c9;
        r[10] = c10;
        r[11] = c11;
        r[12] = c12;
        r[13] = c13;
        r[14] = c14;
        r[15] = c15;
        r[16] = c16;
        r[17] = c17;
        r[18] = c18;
    }

    @Override
    protected void mult(long[] a, long[] b, long[] r) {
        long c0 = a[0] * b[0];
        long c1 = a[0] * b[1] + a[1] * b[0];
        long c2 = a[0] * b[2] + a[1] * b[1] + a[2] * b[0];
        long c3 = a[0] * b[3] + a[1] * b[2] + a[2] * b[1] + a[3] * b[0];
        long c4 = a[0] * b[4] + a[1] * b[3] + a[2] * b[2] + a[3] * b[1] + a[4] * b[0];
        long c5 = a[0] * b[5] + a[1] * b[4] + a[2] * b[3] + a[3] * b[2] + a[4] * b[1] + a[5] * b[0];
        long c6 = a[0] * b[6] + a[1] * b[5] + a[2] * b[4] + a[3] * b[3] + a[4] * b[2] + a[5] * b[1] + a[6] * b[0];
        long c7 = a[0] * b[7] + a[1] * b[6] + a[2] * b[5] + a[3] * b[4] + a[4] * b[3] + a[5] * b[2] + a[6] * b[1] + a[7] * b[0];
        long c8 = a[0] * b[8] + a[1] * b[7] + a[2] * b[6] + a[3] * b[5] + a[4] * b[4] + a[5] * b[3] + a[6] * b[2] + a[7] * b[1] + a[8] * b[0];
        long c9 = a[0] * b[9] + a[1] * b[8] + a[2] * b[7] + a[3] * b[6] + a[4] * b[5] + a[5] * b[4] + a[6] * b[3] + a[7] * b[2] + a[8] * b[1] + a[9] * b[0];
        long c10 = a[0] * b[10] + a[1] * b[9] + a[2] * b[8] + a[3] * b[7] + a[4] * b[6] + a[5] * b[5] + a[6] * b[4] + a[7] * b[3] + a[8] * b[2] + a[9] * b[1] + a[10] * b[0];
        long c11 = a[0] * b[11] + a[1] * b[10] + a[2] * b[9] + a[3] * b[8] + a[4] * b[7] + a[5] * b[6] + a[6] * b[5] + a[7] * b[4] + a[8] * b[3] + a[9] * b[2] + a[10] * b[1] + a[11] * b[0];
        long c12 = a[0] * b[12] + a[1] * b[11] + a[2] * b[10] + a[3] * b[9] + a[4] * b[8] + a[5] * b[7] + a[6] * b[6] + a[7] * b[5] + a[8] * b[4] + a[9] * b[3] + a[10] * b[2] + a[11] * b[1] + a[12] * b[0];
        long c13 = a[0] * b[13] + a[1] * b[12] + a[2] * b[11] + a[3] * b[10] + a[4] * b[9] + a[5] * b[8] + a[6] * b[7] + a[7] * b[6] + a[8] * b[5] + a[9] * b[4] + a[10] * b[3] + a[11] * b[2] + a[12] * b[1] + a[13] * b[0];
        long c14 = a[0] * b[14] + a[1] * b[13] + a[2] * b[12] + a[3] * b[11] + a[4] * b[10] + a[5] * b[9] + a[6] * b[8] + a[7] * b[7] + a[8] * b[6] + a[9] * b[5] + a[10] * b[4] + a[11] * b[3] + a[12] * b[2] + a[13] * b[1] + a[14] * b[0];
        long c15 = a[0] * b[15] + a[1] * b[14] + a[2] * b[13] + a[3] * b[12] + a[4] * b[11] + a[5] * b[10] + a[6] * b[9] + a[7] * b[8] + a[8] * b[7] + a[9] * b[6] + a[10] * b[5] + a[11] * b[4] + a[12] * b[3] + a[13] * b[2] + a[14] * b[1] + a[15] * b[0];
        long c16 = a[0] * b[16] + a[1] * b[15] + a[2] * b[14] + a[3] * b[13] + a[4] * b[12] + a[5] * b[11] + a[6] * b[10] + a[7] * b[9] + a[8] * b[8] + a[9] * b[7] + a[10] * b[6] + a[11] * b[5] + a[12] * b[4] + a[13] * b[3] + a[14] * b[2] + a[15] * b[1] + a[16] * b[0];
        long c17 = a[0] * b[17] + a[1] * b[16] + a[2] * b[15] + a[3] * b[14] + a[4] * b[13] + a[5] * b[12] + a[6] * b[11] + a[7] * b[10] + a[8] * b[9] + a[9] * b[8] + a[10] * b[7] + a[11] * b[6] + a[12] * b[5] + a[13] * b[4] + a[14] * b[3] + a[15] * b[2] + a[16] * b[1] + a[17] * b[0];
        long c18 = a[0] * b[18] + a[1] * b[17] + a[2] * b[16] + a[3] * b[15] + a[4] * b[14] + a[5] * b[13] + a[6] * b[12] + a[7] * b[11] + a[8] * b[10] + a[9] * b[9] + a[10] * b[8] + a[11] * b[7] + a[12] * b[6] + a[13] * b[5] + a[14] * b[4] + a[15] * b[3] + a[16] * b[2] + a[17] * b[1] + a[18] * b[0];
        long c19 = a[1] * b[18] + a[2] * b[17] + a[3] * b[16] + a[4] * b[15] + a[5] * b[14] + a[6] * b[13] + a[7] * b[12] + a[8] * b[11] + a[9] * b[10] + a[10] * b[9] + a[11] * b[8] + a[12] * b[7] + a[13] * b[6] + a[14] * b[5] + a[15] * b[4] + a[16] * b[3] + a[17] * b[2] + a[18] * b[1];
        long c20 = a[2] * b[18] + a[3] * b[17] + a[4] * b[16] + a[5] * b[15] + a[6] * b[14] + a[7] * b[13] + a[8] * b[12] + a[9] * b[11] + a[10] * b[10] + a[11] * b[9] + a[12] * b[8] + a[13] * b[7] + a[14] * b[6] + a[15] * b[5] + a[16] * b[4] + a[17] * b[3] + a[18] * b[2];
        long c21 = a[3] * b[18] + a[4] * b[17] + a[5] * b[16] + a[6] * b[15] + a[7] * b[14] + a[8] * b[13] + a[9] * b[12] + a[10] * b[11] + a[11] * b[10] + a[12] * b[9] + a[13] * b[8] + a[14] * b[7] + a[15] * b[6] + a[16] * b[5] + a[17] * b[4] + a[18] * b[3];
        long c22 = a[4] * b[18] + a[5] * b[17] + a[6] * b[16] + a[7] * b[15] + a[8] * b[14] + a[9] * b[13] + a[10] * b[12] + a[11] * b[11] + a[12] * b[10] + a[13] * b[9] + a[14] * b[8] + a[15] * b[7] + a[16] * b[6] + a[17] * b[5] + a[18] * b[4];
        long c23 = a[5] * b[18] + a[6] * b[17] + a[7] * b[16] + a[8] * b[15] + a[9] * b[14] + a[10] * b[13] + a[11] * b[12] + a[12] * b[11] + a[13] * b[10] + a[14] * b[9] + a[15] * b[8] + a[16] * b[7] + a[17] * b[6] + a[18] * b[5];
        long c24 = a[6] * b[18] + a[7] * b[17] + a[8] * b[16] + a[9] * b[15] + a[10] * b[14] + a[11] * b[13] + a[12] * b[12] + a[13] * b[11] + a[14] * b[10] + a[15] * b[9] + a[16] * b[8] + a[17] * b[7] + a[18] * b[6];
        long c25 = a[7] * b[18] + a[8] * b[17] + a[9] * b[16] + a[10] * b[15] + a[11] * b[14] + a[12] * b[13] + a[13] * b[12] + a[14] * b[11] + a[15] * b[10] + a[16] * b[9] + a[17] * b[8] + a[18] * b[7];
        long c26 = a[8] * b[18] + a[9] * b[17] + a[10] * b[16] + a[11] * b[15] + a[12] * b[14] + a[13] * b[13] + a[14] * b[12] + a[15] * b[11] + a[16] * b[10] + a[17] * b[9] + a[18] * b[8];
        long c27 = a[9] * b[18] + a[10] * b[17] + a[11] * b[16] + a[12] * b[15] + a[13] * b[14] + a[14] * b[13] + a[15] * b[12] + a[16] * b[11] + a[17] * b[10] + a[18] * b[9];
        long c28 = a[10] * b[18] + a[11] * b[17] + a[12] * b[16] + a[13] * b[15] + a[14] * b[14] + a[15] * b[13] + a[16] * b[12] + a[17] * b[11] + a[18] * b[10];
        long c29 = a[11] * b[18] + a[12] * b[17] + a[13] * b[16] + a[14] * b[15] + a[15] * b[14] + a[16] * b[13] + a[17] * b[12] + a[18] * b[11];
        long c30 = a[12] * b[18] + a[13] * b[17] + a[14] * b[16] + a[15] * b[15] + a[16] * b[14] + a[17] * b[13] + a[18] * b[12];
        long c31 = a[13] * b[18] + a[14] * b[17] + a[15] * b[16] + a[16] * b[15] + a[17] * b[14] + a[18] * b[13];
        long c32 = a[14] * b[18] + a[15] * b[17] + a[16] * b[16] + a[17] * b[15] + a[18] * b[14];
        long c33 = a[15] * b[18] + a[16] * b[17] + a[17] * b[16] + a[18] * b[15];
        long c34 = a[16] * b[18] + a[17] * b[17] + a[18] * b[16];
        long c35 = a[17] * b[18] + a[18] * b[17];
        long c36 = a[18] * b[18];
        this.carryReduce(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30, c31, c32, c33, c34, c35, c36);
    }

    @Override
    protected void reduce(long[] a) {
        this.carryReduce(a, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11], a[12], a[13], a[14], a[15], a[16], a[17], a[18]);
    }

    @Override
    protected void square(long[] a, long[] r) {
        long c0 = a[0] * a[0];
        long c1 = 2L * (a[0] * a[1]);
        long c2 = 2L * (a[0] * a[2]) + a[1] * a[1];
        long c3 = 2L * (a[0] * a[3] + a[1] * a[2]);
        long c4 = 2L * (a[0] * a[4] + a[1] * a[3]) + a[2] * a[2];
        long c5 = 2L * (a[0] * a[5] + a[1] * a[4] + a[2] * a[3]);
        long c6 = 2L * (a[0] * a[6] + a[1] * a[5] + a[2] * a[4]) + a[3] * a[3];
        long c7 = 2L * (a[0] * a[7] + a[1] * a[6] + a[2] * a[5] + a[3] * a[4]);
        long c8 = 2L * (a[0] * a[8] + a[1] * a[7] + a[2] * a[6] + a[3] * a[5]) + a[4] * a[4];
        long c9 = 2L * (a[0] * a[9] + a[1] * a[8] + a[2] * a[7] + a[3] * a[6] + a[4] * a[5]);
        long c10 = 2L * (a[0] * a[10] + a[1] * a[9] + a[2] * a[8] + a[3] * a[7] + a[4] * a[6]) + a[5] * a[5];
        long c11 = 2L * (a[0] * a[11] + a[1] * a[10] + a[2] * a[9] + a[3] * a[8] + a[4] * a[7] + a[5] * a[6]);
        long c12 = 2L * (a[0] * a[12] + a[1] * a[11] + a[2] * a[10] + a[3] * a[9] + a[4] * a[8] + a[5] * a[7]) + a[6] * a[6];
        long c13 = 2L * (a[0] * a[13] + a[1] * a[12] + a[2] * a[11] + a[3] * a[10] + a[4] * a[9] + a[5] * a[8] + a[6] * a[7]);
        long c14 = 2L * (a[0] * a[14] + a[1] * a[13] + a[2] * a[12] + a[3] * a[11] + a[4] * a[10] + a[5] * a[9] + a[6] * a[8]) + a[7] * a[7];
        long c15 = 2L * (a[0] * a[15] + a[1] * a[14] + a[2] * a[13] + a[3] * a[12] + a[4] * a[11] + a[5] * a[10] + a[6] * a[9] + a[7] * a[8]);
        long c16 = 2L * (a[0] * a[16] + a[1] * a[15] + a[2] * a[14] + a[3] * a[13] + a[4] * a[12] + a[5] * a[11] + a[6] * a[10] + a[7] * a[9]) + a[8] * a[8];
        long c17 = 2L * (a[0] * a[17] + a[1] * a[16] + a[2] * a[15] + a[3] * a[14] + a[4] * a[13] + a[5] * a[12] + a[6] * a[11] + a[7] * a[10] + a[8] * a[9]);
        long c18 = 2L * (a[0] * a[18] + a[1] * a[17] + a[2] * a[16] + a[3] * a[15] + a[4] * a[14] + a[5] * a[13] + a[6] * a[12] + a[7] * a[11] + a[8] * a[10]) + a[9] * a[9];
        long c19 = 2L * (a[1] * a[18] + a[2] * a[17] + a[3] * a[16] + a[4] * a[15] + a[5] * a[14] + a[6] * a[13] + a[7] * a[12] + a[8] * a[11] + a[9] * a[10]);
        long c20 = 2L * (a[2] * a[18] + a[3] * a[17] + a[4] * a[16] + a[5] * a[15] + a[6] * a[14] + a[7] * a[13] + a[8] * a[12] + a[9] * a[11]) + a[10] * a[10];
        long c21 = 2L * (a[3] * a[18] + a[4] * a[17] + a[5] * a[16] + a[6] * a[15] + a[7] * a[14] + a[8] * a[13] + a[9] * a[12] + a[10] * a[11]);
        long c22 = 2L * (a[4] * a[18] + a[5] * a[17] + a[6] * a[16] + a[7] * a[15] + a[8] * a[14] + a[9] * a[13] + a[10] * a[12]) + a[11] * a[11];
        long c23 = 2L * (a[5] * a[18] + a[6] * a[17] + a[7] * a[16] + a[8] * a[15] + a[9] * a[14] + a[10] * a[13] + a[11] * a[12]);
        long c24 = 2L * (a[6] * a[18] + a[7] * a[17] + a[8] * a[16] + a[9] * a[15] + a[10] * a[14] + a[11] * a[13]) + a[12] * a[12];
        long c25 = 2L * (a[7] * a[18] + a[8] * a[17] + a[9] * a[16] + a[10] * a[15] + a[11] * a[14] + a[12] * a[13]);
        long c26 = 2L * (a[8] * a[18] + a[9] * a[17] + a[10] * a[16] + a[11] * a[15] + a[12] * a[14]) + a[13] * a[13];
        long c27 = 2L * (a[9] * a[18] + a[10] * a[17] + a[11] * a[16] + a[12] * a[15] + a[13] * a[14]);
        long c28 = 2L * (a[10] * a[18] + a[11] * a[17] + a[12] * a[16] + a[13] * a[15]) + a[14] * a[14];
        long c29 = 2L * (a[11] * a[18] + a[12] * a[17] + a[13] * a[16] + a[14] * a[15]);
        long c30 = 2L * (a[12] * a[18] + a[13] * a[17] + a[14] * a[16]) + a[15] * a[15];
        long c31 = 2L * (a[13] * a[18] + a[14] * a[17] + a[15] * a[16]);
        long c32 = 2L * (a[14] * a[18] + a[15] * a[17]) + a[16] * a[16];
        long c33 = 2L * (a[15] * a[18] + a[16] * a[17]);
        long c34 = 2L * (a[16] * a[18]) + a[17] * a[17];
        long c35 = 2L * (a[17] * a[18]);
        long c36 = a[18] * a[18];
        this.carryReduce(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30, c31, c32, c33, c34, c35, c36);
    }
}

