/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.Extension;
import com.tencent.kona.sun.security.x509.OIDMap;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CRLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class CRLExtensions {
    private final Map<String, Extension> map = Collections.synchronizedMap(new TreeMap());
    private boolean unsupportedCritExt = false;
    private static final Class<?>[] PARAMS = new Class[]{Boolean.class, Object.class};

    public CRLExtensions() {
    }

    public CRLExtensions(DerInputStream in) throws CRLException {
        this.init(in);
    }

    private void init(DerInputStream derStrm) throws CRLException {
        try {
            DerInputStream str = derStrm;
            byte nextByte = (byte)derStrm.peekByte();
            if ((nextByte & 0xC0) == 128 && (nextByte & 0x1F) == 0) {
                DerValue val = str.getDerValue();
                str = val.data;
            }
            DerValue[] exts = str.getSequence(5);
            for (int i = 0; i < exts.length; ++i) {
                Extension ext = new Extension(exts[i]);
                this.parseExtension(ext);
            }
        }
        catch (IOException e) {
            throw new CRLException("Parsing error: " + e.toString());
        }
    }

    private void parseExtension(Extension ext) throws CRLException {
        try {
            Class<?> extClass = OIDMap.getClass(ext.getExtensionId());
            if (extClass == null) {
                if (ext.isCritical()) {
                    this.unsupportedCritExt = true;
                }
                if (this.map.put(ext.getExtensionId().toString(), ext) != null) {
                    throw new CRLException("Duplicate extensions not allowed");
                }
                return;
            }
            Constructor<?> cons = extClass.getConstructor(PARAMS);
            Object[] passed = new Object[]{ext.isCritical(), ext.getExtensionValue()};
            Extension crlExt = (Extension)cons.newInstance(passed);
            if (this.map.put(crlExt.getName(), crlExt) != null) {
                throw new CRLException("Duplicate extensions not allowed");
            }
        }
        catch (InvocationTargetException invk) {
            throw new CRLException(invk.getCause().getMessage());
        }
        catch (Exception e) {
            throw new CRLException(e.toString());
        }
    }

    public void encode(DerOutputStream out, boolean isExplicit) {
        DerOutputStream extOut = new DerOutputStream();
        for (Extension ext : this.map.values()) {
            ext.encode(extOut);
        }
        DerOutputStream seq = new DerOutputStream();
        seq.write((byte)48, extOut);
        DerOutputStream tmp = new DerOutputStream();
        if (isExplicit) {
            tmp.write(DerValue.createTag((byte)-128, true, (byte)0), seq);
        } else {
            tmp = seq;
        }
        byte[] bytes = tmp.toByteArray();
        out.write(bytes, 0, bytes.length);
    }

    public Extension getExtension(String alias) {
        String name;
        if (alias.startsWith("x509")) {
            int index = alias.lastIndexOf(46);
            name = alias.substring(index + 1);
        } else {
            name = alias;
        }
        return this.map.get(name);
    }

    public void setExtension(String alias, Extension ext) {
        this.map.put(alias, ext);
    }

    public void delete(String alias) {
        this.map.remove(alias);
    }

    public Collection<Extension> getAllExtensions() {
        return this.map.values();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.unsupportedCritExt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CRLExtensions)) {
            return false;
        }
        CRLExtensions otherCX = (CRLExtensions)other;
        Collection<Extension> otherX = otherCX.getAllExtensions();
        if (otherX.size() != this.map.size()) {
            return false;
        }
        for (Extension otherExt : otherX) {
            String key = otherExt.getName();
            Extension thisExt = this.map.get(key);
            if (thisExt == null) {
                return false;
            }
            if (thisExt.equals(otherExt)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

